/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph.figures.primitives;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.xtext.xtext.ui.graph.figures.IEObjectReferer;
import org.eclipse.xtext.xtext.ui.graph.figures.ILayoutConstants;
import org.eclipse.xtext.xtext.ui.graph.figures.ISelectable;
import org.eclipse.xtext.xtext.ui.graph.figures.primitives.CrossPoint;

public abstract class AbstractNode
extends CrossPoint
implements IEObjectReferer,
ISelectable {
    public static final int PADDING = 5;
    private Label label;
    private boolean isSelected = false;
    private URI grammarElementURI;
    private Region textRegion;

    protected AbstractNode(EObject eObject, String text, Font font, Region textRegion) {
        if (eObject != null) {
            this.grammarElementURI = EcoreUtil.getURI((EObject)eObject);
        }
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.setBackgroundColor(this.getUnselectedBackgroundColor());
        this.label = new Label(text);
        this.add((IFigure)this.label);
        this.setBorder(this.createBorder());
        this.setFont(font);
        this.textRegion = textRegion;
    }

    protected abstract Border createBorder();

    public void setFont(Font f) {
        super.setFont(f);
        this.label.setFont(f);
    }

    @Override
    public void setSelected(boolean isSelected) {
        if (isSelected != this.isSelected) {
            if (isSelected) {
                this.setBackgroundColor(this.getSelectedBackgroundColor());
            } else {
                this.setBackgroundColor(this.getUnselectedBackgroundColor());
            }
            this.isSelected = isSelected;
            this.invalidate();
        }
    }

    protected Color getSelectedBackgroundColor() {
        return ILayoutConstants.NODE_SELECTION_COLOR;
    }

    protected Color getUnselectedBackgroundColor() {
        return ColorConstants.buttonLightest;
    }

    @Override
    public URI getEObjectURI() {
        return this.grammarElementURI;
    }

    @Override
    public Region getTextRegion() {
        return this.textRegion;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public boolean isSelectable() {
        return true;
    }
}

