/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.widgets.celleditors.ecore.composite;

import org.eclipse.modisco.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class BooleanComposite
extends AbstractCellEditorComposite<Boolean> {
    private Combo combo = null;
    private boolean enableSelectionListener = true;
    private Control parentControl = null;

    public BooleanComposite(Composite parent) {
        this(parent, 0);
    }

    public BooleanComposite(Composite parent, int style) {
        super(parent, style);
        this.parentControl = parent;
        GridLayout gd = new GridLayout(1, false);
        gd.marginHeight = 0;
        gd.marginWidth = 0;
        gd.horizontalSpacing = 0;
        this.setLayout((Layout)gd);
        this.combo = new Combo((Composite)this, 8);
        this.combo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.combo.setItems(new String[]{"true", "false"});
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && event.stateMask == 0) {
                    BooleanComposite.this.commit();
                } else if (event.keyCode == 27 && event.stateMask == 0 || event.keyCode == 0x1000050 && event.stateMask == 0) {
                    BooleanComposite.this.close();
                }
                BooleanComposite.this.setEnableSelectionListener(false);
            }
        });
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BooleanComposite.this.getEnableSelectionListener()) {
                    BooleanComposite.this.fireChanged();
                    BooleanComposite.this.commit();
                    super.widgetSelected(e);
                }
                BooleanComposite.this.setEnableSelectionListener(true);
            }
        });
        final Listener clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget).getShell() == BooleanComposite.this.getParentControl().getShell() && event.widget != BooleanComposite.this.getCombo()) {
                    BooleanComposite.this.commit();
                }
            }
        };
        Display.getDefault().addFilter(3, clickListener);
        this.getCombo().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getDefault().removeFilter(3, clickListener);
            }
        });
        this.combo.forceFocus();
    }

    protected void commit() {
        this.fireCommit();
    }

    public Boolean getValue() {
        if (this.combo.getSelectionIndex() == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setValue(Boolean value) {
        if (value != null) {
            if (value.booleanValue()) {
                this.combo.select(0);
            } else {
                this.combo.select(1);
            }
        }
    }

    protected Combo getCombo() {
        return this.combo;
    }

    protected boolean getEnableSelectionListener() {
        return this.enableSelectionListener;
    }

    protected void setEnableSelectionListener(boolean value) {
        this.enableSelectionListener = value;
    }

    protected Control getParentControl() {
        return this.parentControl;
    }
}

