/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.Util;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.emf.commands.CreateEAnnotationCommand;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AnnotationModelElement;
import org.eclipse.papyrus.infra.properties.ui.modelelement.AnnotationModelElementFactory;
import org.eclipse.papyrus.infra.ui.emf.databinding.AnnotationObservableValue;

public class BehaviorDisplayHelper
extends AnnotationModelElementFactory {
    private static final String DISPLAY_BEHAVIOR = "displayBehavior";

    protected AnnotationModelElement doCreateFromSource(Object sourceElement, DataContextElement context) {
        View source = NotationHelper.findView((Object)sourceElement);
        if (source == null) {
            Activator.log.warn("Unable to resolve the selected element to an EObject");
            return null;
        }
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)source);
        return new AnnotationModelElement((EModelElement)source, domain, DISPLAY_BEHAVIOR){

            public IObservable doGetObservable(String propertyPath) {
                return new BehaviorObservableValue(this.source, this.domain, BehaviorDisplayHelper.DISPLAY_BEHAVIOR, BehaviorDisplayHelper.DISPLAY_BEHAVIOR);
            }
        };
    }

    public static Command getChangeDisplayBehaviorCommand(TransactionalEditingDomain domain, View source, final Object display) {
        return new CreateEAnnotationCommand(domain, (EModelElement)source, DISPLAY_BEHAVIOR){

            protected void doExecute() {
                EAnnotation annotation = this.createEAnnotation();
                this.replaceEannotation(annotation, this.getObject());
                this.replaceEntry(annotation, BehaviorDisplayHelper.DISPLAY_BEHAVIOR, display == null ? "" : display.toString());
            }
        };
    }

    public static final boolean isDisplayBehaviorChanged(Notification msg) {
        if (msg == null || !(msg.getNewValue() instanceof EAnnotation)) {
            return false;
        }
        EAnnotation anno = (EAnnotation)msg.getNewValue();
        return DISPLAY_BEHAVIOR.equals(anno.getSource());
    }

    public static final boolean shouldDisplayBehavior(View view) {
        EAnnotation anno;
        if (view != null && (anno = view.getEAnnotation(DISPLAY_BEHAVIOR)) != null) {
            return !"false".equalsIgnoreCase((String)anno.getDetails().get((Object)DISPLAY_BEHAVIOR));
        }
        return true;
    }

    private static class BehaviorObservableValue
    extends AnnotationObservableValue {
        private Object cacheValue = "true";
        private Adapter sourceListener;

        public BehaviorObservableValue(EModelElement source, EditingDomain domain, String annotationName, String key) {
            super(source, domain, annotationName, key);
            source.eAdapters().add((Object)this.getSourceListener());
        }

        public Adapter getSourceListener() {
            if (this.sourceListener == null) {
                this.sourceListener = new EContentAdapter(){

                    public void notifyChanged(Notification msg) {
                        super.notifyChanged(msg);
                        if (msg.getNotifier() instanceof EAnnotation) {
                            Object feature = msg.getFeature();
                            if (EcorePackage.eINSTANCE.getEAnnotation_Details() == feature && BehaviorDisplayHelper.DISPLAY_BEHAVIOR.equals(((EAnnotation)msg.getNotifier()).getSource())) {
                                this.setValue(BehaviorDisplayHelper.shouldDisplayBehavior((View)source));
                            }
                        }
                    }
                };
            }
            return this.sourceListener;
        }

        protected void doSetValue(Object value) {
            Object realValue = this.doGetValue();
            if (!Util.equals((Object)realValue, (Object)value)) {
                this.source.eAdapters().remove((Object)this.sourceListener);
                super.doSetValue(value);
                this.source.eAdapters().add((Object)this.getSourceListener());
            }
            if (!Util.equals((Object)this.cacheValue, (Object)value)) {
                ValueDiff diff = Diffs.createValueDiff((Object)this.cacheValue, (Object)value);
                this.fireValueChange(diff);
                this.cacheValue = value;
            }
        }

        protected Command getCommand(Object value) {
            return BehaviorDisplayHelper.getChangeDisplayBehaviorCommand((TransactionalEditingDomain)this.domain, (View)this.source, value);
        }

        protected Object doGetValue() {
            Object value = super.doGetValue();
            if (value == null) {
                return "true";
            }
            return value;
        }

        public synchronized void dispose() {
            if (this.source != null) {
                this.source.eAdapters().remove((Object)this.sourceListener);
            }
            super.dispose();
        }
    }
}

