/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.visitor.Visitor;

public class Quote
extends VariableBase {
    public static final int QT_QUOTE = 0;
    public static final int QT_SINGLE = 1;
    public static final int QT_HEREDOC = 2;
    public static final int QT_NOWDOC = 3;
    private final ASTNode.NodeList<Expression> expressions = new ASTNode.NodeList(this, EXPRESSIONS_PROPERTY);
    private int quoteType;
    public static final ChildListPropertyDescriptor EXPRESSIONS_PROPERTY = new ChildListPropertyDescriptor(Quote.class, "expressions", Expression.class, true);
    public static final SimplePropertyDescriptor QUOTE_TYPE_PROPERTY = new SimplePropertyDescriptor(Quote.class, "quoteType", Integer.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(2);
        properyList.add(EXPRESSIONS_PROPERTY);
        properyList.add(QUOTE_TYPE_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public Quote(AST ast) {
        super(ast);
    }

    public Quote(int start, int end, AST ast, List<Expression> expressions, int type) {
        super(start, end, ast);
        this.expressions.addAll(expressions);
        this.setQuoteType(type);
    }

    public static String getType(int type) {
        switch (type) {
            case 0: {
                return "quote";
            }
            case 1: {
                return "single";
            }
            case 2: {
                return "heredoc";
            }
            case 3: {
                return "nowdoc";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<Quote");
        this.appendInterval(buffer);
        buffer.append(" type='").append(Quote.getType(this.quoteType)).append("'>\n");
        for (ASTNode aSTNode : this.expressions) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</Quote>");
    }

    @Override
    public int getType() {
        return 47;
    }

    public List<Expression> expressions() {
        return this.expressions;
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == EXPRESSIONS_PROPERTY) {
            return this.expressions();
        }
        return super.internalGetChildListProperty(property);
    }

    public int getQuoteType() {
        return this.quoteType;
    }

    public final void setQuoteType(int value) {
        if (value != 2 && value != 0 && value != 1 && value != 3) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(QUOTE_TYPE_PROPERTY);
        this.quoteType = value;
        this.postValueChange(QUOTE_TYPE_PROPERTY);
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        if (property == QUOTE_TYPE_PROPERTY) {
            if (get) {
                return this.getQuoteType();
            }
            this.setQuoteType(value);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, value);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        int type = this.getQuoteType();
        List<Expression> expressions = ASTNode.copySubtrees(target, this.expressions());
        Quote result = new Quote(this.getStart(), this.getEnd(), target, expressions, type);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

