/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.persistence.RSEEnvelope;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SystemExportConnectionAction
extends SystemBaseAction {
    public SystemExportConnectionAction() {
        super(SystemResources.RESID_EXPORT_CONNECTIONS_ACTION_LABEL, SystemResources.RESID_EXPORT_CONNECTION_ACTIONS_TOOLTIP, null);
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.ui.ActionExportConnectionDefinitions");
    }

    public boolean checkObjectType(Object obj) {
        boolean result = obj instanceof IHost;
        return result;
    }

    public void run() {
        FileDialog saveDialog = new FileDialog(this.shell, 8192);
        String path = saveDialog.open();
        if (path != null) {
            File outFile = new File(path);
            boolean ok = true;
            if (outFile.exists()) {
                String message;
                String title;
                if (outFile.canWrite()) {
                    title = SystemResources.SystemExportConnectionAction_Warning;
                    message = MessageFormat.format((String)SystemResources.SystemExportConnectionAction_OverwriteFileCondition, (Object[])new String[]{path});
                    ok = MessageDialog.openConfirm((Shell)this.shell, (String)title, (String)message);
                } else {
                    title = SystemResources.SystemExportConnectionAction_Error;
                    message = MessageFormat.format((String)SystemResources.SystemExportConnectionAction_WriteProtectedFileCondition, (Object[])new String[]{path});
                    MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
                    ok = false;
                }
            }
            if (ok) {
                IStructuredSelection selection = this.getSelection();
                Assert.isTrue((selection.size() == 1 ? 1 : 0) != 0, (String)"selection size should be one");
                IHost host = (IHost)selection.getFirstElement();
                ExportJob exportJob = new ExportJob(host, outFile);
                exportJob.schedule();
            }
        }
    }

    private class ExportJob
    extends Job {
        private File outFile;
        private IHost host;

        public ExportJob(IHost host, File outFile) {
            super(SystemResources.SystemExportConnectionAction_ExportJobName);
            this.outFile = outFile;
            this.host = host;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            IRSEPersistenceManager manager = RSECorePlugin.getThePersistenceManager();
            IRSEPersistenceProvider persistenceProvider = manager.getPersistenceProvider("org.eclipse.rse.persistence.PropertyFileProvider");
            RSEEnvelope envelope = new RSEEnvelope();
            envelope.add(this.host);
            try {
                FileOutputStream out = new FileOutputStream(this.outFile);
                envelope.put((OutputStream)out, persistenceProvider, monitor);
                out.close();
            }
            catch (FileNotFoundException e) {
                SystemBasePlugin.logError(SystemResources.SystemExportConnectionAction_UnexpectedException, e);
            }
            catch (CoreException e) {
                SystemBasePlugin.logError(SystemResources.SystemExportConnectionAction_CoreExceptionFound, e);
                status = e.getStatus();
            }
            catch (IOException e) {
                SystemBasePlugin.logError(SystemResources.SystemExportConnectionAction_UnexpectedException, e);
            }
            return status;
        }
    }
}

