/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.sections;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.controls.AbstractContextSelectorControl;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractContextSelectorSection
extends AbstractSection
implements IDataExchangeNode {
    protected AbstractContextSelectorControl selector;

    protected boolean doShowRefreshAction() {
        return false;
    }

    public AbstractContextSelectorSection(IManagedForm form, Composite parent, int style) {
        super(form, parent, style);
        this.getSection().setBackground(parent.getBackground());
        this.createClient(this.getSection(), form.getToolkit());
    }

    public AbstractContextSelectorSection(IManagedForm form, Composite parent) {
        this(form, parent, 66);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.AbstractContextSelectorSection_title);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 1, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        client.setBackground(section.getBackground());
        this.createSectionToolbar(section, toolkit);
        this.selector = this.doCreateContextSelector();
        this.doConfigureContextSelector(this.selector);
        this.selector.setFormToolkit(toolkit);
        this.selector.setupPanel(client);
        this.setIsUpdating(false);
    }

    protected abstract AbstractContextSelectorControl doCreateContextSelector();

    protected abstract void doConfigureContextSelector(AbstractContextSelectorControl var1);

    public AbstractContextSelectorControl getSelectorControl() {
        return this.selector;
    }

    public Object getAdapter(Class adapter) {
        if (AbstractContextSelectorControl.class.isAssignableFrom(adapter)) {
            return this.selector;
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        if (this.selector != null) {
            this.selector.dispose();
            this.selector = null;
        }
        super.dispose();
    }

    protected void createSectionToolbarItems(Section section, FormToolkit toolkit, ToolBarManager tlbMgr) {
        super.createSectionToolbarItems(section, toolkit, tlbMgr);
        if (this.doShowRefreshAction()) {
            tlbMgr.add((IAction)new RefreshAction());
        }
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        if (valid && !(valid = this.selector.isValid())) {
            this.setMessage(this.selector.getMessage(), this.selector.getMessageType());
        }
        return valid;
    }

    public abstract void dataChanged();

    protected class RefreshAction
    extends Action {
        public RefreshAction() {
            super(null, 1);
            this.setImageDescriptor(UIPlugin.getImageDescriptor("RefreshAction_enabled"));
            this.setToolTipText(Messages.AbstractContextSelectorSection_toolbar_refresh_tooltip);
        }

        public void run() {
            if (AbstractContextSelectorSection.this.selector != null && AbstractContextSelectorSection.this.selector.getViewer() != null) {
                AbstractContextSelectorSection.this.selector.getViewer().refresh();
            }
        }
    }
}

