/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.animation.Duration;
import org.eclipse.xwt.animation.TimeSpan;

public class RepeatBehavior {
    private double count = 1.0;
    private Duration repeatDuration;
    private RepeatBehaviorType type;
    private static RepeatBehavior forever = new RepeatBehavior();
    public static final RepeatBehavior once;

    static {
        RepeatBehavior.forever.type = RepeatBehaviorType.Forever;
        once = new RepeatBehavior(1.0);
    }

    RepeatBehavior() {
    }

    public RepeatBehavior(double count) {
        if (Double.isInfinite(count) || Double.isNaN(count) || count < 0.0) {
            throw new IllegalArgumentException("count: " + count);
        }
        this.repeatDuration = new Duration(new TimeSpan(0L));
        this.count = count;
        this.type = RepeatBehaviorType.IterationCount;
    }

    public RepeatBehavior(Duration duration) {
        this.count = 0.0;
        this.repeatDuration = duration;
        this.type = RepeatBehaviorType.RepeatDuration;
    }

    public boolean equals(Object value) {
        if (value instanceof RepeatBehavior) {
            return this.equals((RepeatBehavior)value);
        }
        return false;
    }

    public boolean equals(RepeatBehavior repeatBehavior) {
        if (this.type == repeatBehavior.type) {
            switch (this.type) {
                case IterationCount: {
                    return this.count == repeatBehavior.count;
                }
                case RepeatDuration: {
                    return this.repeatDuration == repeatBehavior.repeatDuration;
                }
                case Forever: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean equals(RepeatBehavior repeatBehavior1, RepeatBehavior repeatBehavior2) {
        return repeatBehavior1.equals(repeatBehavior2);
    }

    public int hashCode() {
        switch (this.type) {
            case IterationCount: {
                return (int)this.count;
            }
            case RepeatDuration: {
                return this.repeatDuration.hashCode();
            }
            case Forever: {
                return 2147483605;
            }
        }
        return super.hashCode();
    }

    String internalToString(String format, IFormatProvider formatProvider) {
        switch (this.type) {
            case IterationCount: {
                StringBuilder builder1 = new StringBuilder();
                return builder1.toString();
            }
            case RepeatDuration: {
                return this.repeatDuration.toString();
            }
            case Forever: {
                return "Forever";
            }
        }
        return null;
    }

    public static boolean opEquality(RepeatBehavior repeatBehavior1, RepeatBehavior repeatBehavior2) {
        return repeatBehavior1.equals(repeatBehavior2);
    }

    public static boolean opInequality(RepeatBehavior repeatBehavior1, RepeatBehavior repeatBehavior2) {
        return !repeatBehavior1.equals(repeatBehavior2);
    }

    public String toString(String format, IFormatProvider formatProvider) {
        return this.internalToString(format, formatProvider);
    }

    public String toString() {
        return this.internalToString(null, null);
    }

    public String toString(IFormatProvider formatProvider) {
        return this.internalToString(null, formatProvider);
    }

    public double getCount() {
        if (this.type != RepeatBehaviorType.IterationCount) {
            throw new UnsupportedOperationException();
        }
        return this.count;
    }

    public Duration getDuration() {
        if (this.type != RepeatBehaviorType.RepeatDuration) {
            throw new UnsupportedOperationException();
        }
        return this.repeatDuration;
    }

    public static RepeatBehavior getForever() {
        return forever;
    }

    public boolean getHasCount() {
        return this.type == RepeatBehaviorType.IterationCount;
    }

    public boolean getHasDuration() {
        return this.type == RepeatBehaviorType.RepeatDuration;
    }

    public RepeatBehaviorType getRepeatBehaviorType() {
        return this.type;
    }

    public static RepeatBehavior parse(String string) {
        if (string.toLowerCase().equals("forever")) {
            return RepeatBehavior.getForever();
        }
        if (string.toLowerCase().endsWith("x")) {
            string = string.substring(0, string.length() - 1);
            double count = Double.parseDouble(string);
            return new RepeatBehavior(count);
        }
        return new RepeatBehavior(new Duration(TimeSpan.parse(string)));
    }

    static interface IFormatProvider {
    }

    static enum RepeatBehaviorType {
        IterationCount,
        RepeatDuration,
        Forever;

    }
}

