/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.msw.build;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.msw.build.MSVCToolChainInfo;
import org.eclipse.cdt.internal.msw.build.ProcessOutputUtil;

public class VSInstallation {
    private String fLocation;
    private List<MSVCToolChainInfo> fToolChains = null;

    VSInstallation(String location) {
        this.fLocation = location;
    }

    private static String getSingleLineOutputFromCommand(String ... command) {
        String[] allOutput = ProcessOutputUtil.getAllOutputFromCommand(command);
        if (allOutput == null || allOutput.length != 1 || allOutput[0].isEmpty()) {
            return null;
        }
        return allOutput[0];
    }

    private void detectToolchains() {
        String vcEnvPath;
        this.fToolChains = new ArrayList<MSVCToolChainInfo>();
        String vcVarsLocation = String.valueOf(this.fLocation) + "\\VC\\Auxiliary\\Build\\vcvarsall.bat";
        String arch = "amd64";
        String vcVarsLocationCommands = "\"" + vcVarsLocation + "\" " + "amd64";
        String includeEnvVar = VSInstallation.getSingleLineOutputFromCommand("cmd", "/v", "/c", "\"" + vcVarsLocationCommands + " > nul && echo !INCLUDE!\"");
        if (includeEnvVar == null) {
            return;
        }
        String libEnvVar = VSInstallation.getSingleLineOutputFromCommand("cmd", "/v", "/c", "\"" + vcVarsLocationCommands + " > nul && echo !LIB!\"");
        if (libEnvVar == null) {
            return;
        }
        String normalPathVar = VSInstallation.getSingleLineOutputFromCommand("cmd", "/c", "echo %PATH%");
        if (normalPathVar == null) {
            return;
        }
        if (normalPathVar.equals("%PATH%")) {
            normalPathVar = "";
        }
        if ((vcEnvPath = VSInstallation.getSingleLineOutputFromCommand("cmd", "/v", "/c", "\"" + vcVarsLocationCommands + " > nul && echo !PATH!\"")) == null) {
            return;
        }
        String vcEnvPathOnly = vcEnvPath.replaceFirst(Pattern.quote(normalPathVar), "");
        if (vcEnvPathOnly.isEmpty()) {
            return;
        }
        this.fToolChains.add(new MSVCToolChainInfo(vcEnvPathOnly, includeEnvVar, libEnvVar));
    }

    public List<MSVCToolChainInfo> getToolchains() {
        if (this.fToolChains == null) {
            this.detectToolchains();
        }
        return Collections.unmodifiableList(this.fToolChains);
    }
}

