/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.cachegrind;

import java.util.Arrays;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.CachegrindLabelProvider;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.Messages;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindFile;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindFunction;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindLine;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.CachegrindOutput;
import org.eclipse.linuxtools.internal.valgrind.cachegrind.model.ICachegrindElement;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.linuxtools.valgrind.ui.CollapseAction;
import org.eclipse.linuxtools.valgrind.ui.ExpandAction;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;

public class CachegrindViewPart
extends ViewPart
implements IValgrindToolView {
    private CachegrindOutput[] outputs;
    private TreeViewer viewer;
    private static final int COLUMN_SIZE = 75;
    private CachegrindLabelProvider labelProvider;
    private CachegrindTreeContentProvider contentProvider;
    private IDoubleClickListener doubleClickListener;
    private ExpandAction expandAction;
    private CollapseAction collapseAction;
    private static final String IR = "Ir";
    private static final String I1MR = "I1mr";
    private static final String ILMR = "ILmr";
    private static final String DR = "Dr";
    private static final String D1MR = "D1mr";
    private static final String DLMR = "DLmr";
    private static final String DW = "Dw";
    private static final String D1MW = "D1mw";
    private static final String DLMW = "DLmw";
    private static final String BC = "Bc";
    private static final String BCM = "Bcm";
    private static final String BI = "Bi";
    private static final String BIM = "Bim";

    public void createPartControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer(top, 66308);
        this.labelProvider = new CachegrindLabelProvider();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.getString("CachegrindViewPart.Location"));
        column.getColumn().setWidth(300);
        column.getColumn().setResizable(true);
        column.getColumn().addSelectionListener(this.getHeaderListener());
        column.setLabelProvider((CellLabelProvider)this.labelProvider);
        this.contentProvider = new CachegrindTreeContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setAutoExpandLevel(2);
        this.doubleClickListener = event -> {
            Object selection = ((StructuredSelection)event.getSelection()).getFirstElement();
            String path = null;
            int line = 0;
            if (selection instanceof CachegrindFile) {
                path = ((CachegrindFile)selection).getPath();
            } else {
                Object object = selection;
                if (object instanceof CachegrindLine) {
                    void element;
                    CachegrindLine cachegrindLine = (CachegrindLine)object;
                    CachegrindLine cfr_ignored_0 = (CachegrindLine)object;
                    CachegrindFile file = (CachegrindFile)element.getParent().getParent();
                    path = file.getPath();
                    line = element.getLine();
                } else {
                    Object object2 = selection;
                    if (object2 instanceof CachegrindFunction) {
                        void function;
                        CachegrindFunction file = (CachegrindFunction)object2;
                        CachegrindFunction cfr_ignored_1 = (CachegrindFunction)object2;
                        path = ((CachegrindFile)function.getParent()).getPath();
                        IAdaptable iAdaptable = function.getModel();
                        if (iAdaptable instanceof ISourceReference) {
                            ISourceReference iSourceReference = (ISourceReference)iAdaptable;
                            ISourceReference cfr_ignored_2 = (ISourceReference)iAdaptable;
                            try {
                                void model;
                                ISourceRange sr = model.getSourceRange();
                                if (sr != null) {
                                    line = sr.getStartLine();
                                }
                            }
                            catch (CModelException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            }
            if (path != null) {
                try {
                    ProfileUIUtils.openEditorAndSelect((String)path, (int)line, (IProject)ValgrindUIPlugin.getDefault().getProfiledProject());
                }
                catch (CoreException | BadLocationException e2) {
                    e2.printStackTrace();
                }
            }
        };
        this.viewer.addDoubleClickListener(this.doubleClickListener);
        this.expandAction = new ExpandAction(this.viewer);
        this.collapseAction = new CollapseAction(this.viewer);
        MenuManager manager = new MenuManager();
        manager.addMenuListener(manager1 -> {
            ITreeSelection selection = this.viewer.getStructuredSelection();
            ICachegrindElement element = (ICachegrindElement)selection.getFirstElement();
            if (this.contentProvider.hasChildren(element)) {
                manager1.add((IAction)this.expandAction);
                manager1.add((IAction)this.collapseAction);
            }
        });
        manager.setRemoveAllWhenShown(true);
        Menu contextMenu = manager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getControl().setMenu(contextMenu);
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public IAction[] getToolbarActions() {
        return null;
    }

    public void refreshView() {
        if (this.outputs != null && this.outputs.length > 0) {
            String[] events = this.outputs[0].getEvents();
            int i = 0;
            while (i < events.length) {
                TreeViewerColumn column = new TreeViewerColumn(this.viewer, 0);
                column.getColumn().setText(events[i]);
                column.getColumn().setWidth(75);
                column.getColumn().setToolTipText(this.getFullEventName(events[i]));
                column.getColumn().setResizable(true);
                column.getColumn().addSelectionListener(this.getHeaderListener());
                column.setLabelProvider((CellLabelProvider)this.labelProvider);
                ++i;
            }
            this.viewer.setInput((Object)this.outputs);
            this.viewer.getTree().layout(true);
        }
    }

    public void setOutputs(CachegrindOutput[] outputs) {
        this.outputs = outputs;
    }

    public CachegrindOutput[] getOutputs() {
        return this.outputs;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public IDoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }

    private SelectionListener getHeaderListener() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            TreeColumn column = (TreeColumn)e.widget;
            Tree tree = this.viewer.getTree();
            if (column.equals(tree.getSortColumn())) {
                int direction = tree.getSortDirection() == 128 ? 1024 : 128;
                tree.setSortDirection(direction);
            } else {
                tree.setSortDirection(128);
            }
            tree.setSortColumn(column);
            this.viewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    Tree tree = ((TreeViewer)viewer).getTree();
                    int direction = tree.getSortDirection();
                    ICachegrindElement o1 = (ICachegrindElement)e1;
                    ICachegrindElement o2 = (ICachegrindElement)e2;
                    long result = 0L;
                    int sortIndex = Arrays.asList(tree.getColumns()).indexOf(tree.getSortColumn());
                    if (sortIndex == 0) {
                        result = o1.compareTo(o2);
                    } else {
                        long[] v1 = null;
                        long[] v2 = null;
                        if (o1 instanceof CachegrindFunction && o2 instanceof CachegrindFunction) {
                            v1 = ((CachegrindFunction)o1).getTotals();
                            v2 = ((CachegrindFunction)o2).getTotals();
                        } else if (o1 instanceof CachegrindLine && o2 instanceof CachegrindLine) {
                            v1 = ((CachegrindLine)o1).getValues();
                            v2 = ((CachegrindLine)o2).getValues();
                        } else if (o1 instanceof CachegrindOutput && o2 instanceof CachegrindOutput) {
                            v1 = ((CachegrindOutput)o1).getSummary();
                            v2 = ((CachegrindOutput)o2).getSummary();
                        }
                        if (v1 != null && v2 != null) {
                            result = v1[sortIndex - 1] - v2[sortIndex - 1];
                        }
                    }
                    long l = result = direction == 128 ? result : -result;
                    if (result > Integer.MAX_VALUE) {
                        result = Integer.MAX_VALUE;
                    } else if (result < Integer.MIN_VALUE) {
                        result = Integer.MIN_VALUE;
                    }
                    return (int)result;
                }
            });
        });
    }

    private String getFullEventName(String event) {
        String result = event;
        if (event.equals(IR)) {
            result = Messages.getString("CachegrindViewPart.Ir_long");
        } else if (event.equals(I1MR)) {
            result = Messages.getString("CachegrindViewPart.I1mr_long");
        } else if (event.equals(ILMR)) {
            result = Messages.getString("CachegrindViewPart.I2mr_long");
        } else if (event.equals(DR)) {
            result = Messages.getString("CachegrindViewPart.Dr_long");
        } else if (event.equals(D1MR)) {
            result = Messages.getString("CachegrindViewPart.D1mr_long");
        } else if (event.equals(DLMR)) {
            result = Messages.getString("CachegrindViewPart.D2mr_long");
        } else if (event.equals(DW)) {
            result = Messages.getString("CachegrindViewPart.Dw_long");
        } else if (event.equals(D1MW)) {
            result = Messages.getString("CachegrindViewPart.D1mw_long");
        } else if (event.equals(DLMW)) {
            result = Messages.getString("CachegrindViewPart.D2mw_long");
        } else if (event.equals(BC)) {
            result = Messages.getString("CachegrindViewPart.Bc_long");
        } else if (event.equals(BCM)) {
            result = Messages.getString("CachegrindViewPart.Bcm_long");
        } else if (event.equals(BI)) {
            result = Messages.getString("CachegrindViewPart.Bi_long");
        } else if (event.equals(BIM)) {
            result = Messages.getString("CachegrindViewPart.Bim_long");
        }
        return result;
    }

    protected static class CachegrindTreeContentProvider
    implements ITreeContentProvider {
        protected CachegrindTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = null;
            if (parentElement instanceof CachegrindOutput[]) {
                result = (CachegrindOutput[])parentElement;
            } else if (parentElement instanceof ICachegrindElement) {
                result = ((ICachegrindElement)parentElement).getChildren();
            }
            return result;
        }

        public Object getParent(Object element) {
            return ((ICachegrindElement)element).getParent();
        }

        public boolean hasChildren(Object element) {
            ICachegrindElement[] children = (ICachegrindElement[])this.getChildren(element);
            return children != null && children.length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

