/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.resources.backend;

import java.io.File;
import java.util.Queue;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.resources.backend.BackendContainer;
import org.eclipse.oomph.resources.backend.BackendException;
import org.eclipse.oomph.resources.backend.BackendFile;
import org.eclipse.oomph.resources.backend.BackendFolder;
import org.eclipse.oomph.resources.backend.BackendSystem;
import org.eclipse.oomph.util.StringUtil;

public abstract class BackendResource {
    public static final String RESOURCE_SCHEME = "archive";
    private final BackendSystem system;
    private final URI systemRelativeURI;

    BackendResource(BackendSystem system, URI systemRelativeURI) {
        this.system = system;
        if (systemRelativeURI.hasTrailingPathSeparator()) {
            systemRelativeURI = systemRelativeURI.trimSegments(1);
        }
        this.systemRelativeURI = systemRelativeURI;
    }

    public final BackendSystem getSystem() {
        return this.system != null ? this.system : (BackendSystem)this;
    }

    public abstract Type getType();

    public final boolean isContainer() {
        return this.getType() != Type.FILE;
    }

    public final String getName() {
        return URI.decode((String)StringUtil.safe((String)this.systemRelativeURI.lastSegment()));
    }

    public final BackendContainer getParent() throws BackendException {
        int segmentCount;
        block5: {
            segmentCount = this.systemRelativeURI.segmentCount();
            if (segmentCount != 0) break block5;
            return null;
        }
        try {
            BackendSystem system = this.getSystem();
            if (segmentCount == 1) {
                return system;
            }
            return system.getFolder(this.systemRelativeURI.trimSegments(1));
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public final URI getAbsoluteURI() throws BackendException {
        try {
            BackendSystem system = this.getSystem();
            String uri = "archive:" + system.getSystemURI() + "!";
            if (!this.systemRelativeURI.isEmpty()) {
                uri = String.valueOf(uri) + "/" + this.systemRelativeURI;
            }
            if (this.isContainer()) {
                uri = String.valueOf(uri) + "/";
            }
            return URI.createURI((String)uri);
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public final URI getSystemRelativeURI() {
        return this.systemRelativeURI;
    }

    public final String getSystemRelativePath() {
        return this.systemRelativeURI.toFileString();
    }

    public final URI getRelativeURI(BackendContainer base) {
        if (base.getSystem() == this.system) {
            URI baseURI = BackendResource.makeAbsolute(base.getSystemRelativeURI()).appendSegment("");
            URI uri = BackendResource.makeAbsolute(this.systemRelativeURI).appendSegment("");
            return uri.deresolve(baseURI, true, true, false).trimSegments(1);
        }
        return null;
    }

    public final String getRelativePath(BackendContainer base) {
        URI relativeURI = this.getRelativeURI(base);
        if (relativeURI != null) {
            return relativeURI.toFileString();
        }
        return null;
    }

    public final boolean isLocal() throws BackendException {
        return this.getLocation() != null;
    }

    public final IPath getLocation() throws BackendException {
        try {
            BackendSystem system = this.getSystem();
            return system.getLocation(this);
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public final boolean exists(IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        try {
            BackendSystem system = this.getSystem();
            return system.exists(this, monitor);
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public final long getLastModified(IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        try {
            BackendSystem system = this.getSystem();
            return system.getLastModified(this, monitor);
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public final Object getDelegate() throws BackendException {
        try {
            BackendSystem system = this.getSystem();
            return system.getDelegate(this);
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public final void accept(Visitor visitor, IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BackendSystem system = this.getSystem();
            system.accept(this, visitor, monitor);
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    abstract void visit(Queue<BackendResource> var1, Visitor var2, IProgressMonitor var3) throws BackendException, OperationCanceledException;

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.system == null ? 0 : this.system.hashCode());
        result = 31 * result + (this.systemRelativeURI == null ? 0 : this.systemRelativeURI.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BackendResource)) {
            return false;
        }
        BackendResource other = (BackendResource)obj;
        if (this.system == null) {
            return this == obj;
        }
        if (this.system != other.system) {
            return false;
        }
        return !(this.systemRelativeURI == null ? other.systemRelativeURI != null : !this.systemRelativeURI.equals(other.systemRelativeURI));
    }

    public final String toString() {
        return this.getAbsoluteURI().toString();
    }

    public static BackendResource get(URI absoluteURI) throws BackendException {
        try {
            URI systemURI;
            URI systemRelativeURI = null;
            String scheme = absoluteURI.scheme();
            if (RESOURCE_SCHEME.equals(scheme)) {
                String authority = absoluteURI.authority();
                if (authority.endsWith("!")) {
                    authority = authority.substring(0, authority.length() - 1);
                }
                systemURI = URI.createURI((String)authority);
                if (absoluteURI.segmentCount() != 0) {
                    systemRelativeURI = URI.createHierarchicalURI((String[])absoluteURI.segments(), null, null);
                }
            } else {
                systemURI = absoluteURI;
            }
            BackendSystem backendSystem = BackendSystem.Registry.INSTANCE.getBackendSystem(systemURI);
            if (systemRelativeURI == null) {
                return backendSystem;
            }
            if (systemRelativeURI.hasTrailingPathSeparator()) {
                return backendSystem.getFolder(systemRelativeURI);
            }
            return backendSystem.getFile(systemRelativeURI);
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public static BackendResource get(String rootFolder) throws BackendException {
        String prefix = "archive:";
        if (rootFolder.startsWith(prefix)) {
            URI uri = URI.createURI((String)rootFolder);
            return BackendResource.get(uri);
        }
        File folder = new File(rootFolder);
        String absolutePath = folder.getAbsolutePath();
        URI fileURI = URI.createFileURI((String)absolutePath);
        URI uri = URI.createURI((String)(String.valueOf(prefix) + fileURI.trimSegments(fileURI.segmentCount()).toString() + "!/")).appendSegments(fileURI.segments());
        if (folder.isDirectory()) {
            uri = uri.appendSegment("");
        }
        return BackendResource.get(uri);
    }

    private static URI makeAbsolute(URI uri) {
        return URI.createHierarchicalURI((String)"absolute", null, null, (String[])uri.segments(), null, null);
    }

    public static enum Type {
        SYSTEM,
        FOLDER,
        FILE;

    }

    public static interface Visitor {
        public boolean visit(BackendSystem var1, IProgressMonitor var2) throws BackendException;

        public boolean visit(BackendFolder var1, IProgressMonitor var2) throws BackendException;

        public boolean visit(BackendFile var1, IProgressMonitor var2) throws BackendException;

        public static class Default
        implements Visitor {
            public boolean visitContainer(BackendContainer container, IProgressMonitor monitor) throws BackendException {
                return this.visitDefault(container, monitor);
            }

            @Override
            public boolean visit(BackendSystem system, IProgressMonitor monitor) throws BackendException {
                return this.visitContainer(system, monitor);
            }

            @Override
            public boolean visit(BackendFolder folder, IProgressMonitor monitor) throws BackendException {
                return this.visitContainer(folder, monitor);
            }

            @Override
            public boolean visit(BackendFile file, IProgressMonitor monitor) throws BackendException {
                return this.visitDefault(file, monitor);
            }

            protected boolean visitDefault(BackendResource resource, IProgressMonitor monitor) {
                return true;
            }
        }
    }
}

