/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.TargetWeaver;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.eclipse.pde.internal.core.util.UtilMessages;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

public class MinimalState {
    protected State fState;
    protected long fId;
    private boolean fEEListChanged = false;
    private String[] fExecutionEnvironments;
    private boolean fNoProfile;
    protected static StateObjectFactory stateObjectFactory = Platform.getPlatformAdmin().getFactory();
    protected String fSystemBundle = "org.eclipse.osgi";

    protected MinimalState(MinimalState state) {
        this.fState = stateObjectFactory.createState(state.fState);
        this.fState.setPlatformProperties(state.fState.getPlatformProperties());
        this.fState.setResolver(Platform.getPlatformAdmin().createResolver());
        this.fId = state.fId;
        this.fEEListChanged = state.fEEListChanged;
        this.fExecutionEnvironments = state.fExecutionEnvironments;
        this.fNoProfile = state.fNoProfile;
        this.fSystemBundle = state.fSystemBundle;
    }

    protected MinimalState() {
    }

    public void addBundle(IPluginModelBase model, boolean update) {
        if (model == null) {
            return;
        }
        BundleDescription desc = model.getBundleDescription();
        long bundleId = desc == null || !update ? -1L : desc.getBundleId();
        try {
            File bundleLocation = new File(model.getInstallLocation());
            BundleDescription newDesc = this.addBundle(bundleLocation, bundleId, this.loadWorkspaceBundleManifest(bundleLocation, model.getUnderlyingResource()));
            model.setBundleDescription(newDesc);
            if (newDesc == null && update) {
                this.fState.removeBundle(desc);
            }
        }
        catch (CoreException e) {
            PDECore.log(e);
            model.setBundleDescription(null);
        }
    }

    private Map<String, String> loadWorkspaceBundleManifest(File bundleLocation, IResource resource) throws CoreException {
        Map<String, String> manifest = ManifestUtils.loadManifest(bundleLocation);
        if (resource == null || this.hasDeclaredRequiredEE(manifest)) {
            return manifest;
        }
        IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
        if (!javaProject.exists()) {
            return manifest;
        }
        IVMInstall projectVmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        IExecutionEnvironment executionEnvironment = Arrays.stream(JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments()).filter(env -> env.isStrictlyCompatible(projectVmInstall)).findFirst().orElse(null);
        if (executionEnvironment != null) {
            manifest.put("Bundle-RequiredExecutionEnvironment", executionEnvironment.getId());
        }
        return manifest;
    }

    private boolean hasDeclaredRequiredEE(Map<String, String> manifest) {
        if (manifest.containsKey("Bundle-RequiredExecutionEnvironment")) {
            return true;
        }
        try {
            String capability = manifest.get("Require-Capability");
            ManifestElement[] header = ManifestElement.parseHeader((String)"Require-Capability", (String)capability);
            if (header != null) {
                if (Arrays.stream(header).map(ManifestElement::getValue).anyMatch("osgi.ee"::equals)) {
                    return true;
                }
            }
            return false;
        }
        catch (BundleException bundleException) {
            return false;
        }
    }

    public BundleDescription addBundle(Map<String, String> manifest, File bundleLocation, long bundleId) throws CoreException {
        try {
            Dictionary dictionaryManifest = FrameworkUtil.asDictionary(manifest);
            BundleDescription descriptor = stateObjectFactory.createBundleDescription(this.fState, dictionaryManifest, bundleLocation.getAbsolutePath(), bundleId == -1L ? this.getNextId() : bundleId);
            if (bundleId == -1L || !this.fState.updateBundle(descriptor)) {
                this.fState.addBundle(descriptor);
            }
            return descriptor;
        }
        catch (BundleException e) {
            MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, NLS.bind((String)UtilMessages.ErrorReadingManifest, (Object)bundleLocation.toString()), null);
            status.add(Status.error((String)e.getMessage()));
            throw new CoreException((IStatus)status);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public BundleDescription addBundle(File bundleLocation, long bundleId) throws CoreException {
        Map<String, String> manifest = ManifestUtils.loadManifest(bundleLocation);
        return this.addBundle(bundleLocation, bundleId, manifest);
    }

    private BundleDescription addBundle(File bundleLocation, long bundleId, Map<String, String> manifest) throws CoreException {
        TargetWeaver.weaveManifest(manifest, bundleLocation);
        BundleDescription desc = this.addBundle(manifest, bundleLocation, bundleId);
        if (desc != null && manifest != null && "true".equals(manifest.get("Eclipse-SystemBundle"))) {
            this.fEEListChanged = true;
            this.fSystemBundle = desc.getSymbolicName();
        }
        if (desc != null) {
            this.addAuxiliaryData(desc, manifest, true);
        }
        return desc;
    }

    protected void addAuxiliaryData(BundleDescription desc, Map<String, String> manifest, boolean hasBundleStructure) {
    }

    public StateDelta resolveState(boolean incremental) {
        return this.internalResolveState(incremental);
    }

    public StateDelta resolveState(String[] symbolicNames) {
        if (this.initializePlatformProperties()) {
            return this.fState.resolve(false);
        }
        ArrayList bundles = new ArrayList();
        String[] stringArray = symbolicNames;
        int n = symbolicNames.length;
        int n2 = 0;
        while (n2 < n) {
            String symbolicName = stringArray[n2];
            BundleDescription[] descriptions = this.fState.getBundles(symbolicName);
            Collections.addAll(bundles, descriptions);
            ++n2;
        }
        return this.fState.resolve(bundles.toArray(new BundleDescription[bundles.size()]));
    }

    private synchronized StateDelta internalResolveState(boolean incremental) {
        boolean fullBuildRequired = this.initializePlatformProperties();
        return this.fState.resolve(incremental && !fullBuildRequired);
    }

    protected boolean initializePlatformProperties() {
        if (this.fExecutionEnvironments == null && !this.fNoProfile) {
            this.setExecutionEnvironments();
        }
        if (this.fEEListChanged) {
            this.fEEListChanged = false;
            Dictionary[] properties = TargetPlatformHelper.getPlatformProperties(this.fExecutionEnvironments, this);
            return this.fState.setPlatformProperties(properties);
        }
        return false;
    }

    public void removeBundleDescription(BundleDescription description) {
        if (description != null) {
            this.fState.removeBundle(description);
        }
    }

    public void updateBundleDescription(BundleDescription description) {
        if (description != null) {
            this.fState.updateBundle(description);
        }
    }

    public State getState() {
        return this.fState;
    }

    private void setExecutionEnvironments() {
        String jreProfile;
        String[] knownExecutionEnviroments = TargetPlatformHelper.getKnownExecutionEnvironments();
        if (knownExecutionEnviroments.length == 0 && (jreProfile = System.getProperty("pde.jreProfile")) != null && !jreProfile.isEmpty() && "none".equals(jreProfile)) {
            this.fNoProfile = true;
        }
        if (!this.fNoProfile) {
            this.fExecutionEnvironments = knownExecutionEnviroments;
        }
        this.fEEListChanged = true;
    }

    public void addBundleDescription(BundleDescription toAdd) {
        if (toAdd != null) {
            this.fState.addBundle(toAdd);
        }
    }

    public long getNextId() {
        return ++this.fId;
    }

    public String getSystemBundle() {
        return this.fSystemBundle;
    }
}

