/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.core;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.viatra.addon.validation.core.Constraint;
import org.eclipse.viatra.addon.validation.core.Violation;
import org.eclipse.viatra.addon.validation.core.violationkey.ViolationKey;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper;

public class MatchUpdateJob
implements Consumer<IPatternMatch> {
    private Constraint constraint;
    private Logger logger;

    public MatchUpdateJob(Constraint constraint, Logger logger) {
        this.constraint = constraint;
        this.logger = logger;
    }

    @Override
    public void accept(IPatternMatch match) {
        Map<String, Object> keyObjectMap = this.constraint.getSpecification().getKeyObjects(match);
        if (!keyObjectMap.isEmpty()) {
            ViolationKey key = this.constraint.getViolationKey(match);
            Violation violation = this.constraint.getViolation(key);
            if (violation == null) {
                violation = new Violation();
                violation.setConstraint(this.constraint);
                violation.setKeyObjects(this.constraint.getSpecification().getKeyObjects(match));
                this.constraint.addViolation(key, violation);
            }
            violation.addMatch(match);
            String message = ViatraQueryRuntimeHelper.getMessage((IPatternMatch)match, (String)this.constraint.getSpecification().getMessageFormat());
            if (!message.equals(violation.getMessage())) {
                violation.setMessage(message);
                violation.notifyListenersViolationMessageUpdated();
            }
        } else {
            this.logger.error((Object)"Error getting Violation key objects!");
        }
    }
}

