/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.gef;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.IDropRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.gef.policy.ComponentFlowLayoutEditPolicy;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

public final class MigLayoutSplitEditPolicy
extends ComponentFlowLayoutEditPolicy {
    private final MigLayoutInfo m_layout;
    private final int m_column;
    private final int m_row;
    private final List<ComponentInfo> m_components;
    private final boolean m_splitted;
    private final boolean m_splittedHorizontally;
    private boolean m_horizontalCommand;

    public MigLayoutSplitEditPolicy(MigLayoutInfo layout, int column, int row) {
        super((JavaInfo)layout);
        this.m_layout = layout;
        this.m_column = column;
        this.m_row = row;
        this.m_components = this.m_layout.getCellComponents(column, row);
        Assert.isTrue((this.m_components.size() != 0 ? 1 : 0) != 0);
        this.m_splitted = this.m_components.size() > 1;
        this.m_splittedHorizontally = MigLayoutInfo.getConstraints(this.m_components.get(0)).isHorizontalSplit();
    }

    protected boolean isHorizontal(Request _request) {
        if (this.m_splitted) {
            return this.m_splittedHorizontally;
        }
        ComponentInfo targetComponent = this.m_components.get(0);
        EditPart targetEditPart = this.getHost().getViewer().getEditPartByModel((Object)targetComponent);
        Figure targetFigure = ((GraphicalEditPart)targetEditPart).getFigure();
        IDropRequest request = (IDropRequest)_request;
        Point location = request.getLocation().getCopy();
        FigureUtils.translateAbsoluteToFigure2((Figure)targetFigure, (Translatable)location);
        Rectangle clientArea = targetFigure.getClientArea().getCopy();
        Rectangle verticalBounds = clientArea.shrink(clientArea.width / 4, 0);
        return !verticalBounds.contains(location);
    }

    protected boolean isGoodReferenceChild(Request request, EditPart editPart) {
        return this.m_components.contains(editPart.getModel());
    }

    public Command getCommand(Request request) {
        this.m_horizontalCommand = this.isHorizontal(request);
        return super.getCommand(request);
    }

    protected void command_CREATE(ComponentInfo newObject, ComponentInfo referenceObject) throws Exception {
        this.m_layout.command_splitCREATE(this.m_column, this.m_row, this.m_horizontalCommand, newObject, referenceObject);
    }

    protected void command_MOVE(ComponentInfo object, ComponentInfo referenceObject) throws Exception {
        this.m_layout.command_splitMOVE(this.m_column, this.m_row, this.m_horizontalCommand, object, referenceObject);
    }
}

