/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.meson.ui.properties;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildCommandLauncher;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.meson.ui.Activator;
import org.eclipse.cdt.meson.ui.properties.IMesonPropertyPageControl;
import org.eclipse.cdt.meson.ui.properties.MesonPropertyCheckbox;
import org.eclipse.cdt.meson.ui.properties.MesonPropertyCombo;
import org.eclipse.cdt.meson.ui.properties.MesonPropertyInteger;
import org.eclipse.cdt.meson.ui.properties.MesonPropertySpecialCheckbox;
import org.eclipse.cdt.meson.ui.properties.MesonPropertyText;
import org.eclipse.cdt.meson.ui.properties.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class MesonPropertyPage
extends PropertyPage {
    private IProject project;
    private List<IMesonPropertyPageControl> componentList = new ArrayList<IMesonPropertyPageControl>();
    private boolean configured;
    private CBuildConfiguration buildConfig;
    private Text envText;
    private Text projText;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        this.project = (IProject)this.getElement();
        try {
            Process p;
            this.buildConfig = (CBuildConfiguration)this.project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class);
            String configName = ((CBuildConfiguration)this.project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class)).getName();
            IPath sourceDir = this.project.getLocation();
            String buildDir = this.project.getLocation().append("build").append(configName).toOSString();
            IPath buildPath = new Path(buildDir).append("build.ninja");
            this.configured = buildPath.toFile().exists();
            if (this.configured) {
                Process p2;
                IPath infoPath = new Path(buildDir).append("meson-info");
                boolean newerMeson = infoPath.toFile().exists();
                if (newerMeson) {
                    IPath optionsPath = infoPath.append("intro-buildoptions.json");
                    if (!optionsPath.toFile().exists()) return null;
                    this.componentList = this.parseInfoOptions(optionsPath, composite);
                    return composite;
                }
                ICommandLauncher launcher = CommandLauncherManager.getInstance().getCommandLauncher((ICBuildConfiguration)this.project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class));
                launcher.setProject(this.project);
                if (launcher instanceof ICBuildCommandLauncher) {
                    ((ICBuildCommandLauncher)launcher).setBuildConfiguration((ICBuildConfiguration)this.buildConfig);
                }
                if ((p2 = launcher.execute((IPath)new Path("meson"), new String[]{"configure", buildDir}, new String[0], sourceDir, (IProgressMonitor)new NullProgressMonitor())) == null) return composite;
                ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                ByteArrayOutputStream stderr2 = new ByteArrayOutputStream();
                int rc = -1;
                try {
                    if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr2, (IProgressMonitor)new NullProgressMonitor()) == 0) {
                        p2.waitFor();
                    }
                    rc = p2.exitValue();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (rc != 0) return composite;
                this.componentList = this.parseConfigureOutput(stdout, composite);
                return composite;
            }
            ICommandLauncher launcher = CommandLauncherManager.getInstance().getCommandLauncher((ICBuildConfiguration)this.project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class));
            launcher.setProject(this.project);
            if (launcher instanceof ICBuildCommandLauncher) {
                ((ICBuildCommandLauncher)launcher).setBuildConfiguration((ICBuildConfiguration)this.buildConfig);
            }
            if ((p = launcher.execute((IPath)new Path("meson"), new String[]{"setup", "-h"}, new String[0], sourceDir, (IProgressMonitor)new NullProgressMonitor())) == null) {
                return null;
            }
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            ByteArrayOutputStream stderr = new ByteArrayOutputStream();
            int rc = -1;
            try {
                if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new NullProgressMonitor()) == 0) {
                    p.waitFor();
                }
                rc = p.exitValue();
            }
            catch (InterruptedException stderr2) {
                // empty catch block
            }
            if (rc != 0) return composite;
            HashMap<String, String> argMap = new HashMap<String, String>();
            String mesonArgs = this.buildConfig.getProperty("meson.arguments");
            if (mesonArgs != null) {
                String[] argStrings;
                String[] stringArray = argStrings = mesonArgs.split("--");
                int n = argStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String argString = stringArray[n2];
                    if (!argString.isEmpty()) {
                        String[] s = argString.split("=");
                        if (s.length == 2) {
                            argMap.put(s[0], s[1].trim());
                        } else {
                            argMap.put(argString.trim(), "true");
                        }
                    }
                    ++n2;
                }
            }
            Group group = new Group(composite, 2048);
            GridLayout layout = new GridLayout(2, true);
            layout.marginLeft = 10;
            layout.marginRight = 10;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(1808));
            group.setText(Messages.MesonPropertyPage_env_group);
            Label envLabel = new Label((Composite)group, 0);
            envLabel.setText(Messages.MesonPropertyPage_env_label);
            GridData data = new GridData(4, 4, true, false);
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 1;
            envLabel.setLayoutData((Object)data);
            String mesonEnv = this.buildConfig.getProperty("meson.environment");
            this.envText = new Text((Composite)group, 2048);
            if (mesonEnv != null) {
                this.envText.setText(mesonEnv);
            }
            this.envText.setToolTipText(Messages.MesonPropertyPage_env_tooltip);
            data = new GridData(4, 4, true, false);
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 1;
            this.envText.setLayoutData((Object)data);
            group = new Group(composite, 2048);
            layout = new GridLayout(2, true);
            layout.marginLeft = 10;
            layout.marginRight = 10;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(1808));
            group.setText(Messages.MesonPropertyPage_project_group);
            Label projLabel = new Label((Composite)group, 0);
            projLabel.setText(Messages.MesonPropertyPage_project_label);
            data = new GridData(4, 4, true, false);
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 1;
            projLabel.setLayoutData((Object)data);
            String mesonProjOptions = this.buildConfig.getProperty("meson.project.options");
            this.projText = new Text((Composite)group, 2048);
            if (mesonProjOptions != null) {
                this.projText.setText(mesonProjOptions);
            }
            this.projText.setToolTipText(Messages.MesonPropertyPage_project_tooltip);
            data = new GridData(4, 4, true, false);
            data.grabExcessHorizontalSpace = true;
            data.horizontalSpan = 1;
            this.projText.setLayoutData((Object)data);
            String defaultBuildType = "release";
            if (configName.contains("debug")) {
                defaultBuildType = "debug";
            }
            if (argMap.get("buildtype") == null) {
                argMap.put("buildtype", defaultBuildType);
            }
            this.componentList = this.parseHelpOutput(stdout, composite, argMap, defaultBuildType);
            return composite;
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        return composite;
    }

    public void update() {
        this.setErrorMessage(null);
        for (IMesonPropertyPageControl control : this.componentList) {
            if (control.isValid()) continue;
            this.setValid(false);
            this.setErrorMessage(control.getErrorMessage());
        }
    }

    public boolean performOk() {
        block24: {
            ArrayList<String> args = new ArrayList<String>();
            if (this.configured) {
                args.add("configure");
                for (IMesonPropertyPageControl control : this.componentList) {
                    if (!control.isValueChanged()) continue;
                    args.add(control.getConfiguredString());
                }
                if (args.size() == 1) {
                    return true;
                }
                try {
                    String configName = ((CBuildConfiguration)this.project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class)).getName();
                    IPath sourceDir = this.project.getLocation();
                    String buildDir = this.project.getLocation().append("build").append(configName).toOSString();
                    ICommandLauncher launcher = CommandLauncherManager.getInstance().getCommandLauncher((ICBuildConfiguration)this.project.getActiveBuildConfig().getAdapter(ICBuildConfiguration.class));
                    launcher.setProject(this.project);
                    if (launcher instanceof ICBuildCommandLauncher) {
                        ((ICBuildCommandLauncher)launcher).setBuildConfiguration((ICBuildConfiguration)this.buildConfig);
                    }
                    args.add(buildDir);
                    Process p = launcher.execute((IPath)new Path("meson"), args.toArray(new String[0]), new String[0], sourceDir, (IProgressMonitor)new NullProgressMonitor());
                    int rc = -1;
                    IConsole console = CCorePlugin.getDefault().getConsole();
                    console.start(this.project);
                    try {
                        Throwable throwable = null;
                        Object var10_16 = null;
                        try (ConsoleOutputStream stdout = console.getOutputStream();){
                            ConsoleOutputStream stderr = stdout;
                            StringBuilder buf = new StringBuilder();
                            for (String arg : args) {
                                buf.append(arg);
                                buf.append(" ");
                            }
                            buf.append(System.lineSeparator());
                            stdout.write(buf.toString().getBytes());
                            stdout.flush();
                            try {
                                if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new NullProgressMonitor()) == 0) {
                                    p.waitFor();
                                }
                                rc = p.exitValue();
                                stdout.write(NLS.bind((String)Messages.MesonPropertyPage_terminated_rc, (Object)rc).getBytes());
                                stdout.flush();
                                if (rc != 0) {
                                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)this.getShell(), null, (String)Messages.MesonPropertyPage_configure_failed));
                                }
                                break block24;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            break block24;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e2) {
                        Activator.log(e2);
                        return false;
                    }
                }
                catch (CoreException e3) {
                    Activator.log((Exception)((Object)e3));
                    return false;
                }
            }
            if (this.buildConfig != null) {
                StringBuilder mesonargs = new StringBuilder();
                for (IMesonPropertyPageControl control : this.componentList) {
                    if (control.getUnconfiguredString().isEmpty()) continue;
                    mesonargs.append(control.getUnconfiguredString());
                    mesonargs.append(" ");
                }
                this.buildConfig.setProperty("meson.arguments", mesonargs.toString());
                this.buildConfig.setProperty("meson.environment", this.envText.getText().trim());
                this.buildConfig.setProperty("meson.project.options", this.projText.getText().trim());
            }
        }
        return true;
    }

    List<IMesonPropertyPageControl> parseHelpOutput(ByteArrayOutputStream stdout, Composite composite, Map<String, String> argMap, String defaultBuildType) {
        ArrayList<IMesonPropertyPageControl> controls = new ArrayList<IMesonPropertyPageControl>();
        Group group = new Group(composite, 2048);
        GridLayout layout = new GridLayout(2, true);
        layout.marginLeft = 10;
        layout.marginRight = 10;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        group.setText(Messages.MesonPropertyPage_options_group);
        try {
            String output = stdout.toString(StandardCharsets.UTF_8.name()).replaceAll("\\r?\\n\\s+", " ");
            String[] lines = output.split("--");
            Pattern optionPattern = Pattern.compile("(([a-z-]+)\\s+(([A-Z_][A-Z_]+))?\\s*(\\{.*?\\})?([^\\[\\]]*))");
            Pattern descPattern1 = Pattern.compile("([^\\.]+).*");
            Pattern descPattern = Pattern.compile("([^\\(]*)(\\(default\\:\\s+([^\\)]+)\\).*)");
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                Matcher optionMatcher = optionPattern.matcher(line);
                if (optionMatcher.matches() && !optionMatcher.group(2).equals("help")) {
                    if (optionMatcher.group(3) != null) {
                        String defaultValue = argMap.get(optionMatcher.group(2));
                        String description = optionMatcher.group(6);
                        Matcher m = descPattern1.matcher(optionMatcher.group(6));
                        if (m.matches()) {
                            description = m.group(1).trim();
                        }
                        MesonPropertyText control = new MesonPropertyText((Composite)group, optionMatcher.group(2), defaultValue, description);
                        controls.add(control);
                    } else if (optionMatcher.group(5) != null) {
                        String defaultValue = argMap.get(optionMatcher.group(2));
                        Matcher m = descPattern.matcher(optionMatcher.group(6));
                        if (m.matches()) {
                            String valueString = optionMatcher.group(5).replaceAll("\\{", "");
                            valueString = valueString.replaceAll("\\}", "");
                            String[] values = valueString.split(",");
                            if (defaultValue == null) {
                                defaultValue = m.group(3).trim();
                            }
                            MesonPropertyCombo control = new MesonPropertyCombo((Composite)group, optionMatcher.group(2), values, defaultValue, m.group(1).trim());
                            controls.add(control);
                        }
                    } else {
                        boolean defaultValue = false;
                        if (argMap.containsKey(optionMatcher.group(2))) {
                            defaultValue = Boolean.parseBoolean(argMap.get(optionMatcher.group(2)));
                        }
                        MesonPropertySpecialCheckbox control = new MesonPropertySpecialCheckbox((Composite)group, optionMatcher.group(2), defaultValue, optionMatcher.group(6));
                        controls.add(control);
                    }
                }
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            return controls;
        }
        return controls;
    }

    List<IMesonPropertyPageControl> parseConfigureOutput(ByteArrayOutputStream stdout, Composite composite) {
        ArrayList<IMesonPropertyPageControl> controls = new ArrayList<IMesonPropertyPageControl>();
        try {
            String[] lines = stdout.toString(StandardCharsets.UTF_8.name()).split("\\r?\\n");
            ParseState state = ParseState.INIT;
            Pattern optionPattern = Pattern.compile(Messages.MesonPropertyPage_option_pattern);
            Pattern optionWithValuesPattern = Pattern.compile(Messages.MesonPropertyPage_option_with_values_pattern);
            Pattern optionLine = Pattern.compile("(\\w+)\\s+([\\w,\\-,/]+)\\s+(.*)$");
            Pattern optionWithValuesLine = Pattern.compile("(\\w+)\\s+([\\w,\\-,/]+)\\s+\\[([\\w,\\-,/]+)((,\\s+[\\w,\\-]+)*)\\]\\s+(.*)$");
            Pattern compilerOrLinkerArgs = Pattern.compile(Messages.MesonPropertyPage_compiler_or_link_args);
            Pattern argLine = Pattern.compile("(\\w+)\\s+\\[([^\\]]*)\\]");
            Pattern groupPattern = Pattern.compile("(([^:]*)):");
            String groupName = "";
            Composite parent = composite;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                line = line.trim();
                boolean unprocessed = true;
                block12: while (unprocessed) {
                    unprocessed = false;
                    switch (state) {
                        case INIT: {
                            Matcher argMatcher = compilerOrLinkerArgs.matcher(line);
                            if (argMatcher.matches()) {
                                state = ParseState.ARGS;
                                Group group = new Group(composite, 2048);
                                group.setLayout((Layout)new GridLayout(2, true));
                                group.setLayoutData((Object)new GridData(1808));
                                group.setText(argMatcher.group(1));
                                parent = group;
                                break;
                            }
                            Matcher groupMatcher = groupPattern.matcher(line);
                            if (groupMatcher.matches()) {
                                groupName = groupMatcher.group(1);
                                state = ParseState.GROUP;
                            }
                            parent = composite;
                            break;
                        }
                        case GROUP: {
                            Group group;
                            Matcher m = optionPattern.matcher(line);
                            if (m.matches()) {
                                state = ParseState.OPTION;
                                if (parent != composite) break;
                                group = new Group(composite, 2048);
                                group.setLayout((Layout)new GridLayout(2, true));
                                group.setLayoutData((Object)new GridData(1808));
                                group.setText(groupName);
                                parent = group;
                                break;
                            }
                            m = optionWithValuesPattern.matcher(line);
                            if (m.matches()) {
                                state = ParseState.OPTION_WITH_VALUES;
                                if (parent != composite) break;
                                group = new Group(composite, 2048);
                                group.setLayout((Layout)new GridLayout(2, true));
                                group.setLayoutData((Object)new GridData(1808));
                                group.setText(groupName);
                                parent = group;
                                break;
                            }
                            if (!line.contains(":")) break;
                            state = ParseState.INIT;
                            unprocessed = true;
                            parent = composite;
                            break;
                        }
                        case ARGS: {
                            Matcher m2 = argLine.matcher(line);
                            if (m2.matches()) {
                                String argName = m2.group(1);
                                String argValue = m2.group(2);
                                argValue = argValue.replaceAll("',", "");
                                argValue = argValue.replaceAll("'", "");
                                String argDescription = Messages.MesonPropertyPage_arg_description;
                                MesonPropertyText argControl = new MesonPropertyText(parent, argName, argValue, argDescription);
                                controls.add(argControl);
                            }
                            state = ParseState.INIT;
                            parent = composite;
                            break;
                        }
                        case OPTION: {
                            Matcher m3 = optionLine.matcher(line);
                            if (line.startsWith("----")) continue block12;
                            if (line.isEmpty()) {
                                state = ParseState.INIT;
                                parent = composite;
                                break;
                            }
                            if (m3.matches()) {
                                IMesonPropertyPageControl control;
                                String name = m3.group(1);
                                String value = m3.group(2);
                                String description = m3.group(3);
                                boolean isInteger = false;
                                try {
                                    Integer.parseInt(value);
                                    isInteger = true;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (isInteger) {
                                    control = new MesonPropertyInteger(parent, this, name, value, description);
                                    controls.add(control);
                                    break;
                                }
                                if (Messages.MesonPropertyPage_true.equals(value) || Messages.MesonPropertyPage_false.equals(value)) {
                                    control = new MesonPropertyCheckbox(parent, name, Boolean.getBoolean(value), description);
                                    controls.add(control);
                                    break;
                                }
                                control = new MesonPropertyText(parent, name, value, description);
                                controls.add(control);
                                break;
                            }
                            if (line.contains(":")) {
                                state = ParseState.INIT;
                                parent = composite;
                                unprocessed = true;
                                break;
                            }
                            state = ParseState.GROUP;
                            unprocessed = true;
                            break;
                        }
                        case OPTION_WITH_VALUES: {
                            Matcher m4 = optionWithValuesLine.matcher(line);
                            if (line.startsWith("----")) continue block12;
                            if (line.isEmpty()) {
                                state = ParseState.INIT;
                                parent = composite;
                                break;
                            }
                            if (m4.matches()) {
                                String name = m4.group(1);
                                String value = m4.group(2);
                                String possibleValue = m4.group(3);
                                String extraValues = m4.group(4);
                                String description = m4.group(6);
                                String[] values = new String[]{possibleValue};
                                if (!extraValues.isEmpty()) {
                                    values = extraValues.split(",\\s+");
                                    values[0] = possibleValue;
                                }
                                MesonPropertyCombo control = new MesonPropertyCombo(parent, name, values, value, description);
                                controls.add(control);
                                break;
                            }
                            if (line.contains(":")) {
                                state = ParseState.INIT;
                                parent = composite;
                                unprocessed = true;
                                break;
                            }
                            state = ParseState.GROUP;
                            unprocessed = true;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            return controls;
        }
        return controls;
    }

    List<IMesonPropertyPageControl> parseInfoOptions(IPath optionsPath, Composite composite) {
        JsonNode root;
        Composite parent;
        ArrayList<IMesonPropertyPageControl> controls;
        block28: {
            controls = new ArrayList<IMesonPropertyPageControl>();
            ObjectMapper mapper = new ObjectMapper();
            parent = composite;
            root = mapper.readTree(optionsPath.toFile());
            if (root.isArray()) break block28;
            return null;
        }
        try {
            String lastSection = "";
            for (JsonNode node : root) {
                IMesonPropertyPageControl control = null;
                String type = node.path("type").asText();
                String section = node.path("section").asText();
                String name = null;
                String value = null;
                String description = null;
                if (!section.equals(lastSection)) {
                    Group group = new Group(composite, 2048);
                    group.setLayout((Layout)new GridLayout(2, true));
                    group.setLayoutData((Object)new GridData(1808));
                    String sectionName = String.valueOf(section) + " options:";
                    sectionName = String.valueOf(sectionName.substring(0, 1).toUpperCase()) + sectionName.substring(1);
                    group.setText(sectionName);
                    parent = group;
                    lastSection = section;
                }
                switch (type) {
                    case "combo": {
                        name = node.path("name").asText();
                        value = node.path("value").asText();
                        description = node.path("description").asText();
                        JsonNode choices = node.path("choices");
                        ArrayList<String> choiceList = new ArrayList<String>();
                        for (JsonNode choiceNode : choices) {
                            String choice = choiceNode.asText();
                            choiceList.add(choice);
                        }
                        control = new MesonPropertyCombo(parent, name, choiceList.toArray(new String[0]), value, description);
                        controls.add(control);
                        break;
                    }
                    case "boolean": {
                        name = node.path("name").asText();
                        value = node.path("value").asText();
                        description = node.path("description").asText();
                        control = new MesonPropertyCheckbox(parent, name, Boolean.getBoolean(value), description);
                        controls.add(control);
                        break;
                    }
                    case "string": {
                        name = node.path("name").asText();
                        value = node.path("value").asText();
                        description = node.path("description").asText();
                        control = new MesonPropertyText(parent, name, value, description);
                        controls.add(control);
                        break;
                    }
                    case "array": {
                        name = node.path("name").asText();
                        value = new String("");
                        for (JsonNode val : node.path("value")) {
                            if (!value.isEmpty()) {
                                value = String.valueOf(value) + ",";
                            }
                            value = String.valueOf(value) + val.asText();
                        }
                        description = node.path("description").asText();
                        control = new MesonPropertyText(parent, name, value, description);
                        controls.add(control);
                        break;
                    }
                    case "integer": {
                        name = node.path("name").asText();
                        value = node.path("value").asText();
                        description = node.path("description").asText();
                        control = new MesonPropertyInteger(parent, this, name, value, description);
                        controls.add(control);
                    }
                }
            }
        }
        catch (JsonProcessingException e) {
            Activator.log((Exception)((Object)e));
        }
        catch (IOException e) {
            Activator.log(e);
        }
        return controls;
    }

    public static enum ParseState {
        INIT,
        GROUP,
        OPTION,
        OPTION_WITH_VALUES,
        ARGS;

    }
}

