/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EmfUtil;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.IViewEObjects;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.EmptyFilterOption;
import org.eclipse.e4.tools.emf.ui.internal.handlers.MarkDuplicateElementIdsHandler;
import org.eclipse.e4.tools.emf.ui.internal.handlers.MarkDuplicateItemsBase;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class RepairDuplicateItemsHandler
extends MarkDuplicateItemsBase {
    public static String name = "org.eclipse.e4.tools.active-object-viewer";
    static String attName = "elementId";

    @Override
    @Execute
    public void execute(IEclipseContext context) {
        IViewEObjects viewer = (IViewEObjects)context.get(name);
        Collection<EObject> all = viewer.getAllEObjects();
        Map<String, List<EObject>> map = MarkDuplicateElementIdsHandler.getDuplicateMap(attName, all);
        Iterator<Map.Entry<String, List<EObject>>> it = map.entrySet().iterator();
        CompoundCommand compoundCommand = new CompoundCommand();
        EditingDomain editingDomain = viewer.getEditingDomain();
        block2: while (it.hasNext()) {
            Map.Entry<String, List<EObject>> entry = it.next();
            List<EObject> listDups = entry.getValue();
            if (listDups.size() <= 1) continue;
            ArrayList<EObject> toFix = new ArrayList<EObject>(listDups.subList(1, listDups.size()));
            for (EObject eObject : toFix) {
                EAttribute att;
                Object value = (String)eObject.eGet((EStructuralFeature)(att = EmfUtil.getAttribute(eObject, attName)));
                if (E.isEmpty((String)value)) continue block2;
                int index = -1;
                while (map.containsKey(value)) {
                    ++index;
                    int lastDot = ((String)value).lastIndexOf(46);
                    if (lastDot == -1) {
                        lastDot = ((String)value).length();
                    }
                    try {
                        String suffix = ((String)value).substring(lastDot + 1);
                        Integer.parseInt(suffix);
                        value = ((String)value).substring(0, lastDot);
                    }
                    catch (Exception exception) {}
                    value = (String)value + "." + index;
                }
                Command cmd = SetCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)att, (Object)value);
                compoundCommand.append(cmd);
                listDups.remove(eObject);
                ArrayList<EObject> newList = new ArrayList<EObject>();
                newList.add(eObject);
                map.put((String)value, newList);
            }
        }
        if (!compoundCommand.isEmpty()) {
            if (compoundCommand.canExecute()) {
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
            Collection<EObject> duplicateList = MarkDuplicateElementIdsHandler.getDuplicateList(attName, all);
            RepairDuplicateItemsHandler.applyEmptyOption(duplicateList, attName, EmptyFilterOption.EXCLUDE);
            viewer.highlightEObjects(duplicateList);
        }
    }

    @CanExecute
    public boolean canExecute(IEclipseContext context) {
        IViewEObjects viewer = (IViewEObjects)context.get(name);
        return viewer != null;
    }
}

