/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.astview.ASTViewPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ASTViewImages {
    private static final IPath ICONS_PATH = new Path("$nl$/icons");
    public static final String COLLAPSE = "collapseall.png";
    public static final String EXPAND = "expandall.png";
    public static final String LINK_WITH_EDITOR = "synced.png";
    public static final String SETFOCUS = "setfocus.png";
    public static final String REFRESH = "refresh.png";
    public static final String CLEAR = "clear.png";
    public static final String ADD_TO_TRAY = "add.png";

    public static void setImageDescriptors(IAction action, String type) {
        ImageDescriptor id = ASTViewImages.create("d", type);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        if ((id = ASTViewImages.create("e", type)) != null) {
            action.setHoverImageDescriptor(id);
            action.setImageDescriptor(id);
        } else {
            action.setImageDescriptor(ImageDescriptor.getMissingImageDescriptor());
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return ASTViewImages.createImageDescriptor(ASTViewPlugin.getDefault().getBundle(), path);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }

    private ASTViewImages() {
    }
}

