/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmPackageBuildProposalsJob;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.FrameworkUtil;

public class RpmPackageProposalsList {
    private final Set<String> list = new HashSet<String>();
    private IPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, FrameworkUtil.getBundle(RpmPackageProposalsList.class).getSymbolicName());

    public RpmPackageProposalsList() {
        String rpmpkgsFile = this.store.getString("rpmListFilePath");
        if (Files.exists(Paths.get(rpmpkgsFile, new String[0]), new LinkOption[0])) {
            try {
                Set<String> newList = RpmPackageBuildProposalsJob.getPackages();
                this.list.clear();
                this.list.addAll(newList);
            }
            catch (IOException e) {
                RpmPackageBuildProposalsJob.update(true);
                SpecfileLog.logError(e);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            RpmPackageBuildProposalsJob.update(true);
        }
    }

    public List<String[]> getProposals(String prefix) {
        int rpmpkgsMaxProposals = this.store.getInt("rpmListMaxProposalsInfo");
        ArrayList<String[]> proposalsList = new ArrayList<String[]>(this.list.size());
        for (String listValue : this.list) {
            String message = String.valueOf(Messages.RpmPackageProposalsList_0) + rpmpkgsMaxProposals + Messages.RpmPackageProposalsList_1;
            String[] item = new String[]{listValue, message};
            if (!item[0].startsWith(prefix)) continue;
            proposalsList.add(item);
        }
        if (proposalsList.size() < rpmpkgsMaxProposals) {
            ArrayList<String[]> proposalsListWithInfo = new ArrayList<String[]>(proposalsList.size());
            for (String[] proposals : proposalsList) {
                proposals[1] = this.getRpmInfo(proposals[0]);
                proposalsListWithInfo.add(proposals);
            }
            return proposalsListWithInfo;
        }
        return proposalsList;
    }

    public String getValue(String key) {
        for (String item : this.list) {
            if (!item.equals(key.trim())) continue;
            return this.getRpmInfo(item);
        }
        return null;
    }

    public String getRpmInfo(String pkgName) {
        String ret = "";
        try {
            ret = Utils.runCommandToString((String[])new String[]{"rpm", "-q", pkgName, "--qf", this.getformattedRpmInformations()});
        }
        catch (IOException e) {
            SpecfileLog.logError(e);
            return String.valueOf(Messages.RpmPackageProposalsList_2) + Messages.RpmPackageProposalsList_3;
        }
        CharsetDecoder decoder = Charset.forName(System.getProperty("file.encoding")).newDecoder();
        CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
        try {
            ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(ret));
            CharBuffer cbuf = decoder.decode(bbuf);
            ret = cbuf.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return ret;
    }

    private String getformattedRpmInformations() {
        StringBuilder formatedInfoString = new StringBuilder();
        if (this.store.getBoolean("RpmInfoName")) {
            formatedInfoString.append("<b>Name: </b>%{NAME}<br>");
        }
        if (this.store.getBoolean("RpmInfoVersion")) {
            formatedInfoString.append("<b>Version: </b>%{VERSION}<br>");
        }
        if (this.store.getBoolean("RpmInfoRelease")) {
            formatedInfoString.append("<b>Release: </b>%{Release}<br>");
        }
        if (this.store.getBoolean("RpmInfoSummary")) {
            formatedInfoString.append("<b>Summary: </b>%{SUMMARY}<br>");
        }
        if (this.store.getBoolean("RpmInfoLicense")) {
            formatedInfoString.append("<b>License: </b>%{LICENSE}<br>");
        }
        if (this.store.getBoolean("RpmInfoName")) {
            formatedInfoString.append("<b>Group: </b>%{GROUP}<br>");
        }
        if (this.store.getBoolean("RpmInfoUrl")) {
            formatedInfoString.append("<b>URL: </b>%{URL}<br>");
        }
        if (this.store.getBoolean("RpmInfoInstallDate")) {
            formatedInfoString.append("<b>Installation Date: </b>%{INSTALLTIME:date}<br>");
        }
        if (this.store.getBoolean("RpmInfoDescription")) {
            formatedInfoString.append("<b>Description: </b>%{DESCRIPTION}<br>");
        }
        if (this.store.getBoolean("RpmInfoPackager")) {
            formatedInfoString.append("<b>Packager: </b>%{PACKAGER}<br>");
        }
        if (this.store.getBoolean("RpmInfoVendor")) {
            formatedInfoString.append("<b>Vendor: </b>%{VENDOR}<br>");
        }
        if (this.store.getBoolean("RpmInfoSize")) {
            formatedInfoString.append("<b>Size: </b>%{SIZE} bytes<br>");
        }
        if (this.store.getBoolean("RpmInfoBuildDate")) {
            formatedInfoString.append("<b>Build Date: </b>%{BUILDTIME:date}<br>");
        }
        if (this.store.getBoolean("RpmInfoSourceRpm")) {
            formatedInfoString.append("<b>SRPM: </b>%{SOURCERPM}<br>");
        }
        return formatedInfoString.toString();
    }
}

