/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.ArrayList;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.outline.LSSymbolsContentProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CNFOutlinePage
implements IContentOutlinePage,
ILabelProviderListener,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String ID = "org.eclipse.lsp4e.outline";
    public static final String LINK_WITH_EDITOR_PREFERENCE = "org.eclipse.lsp4e.outline.linkWithEditor";
    public static final String SHOW_KIND_PREFERENCE = "org.eclipse.lsp4e.outline.showKind";
    public static final String SORT_OUTLINE_PREFERENCE = "org.eclipse.lsp4e.outline.sortOutline";
    private CommonViewer outlineViewer;
    private final IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
    private final ITextEditor textEditor;
    private final ITextViewer textEditorViewer;
    private final IDocument document;
    private final @NonNull LanguageServerWrapper wrapper;
    private EditorSelectionChangedListener editorSelectionChangedListener;

    public CNFOutlinePage(@NonNull LanguageServerWrapper wrapper, @Nullable ITextEditor textEditor) {
        this.preferences.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.textEditor = textEditor;
        this.textEditorViewer = LSPEclipseUtils.getTextViewer((IEditorPart)textEditor);
        this.document = LSPEclipseUtils.getDocument(textEditor);
        this.wrapper = wrapper;
    }

    public void createControl(Composite parent) {
        this.outlineViewer = new CommonViewer(ID, parent, 0);
        if (this.document != null) {
            this.outlineViewer.setInput((Object)new LSSymbolsContentProvider.OutlineViewerInput(this.document, this.wrapper, this.textEditor));
        }
        this.outlineViewer.setSorter((ViewerSorter)new CommonViewerSorter());
        this.outlineViewer.getLabelProvider().addListener((ILabelProviderListener)this);
        if (this.textEditor != null) {
            this.outlineViewer.addOpenListener(event -> {
                if (this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true)) {
                    this.textEditor.setFocus();
                }
            });
            this.outlineViewer.addSelectionChangedListener(event -> {
                Object selection;
                Range range;
                if (this.document != null && this.preferences.getBoolean(LINK_WITH_EDITOR_PREFERENCE, true) && this.outlineViewer.getTree().isFocusControl() && this.outlineViewer.getSelection() != null && (range = this.getRangeSelection(selection = ((TreeSelection)this.outlineViewer.getSelection()).getFirstElement())) != null) {
                    try {
                        int startOffset = this.document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
                        int endOffset = this.document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
                        this.textEditor.selectAndReveal(startOffset, endOffset - startOffset);
                    }
                    catch (BadLocationException e) {
                        return;
                    }
                }
            });
            if (this.textEditorViewer != null) {
                this.editorSelectionChangedListener = new EditorSelectionChangedListener();
                this.editorSelectionChangedListener.install(this.textEditorViewer.getSelectionProvider());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Range getRangeSelection(Object selection) {
        if (selection == null) {
            return null;
        }
        Object object = selection;
        if (object instanceof SymbolInformation) {
            void symbolInformation;
            SymbolInformation symbolInformation2 = (SymbolInformation)object;
            SymbolInformation cfr_ignored_0 = (SymbolInformation)object;
            return symbolInformation.getLocation().getRange();
        }
        Object object2 = selection;
        if (object2 instanceof SymbolsModel.DocumentSymbolWithURI) {
            void symbolWithURI;
            SymbolsModel.DocumentSymbolWithURI documentSymbolWithURI = (SymbolsModel.DocumentSymbolWithURI)object2;
            SymbolsModel.DocumentSymbolWithURI cfr_ignored_1 = (SymbolsModel.DocumentSymbolWithURI)object2;
            return symbolWithURI.symbol.getSelectionRange();
        }
        return null;
    }

    public static void refreshTreeSelection(TreeViewer viewer, int offset, IDocument document) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        Object[] objects = contentProvider.getElements(null);
        ArrayList<Object> path = new ArrayList<Object>();
        while (objects != null && objects.length > 0) {
            boolean found = false;
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Range range = CNFOutlinePage.toRange(object);
                if (range != null && CNFOutlinePage.isOffsetInRange(offset, range, document)) {
                    objects = contentProvider.getChildren(object);
                    path.add(object);
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) break;
        }
        if (!path.isEmpty()) {
            Object bestNode = path.get(path.size() - 1);
            if (bestNode.equals(viewer.getStructuredSelection().getFirstElement())) {
                return;
            }
            Display.getDefault().asyncExec(() -> {
                TreePath treePath = new TreePath(path.toArray());
                viewer.reveal((Object)treePath);
                viewer.setSelection((ISelection)new TreeSelection(treePath), true);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Range toRange(Object object) {
        SymbolInformation symbol;
        Range range = null;
        Object object2 = object;
        if (object2 instanceof SymbolInformation) {
            void symbolInformation;
            SymbolInformation symbolInformation2 = (SymbolInformation)object2;
            SymbolInformation cfr_ignored_0 = (SymbolInformation)object2;
            v0 = symbolInformation;
        } else {
            v0 = symbol = (SymbolInformation)Adapters.adapt((Object)object, SymbolInformation.class);
        }
        if (symbol != null) {
            range = symbol.getLocation().getRange();
        } else {
            SymbolsModel.DocumentSymbolWithURI documentSymbol;
            Object object3 = object;
            if (object3 instanceof SymbolsModel.DocumentSymbolWithURI) {
                void symbolWithURI;
                SymbolsModel.DocumentSymbolWithURI documentSymbolWithURI = (SymbolsModel.DocumentSymbolWithURI)object3;
                SymbolsModel.DocumentSymbolWithURI cfr_ignored_1 = (SymbolsModel.DocumentSymbolWithURI)object3;
                v1 = symbolWithURI;
            } else {
                v1 = documentSymbol = (SymbolsModel.DocumentSymbolWithURI)Adapters.adapt((Object)object, SymbolsModel.DocumentSymbolWithURI.class);
            }
            if (documentSymbol != null) {
                range = documentSymbol.symbol.getRange();
            }
        }
        return range;
    }

    private static boolean isOffsetInRange(int offset, Range range, IDocument document) {
        block3: {
            try {
                int startOffset = document.getLineOffset(range.getStart().getLine()) + range.getStart().getCharacter();
                if (startOffset <= offset) break block3;
                return false;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        int endOffset = document.getLineOffset(range.getEnd().getLine()) + range.getEnd().getCharacter();
        return endOffset >= offset;
    }

    public void dispose() {
        this.preferences.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.outlineViewer.dispose();
        if (this.textEditorViewer != null && this.editorSelectionChangedListener != null) {
            this.editorSelectionChangedListener.uninstall(this.textEditorViewer.getSelectionProvider());
        }
    }

    public Control getControl() {
        return this.outlineViewer.getControl();
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void setFocus() {
        this.outlineViewer.getTree().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.outlineViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.outlineViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.outlineViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.outlineViewer.setSelection(selection);
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.outlineViewer.refresh(true);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (SORT_OUTLINE_PREFERENCE.equals(event.getKey()) && this.outlineViewer != null) {
            this.outlineViewer.refresh();
        }
    }

    class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        EditorSelectionChangedListener() {
        }

        /*
         * WARNING - void declaration
         */
        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = selectionProvider;
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                void provider;
                IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                IPostSelectionProvider cfr_ignored_0 = (IPostSelectionProvider)iSelectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            ISelectionProvider iSelectionProvider = selectionProvider;
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                void provider;
                IPostSelectionProvider iPostSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                IPostSelectionProvider cfr_ignored_0 = (IPostSelectionProvider)iSelectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            ISelection iSelection = selection;
            if (iSelection instanceof ITextSelection) {
                int n;
                ITextSelection iTextSelection = (ITextSelection)iSelection;
                ITextSelection cfr_ignored_0 = (ITextSelection)iSelection;
                if (!CNFOutlinePage.this.preferences.getBoolean(CNFOutlinePage.LINK_WITH_EDITOR_PREFERENCE, true)) {
                    return;
                }
                CommonViewer commonViewer = CNFOutlinePage.this.outlineViewer;
                if (commonViewer instanceof ITextViewerExtension5) {
                    void extension5;
                    ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)commonViewer;
                    ITextViewerExtension5 cfr_ignored_1 = (ITextViewerExtension5)commonViewer;
                    n = extension5.widgetOffset2ModelOffset(textSelection.getOffset());
                } else {
                    n = textSelection.getOffset();
                }
                int offset = n;
                CNFOutlinePage.refreshTreeSelection((TreeViewer)CNFOutlinePage.this.outlineViewer, offset, CNFOutlinePage.this.document);
            }
        }
    }
}

