/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.exported.displaysync;

import org.eclipse.modisco.facet.util.ui.internal.exported.displaysync.AbstractExceptionFreeRunnable;
import org.eclipse.modisco.facet.util.ui.internal.exported.displaysync.AbstractVoidExceptionFreeRunnable;
import org.eclipse.modisco.facet.util.ui.internal.exported.displaysync.AbstractVoidRunnable;
import org.eclipse.modisco.facet.util.ui.internal.exported.displaysync.DisplaySyncRuntimeException;
import org.eclipse.modisco.facet.util.ui.internal.exported.displaysync.IRunnable;
import org.eclipse.swt.widgets.Display;

public class SynchronizedObject<O> {
    private final O object;
    private final Thread widgetThread;
    private final Display display;

    public SynchronizedObject(O object, Display display) {
        this.object = object;
        this.display = display;
        this.widgetThread = this.display.getThread();
    }

    protected final <T, E extends Exception> T syncExecWithResult(final IRunnable<T, E> runnable) throws E {
        Object result;
        if (this.widgetThread == Thread.currentThread()) {
            result = runnable.run();
        } else {
            final ExceptionHandler exceptionHandler = new ExceptionHandler();
            final Object[] resultHandler = new Object[1];
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        resultHandler[0] = runnable.run();
                    }
                    catch (Exception e) {
                        exceptionHandler.setException(e);
                    }
                }
            });
            if (exceptionHandler.getException() != null) {
                Exception castException = exceptionHandler.getException();
                throw castException;
            }
            Object tmpResult = resultHandler[0];
            result = tmpResult;
        }
        return result;
    }

    protected final <E extends Exception> void voidSyncExec(AbstractVoidRunnable<E> runnable) throws E {
        this.syncExecWithResult(runnable);
    }

    protected final <T> T safeSyncExec(AbstractExceptionFreeRunnable<T> runnable) {
        try {
            return this.syncExecWithResult(runnable);
        }
        catch (Exception e) {
            throw new DisplaySyncRuntimeException(e);
        }
    }

    protected final void voidExceptionFreeRunnable(AbstractVoidExceptionFreeRunnable runnable) {
        try {
            this.syncExecWithResult(runnable);
        }
        catch (Exception e) {
            throw new DisplaySyncRuntimeException(e);
        }
    }

    public O getSynchronizedObject() {
        return this.object;
    }

    protected class ExceptionHandler {
        private Exception exception;

        protected ExceptionHandler() {
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }
}

