/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ide.highlight;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationProvider;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ClassType;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ReferenceType;
import org.eclipse.xtext.ide.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.ide.highlighting.XbaseHighlightingCalculator;

public class EMFPatternLanguageHighlightingCalculator
extends XbaseHighlightingCalculator {
    @Inject
    private PatternAnnotationProvider annotationProvider;

    protected void searchAndHighlightElements(XtextResource resource, IHighlightedPositionAcceptor acceptor, CancelIndicator indicator) {
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject object = (EObject)iterator.next();
            if (object instanceof XAbstractFeatureCall) {
                this.computeFeatureCallHighlighting((XAbstractFeatureCall)object, acceptor);
                continue;
            }
            if (object instanceof XNumberLiteral) {
                this.highlightNumberLiterals((XNumberLiteral)object, acceptor);
                continue;
            }
            if (object instanceof XAnnotation) {
                this.highlightAnnotation((XAnnotation)object, acceptor);
                continue;
            }
            if (object instanceof ClassType || object instanceof ReferenceType) {
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)object);
                this.highlightNode(acceptor, (INode)node, new String[]{"viatra.query.metamodel.reference"});
                continue;
            }
            if (object instanceof Annotation && this.annotationProvider.isDeprecated((Annotation)object)) {
                Annotation annotation = (Annotation)object;
                ICompositeNode compositeNode = NodeModelUtils.findActualNodeFor((EObject)annotation);
                ICompositeNode node = null;
                for (ILeafNode leafNode : compositeNode.getLeafNodes()) {
                    if (!leafNode.getText().equals(annotation.getName())) continue;
                    node = leafNode;
                    break;
                }
                node = node == null ? compositeNode : node;
                this.highlightNode(acceptor, (INode)node, new String[]{"xbase.deprecated.members"});
                continue;
            }
            if (object instanceof AnnotationParameter && this.annotationProvider.isDeprecated((AnnotationParameter)object)) {
                ICompositeNode compositeNode = NodeModelUtils.findActualNodeFor((EObject)object);
                ICompositeNode node = null;
                for (ILeafNode leafNode : compositeNode.getLeafNodes()) {
                    if (!leafNode.getText().equals(((AnnotationParameter)object).getName())) continue;
                    node = leafNode;
                    break;
                }
                node = node == null ? compositeNode : node;
                this.highlightNode(acceptor, (INode)node, new String[]{"xbase.deprecated.members"});
                continue;
            }
            this.computeReferencedJvmTypeHighlighting(acceptor, object, indicator);
        }
    }
}

