/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.parser;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.parser.AstModelSupport;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolver;
import org.eclipse.wb.internal.core.databinding.parser.IModelResolverFilter;
import org.eclipse.wb.internal.core.databinding.parser.IModelSupport;
import org.eclipse.wb.internal.core.databinding.parser.ISubParser;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;

public abstract class AbstractParser
implements IModelResolver {
    protected final AstEditor m_editor;
    protected final IDatabindingsProvider m_provider;
    protected final List<ISubParser> m_subParsers = Lists.newArrayList();
    protected final List<IModelSupport> m_modelSupports = Lists.newArrayList();

    public AbstractParser(AstEditor editor, IDatabindingsProvider provider) {
        this.m_editor = editor;
        this.m_provider = provider;
    }

    protected final void parseMethod(MethodDeclaration method) {
        method.accept(new ASTVisitor(){

            public void endVisit(ClassInstanceCreation creation) {
                try {
                    String signature = CoreUtils.getCreationSignature(creation);
                    Expression[] arguments = CoreUtils.getExpressionArray(DomGenerics.arguments((ClassInstanceCreation)creation));
                    if (AbstractParser.this.failExpressions(arguments)) {
                        return;
                    }
                    for (ISubParser subParser : AbstractParser.this.m_subParsers) {
                        AstObjectInfo model = subParser.parseExpression(AbstractParser.this.m_editor, signature, creation, arguments, AbstractParser.this, AbstractParser.this.m_provider);
                        if (model == null) continue;
                        AbstractParser.this.addModel(model, (Expression)creation);
                        return;
                    }
                }
                catch (Throwable e) {
                    ReflectionUtils.propagate((Throwable)e);
                }
            }

            public void endVisit(MethodInvocation invocation) {
                try {
                    AstObjectInfo model;
                    String signature = CoreUtils.getMethodSignature(invocation);
                    if (signature == null) {
                        return;
                    }
                    Expression[] arguments = CoreUtils.getExpressionArray(DomGenerics.arguments((MethodInvocation)invocation));
                    if (AbstractParser.this.failExpressions(arguments)) {
                        return;
                    }
                    Expression expression = invocation.getExpression();
                    if (expression != null && (model = AbstractParser.this.getModel(expression)) != null && (model = model.parseExpression(AbstractParser.this.m_editor, signature, invocation, arguments, AbstractParser.this, AbstractParser.this.m_provider)) != null) {
                        AbstractParser.this.addModel(model, (Expression)invocation);
                        return;
                    }
                    for (ISubParser subParser : AbstractParser.this.m_subParsers) {
                        AstObjectInfo model2 = subParser.parseExpression(AbstractParser.this.m_editor, signature, invocation, arguments, AbstractParser.this);
                        if (model2 == null) continue;
                        AbstractParser.this.addModel(model2, (Expression)invocation);
                        return;
                    }
                }
                catch (Throwable e) {
                    ReflectionUtils.propagate((Throwable)e);
                }
            }
        });
    }

    private boolean failExpressions(Expression[] arguments) throws Exception {
        Expression[] expressionArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Expression argument = expressionArray[n2];
            if (AstNodeUtils.getTypeBinding((Expression)argument) == null) {
                AbstractParser.addError(this.m_editor, "Expression with errors: '" + argument + "'", new Throwable());
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void addModel(AstObjectInfo model, Expression creation) throws Exception {
        this.addModelSupport(new AstModelSupport(model, creation));
    }

    @Override
    public AstObjectInfo getModel(Expression expression) throws Exception {
        IModelSupport modelSupport = this.getModelSupport(expression);
        return modelSupport == null ? null : modelSupport.getModel();
    }

    @Override
    public AstObjectInfo getModel(Expression expression, IModelResolverFilter filter) throws Exception {
        for (IModelSupport modelSupport : this.m_modelSupports) {
            if (!modelSupport.isRepresentedBy(expression) || !filter.accept(modelSupport)) continue;
            return modelSupport.getModel();
        }
        return null;
    }

    @Override
    public void addModelSupport(IModelSupport modelSupport) {
        this.m_modelSupports.add(modelSupport);
    }

    @Override
    public IModelSupport getModelSupport(Expression expression) throws Exception {
        Expression actualExpression = AstNodeUtils.getActualVariableExpression((Expression)expression);
        IModelSupport modelSupport = this.getModelSupport0(actualExpression);
        if (modelSupport == null && actualExpression != expression) {
            modelSupport = this.getModelSupport0(expression);
        }
        return modelSupport;
    }

    private IModelSupport getModelSupport0(Expression expression) throws Exception {
        for (IModelSupport modelSupport : this.m_modelSupports) {
            if (!modelSupport.isRepresentedBy(expression)) continue;
            return modelSupport;
        }
        return null;
    }

    public static void addError(AstEditor editor, String message, Throwable exception) {
        EditorState state = EditorState.get((AstEditor)editor);
        state.addWarning(new EditorWarning(message, exception));
    }
}

