/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.TextUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.swt.gef.GefMessages;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.actions.DimensionHeaderAction;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.actions.SetAlignmentAction;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.actions.SetGrabAction;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swt.model.layout.grid.GridColumnInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDimensionInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridImages;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class ColumnHeaderEditPart<C extends IControlInfo>
extends DimensionHeaderEditPart<C> {
    public ColumnHeaderEditPart(IGridLayoutInfo<C> layout, GridColumnInfo<C> column, Figure containerFigure) {
        super(layout, column, containerFigure);
    }

    protected Figure createFigure() {
        Figure newFigure = new Figure(){

            protected void paintClientArea(Graphics graphics) {
                Rectangle r = this.getClientArea();
                graphics.setForegroundColor(IColorConstants.buttonDarker);
                graphics.drawLine(r.x, r.y, r.x, r.bottom());
                graphics.drawLine(r.right() - 1, r.y, r.right() - 1, r.bottom());
                String title = "" + (1 + ColumnHeaderEditPart.this.m_dimension.getIndex());
                Dimension textExtents = TextUtilities.INSTANCE.getTextExtents(title, graphics.getFont());
                if (r.width < 3 + textExtents.width + 3) {
                    return;
                }
                int titleLeft = r.x + (r.width - textExtents.width) / 2;
                int titleRight = titleLeft + textExtents.width;
                int y = r.y + (r.height - textExtents.height) / 2;
                graphics.setForegroundColor(IColorConstants.black);
                graphics.drawText(title, titleLeft, y);
                try {
                    Integer alignmentValue = ColumnHeaderEditPart.this.m_dimension.getAlignment();
                    if (alignmentValue != null && titleLeft - r.x > 13) {
                        int alignment = alignmentValue;
                        Image image = alignment == 16384 ? this.getImage("left.gif") : (alignment == 0x1000000 ? this.getImage("center.gif") : (alignment == 131072 ? this.getImage("right.gif") : this.getImage("fill.gif")));
                        int x = r.x + 2;
                        this.drawCentered(graphics, image, x);
                    }
                    if (ColumnHeaderEditPart.this.m_dimension.getGrab() && titleRight + 3 + 7 + 3 < r.right()) {
                        Image image = this.getImage("grow.gif");
                        this.drawCentered(graphics, image, r.right() - 3 - image.getBounds().width);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }

            private Image getImage(String name) {
                return GridImages.getImage("h/" + name);
            }

            private void drawCentered(Graphics graphics, Image image, int x) {
                int y = (this.getBounds().height - image.getBounds().height) / 2;
                graphics.drawImage(image, x, y);
            }
        };
        newFigure.setFont(DEFAULT_FONT);
        newFigure.setOpaque(true);
        return newFigure;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        int index = this.m_dimension.getIndex();
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval interval = gridInfo.getColumnIntervals()[index];
        Rectangle bounds = new Rectangle(interval.begin(), 0, interval.length() + 1, ((GraphicalEditPart)this.getParent()).getFigure().getSize().height);
        this.translateModelToFeedback(bounds);
        this.getFigure().setBounds(bounds);
    }

    public void translateModelToFeedback(Rectangle r) {
        PolicyUtils.modelToFeedback_rightToLeft((Translatable)r, (IAbstractComponentInfo)this.m_layout.getComposite());
        r.performTranslate(this.getOffset().x, 0);
    }

    public void buildContextMenu(IMenuManager manager) {
        manager.add(new SetGrabAction(this, GefMessages.ColumnHeaderEditPart_grabExcessSpace, GridImages.getImageDescriptor("h/menu/grow.gif")));
        manager.add((IContributionItem)new Separator());
        manager.add(new SetAlignmentAction(this, GefMessages.ColumnHeaderEditPart_left, GridImages.getImageDescriptor("h/menu/left.gif"), 16384));
        manager.add(new SetAlignmentAction(this, GefMessages.ColumnHeaderEditPart_center, GridImages.getImageDescriptor("h/menu/center.gif"), 0x1000000));
        manager.add(new SetAlignmentAction(this, GefMessages.ColumnHeaderEditPart_right, GridImages.getImageDescriptor("h/menu/right.gif"), 131072));
        manager.add(new SetAlignmentAction(this, GefMessages.ColumnHeaderEditPart_fill, GridImages.getImageDescriptor("h/menu/fill.gif"), 4));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new DimensionHeaderAction<C>(this, GefMessages.ColumnHeaderEditPart_delete, GridImages.getImageDescriptor("h/menu/delete.gif")){

            @Override
            protected void run(GridDimensionInfo<C> dimension) throws Exception {
                ColumnHeaderEditPart.this.m_layout.command_deleteColumn(dimension.getIndex(), true);
            }
        });
    }
}

