/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.chrome;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.AbstractRunHTMLDebugTab;
import org.eclipse.wildwebdeveloper.debug.chrome.ChromeRunDebugLaunchShortcut;

public class RunChromeDebugTab
extends AbstractRunHTMLDebugTab {
    private Button verboseConsoleOutput;

    public RunChromeDebugTab() {
        this.shortcut = new ChromeRunDebugLaunchShortcut();
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.verboseConsoleOutput = new Button(this.resComposite, 32);
        this.verboseConsoleOutput.setText("Verbose output");
        this.verboseConsoleOutput.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            boolean verboseConsoleOutputValue = configuration.getAttribute("verbose", false);
            this.verboseConsoleOutput.setSelection(verboseConsoleOutputValue);
        }
        catch (CoreException ex) {
            Activator.getDefault().getLog().log(ex.getStatus());
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("verbose", this.verboseConsoleOutput.getSelection());
    }
}

