/*******************************************************************************
 * Copyright (c) 2015, 2016 itemis AG (http://www.itemis.eu) and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.xtext.xtext.wizard.ecore2xtext

import static extension org.eclipse.xtext.xtext.wizard.ecore2xtext.Ecore2XtextExtensions.*
import static extension org.eclipse.xtext.xtext.wizard.ecore2xtext.UniqueNameUtil.*
import org.eclipse.emf.ecore.EClassifier
import org.eclipse.emf.ecore.EDataType
import org.eclipse.emf.ecore.EClass
import org.eclipse.emf.ecore.EStructuralFeature
import org.eclipse.emf.ecore.EAttribute
import org.eclipse.emf.ecore.EReference
import org.eclipse.emf.ecore.EEnum
import java.util.List
import org.eclipse.xtext.xtext.wizard.WizardConfiguration

 class Ecore2XtextGrammarCreator {
		
	def grammar(WizardConfiguration config) {
		val it = config.ecore2Xtext
		defaultEPackageInfo.clearUniqueNames
		'''
		// automatically generated by Xtext
		grammar config.language.name with org.eclipse.xtext.common.Terminals
		
		FOR it: allReferencedEPackages
		import "nsURI" IF uniqueName !== null && uniqueName != ""as uniqueNameENDIF
		ENDFOR
		
		rootElementClass.rules
		FOR it:allDispatcherRuleClasses.but(rootElementClass)
			
			subClassDispatcherRule
		ENDFOR
		FOR it:allConcreteRuleClassifiers.but(rootElementClass)
			
			rule(it)
		ENDFOR
		'''
	}
	
	def <T extends EClassifier> List<T> but(Iterable<T> classes, EClassifier it) {
		val retVal = classes.toList
		retVal.remove(it)
		return retVal
	}
	 
	def subClassDispatcherRule(EClass it) {
		'''
		IF needsDispatcherRule
			uniqueName returns fqn:
				subClassAlternatives;
		ENDIF
		'''
	}
	
	def subClassAlternatives(EClass eClazz) {
		var list = newArrayList(eClazz)+subClasses(eClazz)
		list=list.filter([c|needsConcreteRule(c)])
		list.map([concreteRuleName]).join(" | ")
	}
	
	def idAssignment(EClass it) {
		val idAttr = idAttribute
		if(idAttr!==null) {
			'''idAttr.name=assignedRuleCall(idAttr)'''
		}
	}
	
	def assigment(EStructuralFeature it) {
		'''
		IF(!required)(ENDIFassignmentKeywordIF manyIF containment'{' ELSE'(' ENDIFENDIFname.quoteIfNeccesaryassignmentOperatorassignedTerminalIF many ( "," name.quoteIfNeccesaryassignmentOperatorassignedTerminal)* IF containment'}' ELSE')' ENDIFENDIFIF (!required))?ENDIF
		'''
	}
	
	def assignedTerminal(EStructuralFeature it) {
		switch(it) {
			EAttribute:
				it.assignedRuleCall
			EReference:
				if(containment)
					it.EReferenceType.uniqueName
				else
					'''[it.EReferenceType.fqn|EString]'''
			default:
				''''''
		}
	}

	def assignmentOperator(EStructuralFeature it) {
		'''IF many+=ELSEIF isBoolean(EType)&&prefixBooleanFeature?=ELSE=ENDIF'''
	}

	def rules(EClassifier it) {
		if (it !== null && it.needsConcreteRule) {
			rule(it)
		}
	}
	
	def rule(EClassifier it) {
		switch(it) {
			EClass :
				'''
				it.concreteRuleName returns fqn:
					IF (it.onlyOptionalFeatures)
						{fqn}
					ENDIF
					FOR strF: it.prefixFeatures
					strF.assigment
					ENDFOR
					'name'
					idAssignmentIF (!it.inlinedFeatures.empty)
					'{'
						FOR attr: it.allAttributes
							attr.assigment
						ENDFOR
						FOR ref: it.allCrossReferences
							ref.assigment
						ENDFOR
						FOR conti: it.allContainmentReferences
							conti.assigment
						ENDFOR
					'}'ENDIF;
				'''
			EEnum:
				'''enum name.quoteIfNeccesary returns fqn:
				it.ELiterals.map([name.quoteIfNeccesary+" = '"+name+"'"]).join(' | ');'''
			EDataType:
				if (it.serializable) {
				'''
				uniqueName returns fqn:
					it.dataTypeRuleBody;
				'''
				}
			
			default:	
				throw new IllegalStateException("No rule template for "+it)
		}
	}
}
