/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerConfig;
import org.mandas.docker.client.messages.ContainerInfo;
import org.mandas.docker.client.messages.ContainerMount;
import org.mandas.docker.client.messages.ContainerState;
import org.mandas.docker.client.messages.HostConfig;
import org.mandas.docker.client.messages.NetworkSettings;

final class ImmutableContainerInfo
implements ContainerInfo {
    @Nullable
    private final String id;
    private final Date created;
    private final String path;
    private final List<String> args;
    private final ContainerConfig config;
    @Nullable
    private final HostConfig hostConfig;
    private final ContainerState state;
    private final String image;
    private final NetworkSettings networkSettings;
    private final String resolvConfPath;
    private final String hostnamePath;
    private final String hostsPath;
    private final String name;
    private final String driver;
    @Nullable
    private final String execDriver;
    private final String processLabel;
    private final String mountLabel;
    private final String appArmorProfile;
    @Nullable
    private final List<String> execIds;
    private final String logPath;
    private final Long restartCount;
    @Nullable
    private final List<ContainerMount> mounts;
    @Nullable
    private final ContainerInfo.Node node;

    private ImmutableContainerInfo(@Nullable String id, Date created, String path, List<String> args, ContainerConfig config, @Nullable HostConfig hostConfig, ContainerState state, String image, NetworkSettings networkSettings, String resolvConfPath, String hostnamePath, String hostsPath, String name, String driver, @Nullable String execDriver, String processLabel, String mountLabel, String appArmorProfile, @Nullable List<String> execIds, String logPath, Long restartCount, @Nullable List<ContainerMount> mounts, @Nullable ContainerInfo.Node node) {
        this.id = id;
        this.created = created;
        this.path = path;
        this.args = args;
        this.config = config;
        this.hostConfig = hostConfig;
        this.state = state;
        this.image = image;
        this.networkSettings = networkSettings;
        this.resolvConfPath = resolvConfPath;
        this.hostnamePath = hostnamePath;
        this.hostsPath = hostsPath;
        this.name = name;
        this.driver = driver;
        this.execDriver = execDriver;
        this.processLabel = processLabel;
        this.mountLabel = mountLabel;
        this.appArmorProfile = appArmorProfile;
        this.execIds = execIds;
        this.logPath = logPath;
        this.restartCount = restartCount;
        this.mounts = mounts;
        this.node = node;
    }

    @Override
    @JsonProperty(value="Id")
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Created")
    public Date created() {
        return this.created;
    }

    @Override
    @JsonProperty(value="Path")
    public String path() {
        return this.path;
    }

    @Override
    @JsonProperty(value="Args")
    public List<String> args() {
        return this.args;
    }

    @Override
    @JsonProperty(value="Config")
    public ContainerConfig config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="HostConfig")
    @Nullable
    public HostConfig hostConfig() {
        return this.hostConfig;
    }

    @Override
    @JsonProperty(value="State")
    public ContainerState state() {
        return this.state;
    }

    @Override
    @JsonProperty(value="Image")
    public String image() {
        return this.image;
    }

    @Override
    @JsonProperty(value="NetworkSettings")
    public NetworkSettings networkSettings() {
        return this.networkSettings;
    }

    @Override
    @JsonProperty(value="ResolvConfPath")
    public String resolvConfPath() {
        return this.resolvConfPath;
    }

    @Override
    @JsonProperty(value="HostnamePath")
    public String hostnamePath() {
        return this.hostnamePath;
    }

    @Override
    @JsonProperty(value="HostsPath")
    public String hostsPath() {
        return this.hostsPath;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Driver")
    public String driver() {
        return this.driver;
    }

    @Override
    @JsonProperty(value="ExecDriver")
    @Nullable
    public String execDriver() {
        return this.execDriver;
    }

    @Override
    @JsonProperty(value="ProcessLabel")
    public String processLabel() {
        return this.processLabel;
    }

    @Override
    @JsonProperty(value="MountLabel")
    public String mountLabel() {
        return this.mountLabel;
    }

    @Override
    @JsonProperty(value="AppArmorProfile")
    public String appArmorProfile() {
        return this.appArmorProfile;
    }

    @Override
    @JsonProperty(value="ExecIDs")
    @Nullable
    public List<String> execIds() {
        return this.execIds;
    }

    @Override
    @JsonProperty(value="LogPath")
    public String logPath() {
        return this.logPath;
    }

    @Override
    @JsonProperty(value="RestartCount")
    public Long restartCount() {
        return this.restartCount;
    }

    @Override
    @JsonProperty(value="Mounts")
    @Nullable
    public List<ContainerMount> mounts() {
        return this.mounts;
    }

    @Override
    @JsonProperty(value="Node")
    @Nullable
    public ContainerInfo.Node node() {
        return this.node;
    }

    public final ImmutableContainerInfo withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableContainerInfo(value, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withCreated(Date value) {
        if (this.created == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "created");
        return new ImmutableContainerInfo(this.id, newValue, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, newValue, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withArgs(String ... elements) {
        List<String> newValue = ImmutableContainerInfo.createUnmodifiableList(false, ImmutableContainerInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerInfo(this.id, this.created, this.path, newValue, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withArgs(Iterable<String> elements) {
        if (this.args == elements) {
            return this;
        }
        List<String> newValue = ImmutableContainerInfo.createUnmodifiableList(false, ImmutableContainerInfo.createSafeList(elements, true, false));
        return new ImmutableContainerInfo(this.id, this.created, this.path, newValue, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withConfig(ContainerConfig value) {
        if (this.config == value) {
            return this;
        }
        ContainerConfig newValue = Objects.requireNonNull(value, "config");
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, newValue, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withHostConfig(@Nullable HostConfig value) {
        if (this.hostConfig == value) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, value, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withState(ContainerState value) {
        if (this.state == value) {
            return this;
        }
        ContainerState newValue = Objects.requireNonNull(value, "state");
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, newValue, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withImage(String value) {
        String newValue = Objects.requireNonNull(value, "image");
        if (this.image.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, newValue, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withNetworkSettings(NetworkSettings value) {
        if (this.networkSettings == value) {
            return this;
        }
        NetworkSettings newValue = Objects.requireNonNull(value, "networkSettings");
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, newValue, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withResolvConfPath(String value) {
        String newValue = Objects.requireNonNull(value, "resolvConfPath");
        if (this.resolvConfPath.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, newValue, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withHostnamePath(String value) {
        String newValue = Objects.requireNonNull(value, "hostnamePath");
        if (this.hostnamePath.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, newValue, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withHostsPath(String value) {
        String newValue = Objects.requireNonNull(value, "hostsPath");
        if (this.hostsPath.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, newValue, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, newValue, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withDriver(String value) {
        String newValue = Objects.requireNonNull(value, "driver");
        if (this.driver.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, newValue, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withExecDriver(@Nullable String value) {
        if (Objects.equals(this.execDriver, value)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, value, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withProcessLabel(String value) {
        String newValue = Objects.requireNonNull(value, "processLabel");
        if (this.processLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, newValue, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withMountLabel(String value) {
        String newValue = Objects.requireNonNull(value, "mountLabel");
        if (this.mountLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, newValue, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withAppArmorProfile(String value) {
        String newValue = Objects.requireNonNull(value, "appArmorProfile");
        if (this.appArmorProfile.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, newValue, this.execIds, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withExecIds(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, null, this.logPath, this.restartCount, this.mounts, this.node);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerInfo.createUnmodifiableList(false, ImmutableContainerInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, newValue, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withExecIds(@Nullable Iterable<String> elements) {
        if (this.execIds == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerInfo.createUnmodifiableList(false, ImmutableContainerInfo.createSafeList(elements, true, false));
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, newValue, this.logPath, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withLogPath(String value) {
        String newValue = Objects.requireNonNull(value, "logPath");
        if (this.logPath.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, newValue, this.restartCount, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withRestartCount(Long value) {
        Long newValue = Objects.requireNonNull(value, "restartCount");
        if (this.restartCount.equals(newValue)) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, newValue, this.mounts, this.node);
    }

    public final ImmutableContainerInfo withMounts(ContainerMount ... elements) {
        if (elements == null) {
            return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, null, this.node);
        }
        List<ContainerMount> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerInfo.createUnmodifiableList(false, ImmutableContainerInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, newValue, this.node);
    }

    public final ImmutableContainerInfo withMounts(@Nullable Iterable<? extends ContainerMount> elements) {
        if (this.mounts == elements) {
            return this;
        }
        List<ContainerMount> newValue = elements == null ? null : ImmutableContainerInfo.createUnmodifiableList(false, ImmutableContainerInfo.createSafeList(elements, true, false));
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, newValue, this.node);
    }

    public final ImmutableContainerInfo withNode(@Nullable ContainerInfo.Node value) {
        if (this.node == value) {
            return this;
        }
        return new ImmutableContainerInfo(this.id, this.created, this.path, this.args, this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds, this.logPath, this.restartCount, this.mounts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerInfo && this.equalTo((ImmutableContainerInfo)another);
    }

    private boolean equalTo(ImmutableContainerInfo another) {
        return Objects.equals(this.id, another.id) && this.created.equals(another.created) && this.path.equals(another.path) && this.args.equals(another.args) && this.config.equals(another.config) && Objects.equals(this.hostConfig, another.hostConfig) && this.state.equals(another.state) && this.image.equals(another.image) && this.networkSettings.equals(another.networkSettings) && this.resolvConfPath.equals(another.resolvConfPath) && this.hostnamePath.equals(another.hostnamePath) && this.hostsPath.equals(another.hostsPath) && this.name.equals(another.name) && this.driver.equals(another.driver) && Objects.equals(this.execDriver, another.execDriver) && this.processLabel.equals(another.processLabel) && this.mountLabel.equals(another.mountLabel) && this.appArmorProfile.equals(another.appArmorProfile) && Objects.equals(this.execIds, another.execIds) && this.logPath.equals(another.logPath) && this.restartCount.equals(another.restartCount) && Objects.equals(this.mounts, another.mounts) && Objects.equals(this.node, another.node);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.created.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + this.args.hashCode();
        h += (h << 5) + this.config.hashCode();
        h += (h << 5) + Objects.hashCode(this.hostConfig);
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.image.hashCode();
        h += (h << 5) + this.networkSettings.hashCode();
        h += (h << 5) + this.resolvConfPath.hashCode();
        h += (h << 5) + this.hostnamePath.hashCode();
        h += (h << 5) + this.hostsPath.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.driver.hashCode();
        h += (h << 5) + Objects.hashCode(this.execDriver);
        h += (h << 5) + this.processLabel.hashCode();
        h += (h << 5) + this.mountLabel.hashCode();
        h += (h << 5) + this.appArmorProfile.hashCode();
        h += (h << 5) + Objects.hashCode(this.execIds);
        h += (h << 5) + this.logPath.hashCode();
        h += (h << 5) + this.restartCount.hashCode();
        h += (h << 5) + Objects.hashCode(this.mounts);
        h += (h << 5) + Objects.hashCode(this.node);
        return h;
    }

    public String toString() {
        return "ContainerInfo{id=" + this.id + ", created=" + this.created + ", path=" + this.path + ", args=" + this.args + ", config=" + this.config + ", hostConfig=" + this.hostConfig + ", state=" + this.state + ", image=" + this.image + ", networkSettings=" + this.networkSettings + ", resolvConfPath=" + this.resolvConfPath + ", hostnamePath=" + this.hostnamePath + ", hostsPath=" + this.hostsPath + ", name=" + this.name + ", driver=" + this.driver + ", execDriver=" + this.execDriver + ", processLabel=" + this.processLabel + ", mountLabel=" + this.mountLabel + ", appArmorProfile=" + this.appArmorProfile + ", execIds=" + this.execIds + ", logPath=" + this.logPath + ", restartCount=" + this.restartCount + ", mounts=" + this.mounts + ", node=" + this.node + "}";
    }

    public static ImmutableContainerInfo copyOf(ContainerInfo instance) {
        if (instance instanceof ImmutableContainerInfo) {
            return (ImmutableContainerInfo)instance;
        }
        return ImmutableContainerInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Node
    implements ContainerInfo.Node {
        private final String id;
        private final String ip;
        private final String addr;
        private final String name;

        private Node(String id, String ip, String addr, String name) {
            this.id = id;
            this.ip = ip;
            this.addr = addr;
            this.name = name;
        }

        @Override
        @JsonProperty(value="ID")
        public String id() {
            return this.id;
        }

        @Override
        @JsonProperty(value="IP")
        public String ip() {
            return this.ip;
        }

        @Override
        @JsonProperty(value="Addr")
        public String addr() {
            return this.addr;
        }

        @Override
        @JsonProperty(value="Name")
        public String name() {
            return this.name;
        }

        public final Node withId(String value) {
            String newValue = Objects.requireNonNull(value, "id");
            if (this.id.equals(newValue)) {
                return this;
            }
            return new Node(newValue, this.ip, this.addr, this.name);
        }

        public final Node withIp(String value) {
            String newValue = Objects.requireNonNull(value, "ip");
            if (this.ip.equals(newValue)) {
                return this;
            }
            return new Node(this.id, newValue, this.addr, this.name);
        }

        public final Node withAddr(String value) {
            String newValue = Objects.requireNonNull(value, "addr");
            if (this.addr.equals(newValue)) {
                return this;
            }
            return new Node(this.id, this.ip, newValue, this.name);
        }

        public final Node withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Node(this.id, this.ip, this.addr, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Node && this.equalTo((Node)another);
        }

        private boolean equalTo(Node another) {
            return this.id.equals(another.id) && this.ip.equals(another.ip) && this.addr.equals(another.addr) && this.name.equals(another.name);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.id.hashCode();
            h += (h << 5) + this.ip.hashCode();
            h += (h << 5) + this.addr.hashCode();
            h += (h << 5) + this.name.hashCode();
            return h;
        }

        public String toString() {
            return "Node{id=" + this.id + ", ip=" + this.ip + ", addr=" + this.addr + ", name=" + this.name + "}";
        }

        public static Node copyOf(ContainerInfo.Node instance) {
            if (instance instanceof Node) {
                return (Node)instance;
            }
            return Node.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_ID = 1L;
            private static final long INIT_BIT_IP = 2L;
            private static final long INIT_BIT_ADDR = 4L;
            private static final long INIT_BIT_NAME = 8L;
            private long initBits = 15L;
            private String id;
            private String ip;
            private String addr;
            private String name;

            private Builder() {
            }

            public final Builder from(ContainerInfo.Node instance) {
                Objects.requireNonNull(instance, "instance");
                this.id(instance.id());
                this.ip(instance.ip());
                this.addr(instance.addr());
                this.name(instance.name());
                return this;
            }

            @JsonProperty(value="ID")
            public final Builder id(String id) {
                this.id = Objects.requireNonNull(id, "id");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="IP")
            public final Builder ip(String ip) {
                this.ip = Objects.requireNonNull(ip, "ip");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @JsonProperty(value="Addr")
            public final Builder addr(String addr) {
                this.addr = Objects.requireNonNull(addr, "addr");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @JsonProperty(value="Name")
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            public Node build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Node(this.id, this.ip, this.addr, this.name);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("id");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("ip");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("addr");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("name");
                }
                return "Cannot build Node, some of required attributes are not set " + attributes;
            }
        }
    }

    static final class Builder {
        private static final long INIT_BIT_CREATED = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private static final long INIT_BIT_CONFIG = 4L;
        private static final long INIT_BIT_STATE = 8L;
        private static final long INIT_BIT_IMAGE = 16L;
        private static final long INIT_BIT_NETWORK_SETTINGS = 32L;
        private static final long INIT_BIT_RESOLV_CONF_PATH = 64L;
        private static final long INIT_BIT_HOSTNAME_PATH = 128L;
        private static final long INIT_BIT_HOSTS_PATH = 256L;
        private static final long INIT_BIT_NAME = 512L;
        private static final long INIT_BIT_DRIVER = 1024L;
        private static final long INIT_BIT_PROCESS_LABEL = 2048L;
        private static final long INIT_BIT_MOUNT_LABEL = 4096L;
        private static final long INIT_BIT_APP_ARMOR_PROFILE = 8192L;
        private static final long INIT_BIT_LOG_PATH = 16384L;
        private static final long INIT_BIT_RESTART_COUNT = 32768L;
        private long initBits = 65535L;
        private String id;
        private Date created;
        private String path;
        private List<String> args = new ArrayList<String>();
        private ContainerConfig config;
        private HostConfig hostConfig;
        private ContainerState state;
        private String image;
        private NetworkSettings networkSettings;
        private String resolvConfPath;
        private String hostnamePath;
        private String hostsPath;
        private String name;
        private String driver;
        private String execDriver;
        private String processLabel;
        private String mountLabel;
        private String appArmorProfile;
        private List<String> execIds = null;
        private String logPath;
        private Long restartCount;
        private List<ContainerMount> mounts = null;
        private ContainerInfo.Node node;

        private Builder() {
        }

        public final Builder from(ContainerInfo instance) {
            ContainerInfo.Node nodeValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.id();
            if (idValue != null) {
                this.id(idValue);
            }
            this.created(instance.created());
            this.path(instance.path());
            this.addAllArgs(instance.args());
            this.config(instance.config());
            HostConfig hostConfigValue = instance.hostConfig();
            if (hostConfigValue != null) {
                this.hostConfig(hostConfigValue);
            }
            this.state(instance.state());
            this.image(instance.image());
            this.networkSettings(instance.networkSettings());
            this.resolvConfPath(instance.resolvConfPath());
            this.hostnamePath(instance.hostnamePath());
            this.hostsPath(instance.hostsPath());
            this.name(instance.name());
            this.driver(instance.driver());
            String execDriverValue = instance.execDriver();
            if (execDriverValue != null) {
                this.execDriver(execDriverValue);
            }
            this.processLabel(instance.processLabel());
            this.mountLabel(instance.mountLabel());
            this.appArmorProfile(instance.appArmorProfile());
            List<String> execIdsValue = instance.execIds();
            if (execIdsValue != null) {
                this.addAllExecIds(execIdsValue);
            }
            this.logPath(instance.logPath());
            this.restartCount(instance.restartCount());
            List<ContainerMount> mountsValue = instance.mounts();
            if (mountsValue != null) {
                this.addAllMounts(mountsValue);
            }
            if ((nodeValue = instance.node()) != null) {
                this.node(nodeValue);
            }
            return this;
        }

        @JsonProperty(value="Id")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="Created")
        public final Builder created(Date created) {
            this.created = Objects.requireNonNull(created, "created");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Path")
        public final Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder arg(String element) {
            this.args.add(Objects.requireNonNull(element, "args element"));
            return this;
        }

        public final Builder args(String ... elements) {
            for (String element : elements) {
                this.args.add(Objects.requireNonNull(element, "args element"));
            }
            return this;
        }

        @JsonProperty(value="Args")
        public final Builder args(Iterable<String> elements) {
            this.args.clear();
            return this.addAllArgs(elements);
        }

        public final Builder addAllArgs(Iterable<String> elements) {
            for (String element : elements) {
                this.args.add(Objects.requireNonNull(element, "args element"));
            }
            return this;
        }

        @JsonProperty(value="Config")
        public final Builder config(ContainerConfig config) {
            this.config = Objects.requireNonNull(config, "config");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="HostConfig")
        public final Builder hostConfig(@Nullable HostConfig hostConfig) {
            this.hostConfig = hostConfig;
            return this;
        }

        @JsonProperty(value="State")
        public final Builder state(ContainerState state) {
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Image")
        public final Builder image(String image) {
            this.image = Objects.requireNonNull(image, "image");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="NetworkSettings")
        public final Builder networkSettings(NetworkSettings networkSettings) {
            this.networkSettings = Objects.requireNonNull(networkSettings, "networkSettings");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="ResolvConfPath")
        public final Builder resolvConfPath(String resolvConfPath) {
            this.resolvConfPath = Objects.requireNonNull(resolvConfPath, "resolvConfPath");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="HostnamePath")
        public final Builder hostnamePath(String hostnamePath) {
            this.hostnamePath = Objects.requireNonNull(hostnamePath, "hostnamePath");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="HostsPath")
        public final Builder hostsPath(String hostsPath) {
            this.hostsPath = Objects.requireNonNull(hostsPath, "hostsPath");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="Name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="Driver")
        public final Builder driver(String driver) {
            this.driver = Objects.requireNonNull(driver, "driver");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="ExecDriver")
        public final Builder execDriver(@Nullable String execDriver) {
            this.execDriver = execDriver;
            return this;
        }

        @JsonProperty(value="ProcessLabel")
        public final Builder processLabel(String processLabel) {
            this.processLabel = Objects.requireNonNull(processLabel, "processLabel");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @JsonProperty(value="MountLabel")
        public final Builder mountLabel(String mountLabel) {
            this.mountLabel = Objects.requireNonNull(mountLabel, "mountLabel");
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        @JsonProperty(value="AppArmorProfile")
        public final Builder appArmorProfile(String appArmorProfile) {
            this.appArmorProfile = Objects.requireNonNull(appArmorProfile, "appArmorProfile");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        public final Builder execId(String element) {
            if (this.execIds == null) {
                this.execIds = new ArrayList<String>();
            }
            this.execIds.add(Objects.requireNonNull(element, "execIds element"));
            return this;
        }

        public final Builder execIds(String ... elements) {
            if (this.execIds == null) {
                this.execIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.execIds.add(Objects.requireNonNull(element, "execIds element"));
            }
            return this;
        }

        @JsonProperty(value="ExecIDs")
        public final Builder execIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.execIds = null;
                return this;
            }
            this.execIds = new ArrayList<String>();
            return this.addAllExecIds(elements);
        }

        public final Builder addAllExecIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "execIds element");
            if (this.execIds == null) {
                this.execIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.execIds.add(Objects.requireNonNull(element, "execIds element"));
            }
            return this;
        }

        @JsonProperty(value="LogPath")
        public final Builder logPath(String logPath) {
            this.logPath = Objects.requireNonNull(logPath, "logPath");
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        @JsonProperty(value="RestartCount")
        public final Builder restartCount(Long restartCount) {
            this.restartCount = Objects.requireNonNull(restartCount, "restartCount");
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        public final Builder mount(ContainerMount element) {
            if (this.mounts == null) {
                this.mounts = new ArrayList<ContainerMount>();
            }
            this.mounts.add(Objects.requireNonNull(element, "mounts element"));
            return this;
        }

        public final Builder mounts(ContainerMount ... elements) {
            if (this.mounts == null) {
                this.mounts = new ArrayList<ContainerMount>();
            }
            for (ContainerMount element : elements) {
                this.mounts.add(Objects.requireNonNull(element, "mounts element"));
            }
            return this;
        }

        @JsonProperty(value="Mounts")
        public final Builder mounts(@Nullable Iterable<? extends ContainerMount> elements) {
            if (elements == null) {
                this.mounts = null;
                return this;
            }
            this.mounts = new ArrayList<ContainerMount>();
            return this.addAllMounts(elements);
        }

        public final Builder addAllMounts(Iterable<? extends ContainerMount> elements) {
            Objects.requireNonNull(elements, "mounts element");
            if (this.mounts == null) {
                this.mounts = new ArrayList<ContainerMount>();
            }
            for (ContainerMount containerMount : elements) {
                this.mounts.add(Objects.requireNonNull(containerMount, "mounts element"));
            }
            return this;
        }

        @JsonProperty(value="Node")
        public final Builder node(@Nullable ContainerInfo.Node node) {
            this.node = node;
            return this;
        }

        public ImmutableContainerInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContainerInfo(this.id, this.created, this.path, ImmutableContainerInfo.createUnmodifiableList(true, this.args), this.config, this.hostConfig, this.state, this.image, this.networkSettings, this.resolvConfPath, this.hostnamePath, this.hostsPath, this.name, this.driver, this.execDriver, this.processLabel, this.mountLabel, this.appArmorProfile, this.execIds == null ? null : ImmutableContainerInfo.createUnmodifiableList(true, this.execIds), this.logPath, this.restartCount, this.mounts == null ? null : ImmutableContainerInfo.createUnmodifiableList(true, this.mounts), this.node);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("state");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("image");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("networkSettings");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("resolvConfPath");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("hostnamePath");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("hostsPath");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("driver");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("processLabel");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("mountLabel");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("appArmorProfile");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("logPath");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("restartCount");
            }
            return "Cannot build ContainerInfo, some of required attributes are not set " + attributes;
        }
    }
}

