/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.meson.ui.properties;

import org.eclipse.cdt.meson.ui.properties.MesonPropertyPage;
import org.eclipse.cdt.meson.ui.properties.MesonPropertyText;
import org.eclipse.cdt.meson.ui.properties.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class MesonPropertyInteger
extends MesonPropertyText {
    private MesonPropertyPage page;
    private String errorMessage;

    public MesonPropertyInteger(Composite composite, MesonPropertyPage page, String name, String initialValue, String tooltip) {
        super(composite, name, initialValue, tooltip);
        this.page = page;
        this.text.addModifyListener(e -> {
            if (this.isValid() != page.isValid()) {
                page.update();
            }
        });
    }

    @Override
    public boolean isValid() {
        this.errorMessage = null;
        try {
            Integer.parseInt(this.getFieldValue());
            return true;
        }
        catch (NumberFormatException e) {
            this.errorMessage = NLS.bind((String)Messages.MesonPropertyPage_not_an_integer, (Object)this.getFieldName());
            return false;
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

