/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.resource.containers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.containers.StateBasedContainerManager;
import org.eclipse.xtext.resource.impl.AbstractContainer;

public class XcoreContainerManager
extends StateBasedContainerManager {
    protected List<IContainer> getVisibleContainers(List<String> handles, IResourceDescriptions resourceDescriptions) {
        if (handles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)handles.size());
        for (String handle : handles) {
            FilteringContainer otherContainer;
            IContainer container = this.createContainer(handle, resourceDescriptions);
            if (container.isEmpty() && !result.isEmpty()) continue;
            FilteringContainer xCoreContainer = new FilteringContainer(container, new Predicate<IResourceDescription>(){

                public boolean apply(IResourceDescription input) {
                    return "xcore".equals(input.getURI().fileExtension());
                }
            });
            if (!xCoreContainer.isEmpty()) {
                result.add(xCoreContainer);
            }
            if ((otherContainer = new FilteringContainer(container, new Predicate<IResourceDescription>(){

                public boolean apply(IResourceDescription input) {
                    return !"xcore".equals(input.getURI().fileExtension());
                }
            })).isEmpty() && !result.isEmpty()) continue;
            result.add(otherContainer);
        }
        return result;
    }

    class FilteringContainer
    extends AbstractContainer {
        protected IContainer container;
        protected Predicate<IResourceDescription> predicate;

        public FilteringContainer(IContainer container, Predicate<IResourceDescription> predicate) {
            this.container = container;
            this.predicate = predicate;
        }

        public Iterable<IResourceDescription> getResourceDescriptions() {
            return Iterables.filter((Iterable)this.container.getResourceDescriptions(), this.predicate);
        }

        public boolean hasResourceDescription(URI uri) {
            return super.hasResourceDescription(uri);
        }

        public IResourceDescription getResourceDescription(final URI uri) {
            return (IResourceDescription)Iterables.find(this.getResourceDescriptions(), (Predicate)new Predicate<IResourceDescription>(){

                public boolean apply(IResourceDescription input) {
                    return uri.equals(input.getURI());
                }
            }, null);
        }
    }
}

