/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.diagram.ui.tools.api.color.ColorManager;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.InventoryColorDescriptor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ColorPaletteComposite
extends Composite {
    public static final int BUTTON_SIZE = 25;
    public static final int BUTTONS_HORIZONTAL_SPACING = 2;
    protected static final String BUTTON_COLOR_DATA_KEY = "color";
    private int numberOfColumns;
    private boolean droppingAllowed;
    private RGB paletteSelectedColor;
    private List<RGB> colors = new ArrayList<RGB>();
    private final Map<RGB, Image> rgbToImages = new HashMap<RGB, Image>();
    private final Map<Button, RGB> buttonMap = new LinkedHashMap<Button, RGB>();

    private ColorPaletteComposite() {
        super(null, 0);
    }

    protected ColorPaletteComposite(Composite parent, int style, List<RGB> colors, int numberOfColumns, boolean droppingAllowed) {
        super(parent, style);
        this.colors = colors;
        this.numberOfColumns = numberOfColumns;
        this.droppingAllowed = droppingAllowed;
        this.init();
    }

    public ColorPaletteComposite(Composite parent, List<RGB> colors, int numberOfColumns, boolean droppingAllowed) {
        this(parent, 0, colors, numberOfColumns, droppingAllowed);
    }

    protected void init() {
        GridLayout layout = new GridLayout(this.numberOfColumns, true);
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        this.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 0x1000000, true, true, 1, 1);
        this.setLayoutData(layoutData);
        DropTarget target = new DropTarget((Control)this, 3);
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            /*
             * WARNING - void declaration
             */
            public void drop(DropTargetEvent dropEvent) {
                Object object = dropEvent.data;
                if (object instanceof String) {
                    void droppedColorString;
                    String string = (String)object;
                    String cfr_ignored_0 = (String)object;
                    ColorPaletteComposite.this.dropColorOnPalette((String)droppedColorString);
                }
            }
        });
        this.refreshColorButtons();
    }

    public boolean isDroppingAllowed() {
        return this.droppingAllowed;
    }

    public List<RGB> getColors() {
        return this.colors;
    }

    public RGB getPaletteSelectedColor() {
        return this.paletteSelectedColor;
    }

    private void refreshColorButtons() {
        if (this.colors.isEmpty()) {
            ((GridLayout)this.getLayout()).marginBottom = 25;
            ((GridLayout)this.getLayout()).marginRight = 25 * this.numberOfColumns + 2 * (this.numberOfColumns - 1);
        } else {
            ((GridLayout)this.getLayout()).marginBottom = 0;
            ((GridLayout)this.getLayout()).marginRight = 0;
        }
        if (this.colors.size() < this.buttonMap.size()) {
            for (Button button : this.buttonMap.keySet()) {
                button.dispose();
            }
            this.buttonMap.clear();
        }
        ArrayList<Button> buttonsList = new ArrayList<Button>(this.buttonMap.keySet());
        int i = 0;
        while (i < this.colors.size()) {
            RGB color = this.colors.get(i);
            Button button = i < buttonsList.size() ? buttonsList.get(i) : this.createColorButton();
            if (!this.rgbToImages.containsKey(color)) {
                InventoryColorDescriptor colorDesc = new InventoryColorDescriptor(color);
                this.rgbToImages.put(color, colorDesc.createImage());
            }
            Image image = this.rgbToImages.get(color);
            String rgbString = ColorManager.getDefault().rgbToString(color);
            button.setData(BUTTON_COLOR_DATA_KEY, (Object)rgbString);
            button.setImage(image);
            button.setToolTipText(rgbString);
            this.buttonMap.put(button, color);
            ++i;
        }
        this.layout();
    }

    private Button createColorButton() {
        final Button button = new Button((Composite)this, 8);
        GridData buttonData = new GridData(25, 25);
        button.setLayoutData((Object)buttonData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e1) {
                String colorString = (String)button.getData(ColorPaletteComposite.BUTTON_COLOR_DATA_KEY);
                RGB convertedColor = ColorManager.getDefault().stringToRGB(colorString);
                ColorPaletteComposite.this.selectColor(convertedColor);
            }
        });
        button.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ColorPaletteComposite.this.handleDoubleClick(button);
            }
        });
        DragSource source = new DragSource((Control)button, 3);
        source.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            /*
             * WARNING - void declaration
             */
            public void dragSetData(DragSourceEvent dragEvent) {
                Object object = button.getData(ColorPaletteComposite.BUTTON_COLOR_DATA_KEY);
                if (object instanceof String) {
                    void draggedColorString;
                    String string = (String)object;
                    String cfr_ignored_0 = (String)object;
                    ColorPaletteComposite.this.dragColor(button, (String)draggedColorString, dragEvent);
                }
            }

            public void dragFinished(DragSourceEvent event) {
                ColorPaletteComposite.this.refreshColorButtons();
            }
        });
        DropTarget target = new DropTarget((Control)button, 3);
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            /*
             * WARNING - void declaration
             */
            public void drop(DropTargetEvent dropEvent) {
                Object object = dropEvent.data;
                if (object instanceof String) {
                    void droppedColorString;
                    String string = (String)object;
                    String cfr_ignored_0 = (String)object;
                    ColorPaletteComposite.this.dropColorOnButton(button, (String)droppedColorString);
                }
            }
        });
        return button;
    }

    protected void dragColor(Button button, String draggedColorString, DragSourceEvent dragEvent) {
        dragEvent.data = draggedColorString;
    }

    protected void dropColorOnButton(Button targetButton, String droppedColorString) {
        if (targetButton.getParent() instanceof ColorPaletteComposite && this.isDroppingAllowed()) {
            RGB sourceDroppedColor = ColorManager.getDefault().stringToRGB(droppedColorString);
            String targetColor = (String)targetButton.getData(BUTTON_COLOR_DATA_KEY);
            RGB targetRGB = ColorManager.getDefault().stringToRGB(targetColor);
            int targetIndex = this.colors.indexOf(targetRGB);
            int sourceIndex = this.colors.indexOf(sourceDroppedColor);
            if (targetIndex != -1 && !this.colors.contains(sourceDroppedColor)) {
                this.addColor(targetIndex, sourceDroppedColor);
            } else if (targetIndex != -1 && sourceIndex != -1) {
                Collections.swap(this.colors, targetIndex, sourceIndex);
            }
        }
    }

    protected void dropColorOnPalette(String droppedColorString) {
        RGB sourceDroppedColor;
        if (this.isDroppingAllowed() && !this.colors.contains(sourceDroppedColor = ColorManager.getDefault().stringToRGB(droppedColorString))) {
            this.addColor(this.colors.size(), sourceDroppedColor);
        }
    }

    protected void handleDoubleClick(Button button) {
    }

    public void selectColor(RGB selectedColor) {
        this.setPaletteSelectedColor(selectedColor);
    }

    public boolean removeColor(RGB colorToRemove) {
        boolean hasBeenRemoved = this.basicRemoveColor(colorToRemove);
        if (hasBeenRemoved) {
            this.refreshColorButtons();
        }
        return hasBeenRemoved;
    }

    protected boolean basicRemoveColor(RGB colorToRemove) {
        return this.colors.remove(colorToRemove);
    }

    public boolean addColor(int index, RGB colorToAdd) {
        boolean alreadyExistingColor = this.colors.contains(colorToAdd);
        if (!alreadyExistingColor) {
            this.colors.add(index, colorToAdd);
            this.refreshColorButtons();
        }
        return !alreadyExistingColor;
    }

    public boolean addColor(RGB colorToAdd) {
        return this.addColor(this.colors.size(), colorToAdd);
    }

    public void sortColors() {
        List<RGB> sortedColors = ColorManager.getDefault().sortColors(this.colors);
        this.colors.clear();
        this.colors.addAll(sortedColors);
        this.refreshColorButtons();
    }

    public void setPaletteSelectedColor(RGB colorToSet) {
        this.paletteSelectedColor = colorToSet;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public void dispose() {
        this.buttonMap.keySet().forEach(button -> button.dispose());
        this.buttonMap.clear();
        this.rgbToImages.values().forEach(image -> image.dispose());
        this.rgbToImages.clear();
        super.dispose();
    }
}

