/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmSimpleState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioHistoryBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;

public class DataDrivenScenarioInfo {
    public static final DataDrivenScenarioInfo DUMMY_SCENARIO = new DataDrivenScenarioInfo(DataDrivenFsmSimpleState.createFinalState(""), DataDrivenScenarioHistoryBuilder.ScenarioStatusType.PENDING, -1, -1, null);
    private static final String START_TIME = "startTime";
    private final int fQuark;
    private final int fStatusQuark;
    private DataDrivenFsmState fActiveState;
    private DataDrivenScenarioHistoryBuilder.ScenarioStatusType fStatus;
    private final Map<@NonNull TmfAttributePool, Integer> fPoolAttributes = new HashMap<TmfAttributePool, Integer>();
    private final @Nullable DataDrivenFsm fFsm;

    public DataDrivenScenarioInfo(DataDrivenFsmState activeState, DataDrivenScenarioHistoryBuilder.ScenarioStatusType status, int quark, int statusQuark, @Nullable DataDrivenFsm fsm) {
        this.fActiveState = activeState;
        this.fQuark = quark;
        this.fStatus = status;
        this.fStatusQuark = statusQuark;
        this.fFsm = fsm;
    }

    public void setActiveState(DataDrivenFsmState activeState) {
        this.fActiveState = activeState;
    }

    public void setStatus(DataDrivenScenarioHistoryBuilder.ScenarioStatusType status) {
        this.fStatus = status;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public DataDrivenFsmState getActiveState() {
        return this.fActiveState;
    }

    public DataDrivenScenarioHistoryBuilder.ScenarioStatusType getStatus() {
        return this.fStatus;
    }

    public int getStatusQuark() {
        return this.fStatusQuark;
    }

    public Integer getAttributeFromPool(TmfAttributePool pool) {
        return this.fPoolAttributes.computeIfAbsent(pool, TmfAttributePool::getAvailable);
    }

    public void recycleAttributes(long ts) {
        this.fPoolAttributes.entrySet().forEach(e -> ((TmfAttributePool)NonNullUtils.checkNotNull((Object)((TmfAttributePool)e.getKey()))).recycle(((Integer)e.getValue()).intValue(), ts));
    }

    public long getStateStartTime(IAnalysisDataContainer container, String state) {
        ITmfStateSystem stateSystem = container.getStateSystem();
        int stateQuark = stateSystem.optQuarkRelative(this.fQuark, new String[]{"state", state, START_TIME});
        if (stateQuark < 0) {
            return -1L;
        }
        Object startTs = stateSystem.queryOngoing(stateQuark);
        if (startTs instanceof Long) {
            return (Long)startTs;
        }
        return -1L;
    }

    public @Nullable DataDrivenFsm getFsm() {
        return this.fFsm;
    }
}

