/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.actions.assistant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.core.editor.actions.assistant.ILayoutAssistantPage;
import org.eclipse.wb.core.editor.actions.assistant.LayoutAssistantListener;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.actions.assistant.ShellLocationTracker;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.TabFactory;

public class LayoutAssistantWindow
extends Window {
    private final ShellLocationTracker m_locationTracker;
    private TabFolder m_tabContainer;
    private List<ILayoutAssistantPage> m_pages;
    private List<ObjectInfo> m_selectedComponents;

    public LayoutAssistantWindow(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2148);
        this.m_locationTracker = new ShellLocationTracker(DesignerPlugin.getDefault().getDialogSettings(), ((Object)((Object)this)).getClass().getName());
    }

    public void hide() {
        Shell shell = this.getShell();
        if (shell != null) {
            shell.setVisible(false);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LayoutAssistantWindow_title);
        this.m_locationTracker.setShell(newShell);
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.m_tabContainer = new TabFolder(parent, 0);
        return this.m_tabContainer;
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.m_locationTracker.getInitialLocation(initialSize);
    }

    /*
     * WARNING - void declaration
     */
    public void update(List<Object> selectedObjects) {
        block18: {
            if (this.m_selectedComponents != null && this.m_selectedComponents.equals(selectedObjects)) {
                boolean isValidPages = true;
                for (ILayoutAssistantPage page : this.m_pages) {
                    if (page.isPageValid()) continue;
                    isValidPages = false;
                    break;
                }
                if (isValidPages) {
                    this.updatePages();
                    return;
                }
            }
            try {
                this.getShell().setRedraw(false);
                this.getShell().setEnabled(false);
                String selectedPageTitle = null;
                int index = this.m_tabContainer.getSelectionIndex();
                if (index > 0) {
                    selectedPageTitle = this.m_tabContainer.getItem(index).getText();
                }
                Object object = this.m_tabContainer.getItems();
                int n = ((TabItem[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem tabItem = object[n2];
                    tabItem.getControl().dispose();
                    tabItem.dispose();
                    ++n2;
                }
                this.m_pages = new ArrayList<ILayoutAssistantPage>();
                this.m_selectedComponents = new ArrayList<ObjectInfo>();
                ObjectInfo parent = null;
                for (Object object2 : selectedObjects) {
                    Object object3 = object2;
                    if (object3 instanceof ObjectInfo) {
                        void component;
                        ObjectInfo cfr_ignored_0 = (ObjectInfo)object3;
                        ObjectInfo cfr_ignored_1 = (ObjectInfo)object3;
                        this.m_selectedComponents.add((ObjectInfo)component);
                        if (parent == null) {
                            parent = component.getParent();
                            continue;
                        }
                        if (parent == component.getParent()) continue;
                        this.showMessage(Messages.LayoutAssistantWindow_singleParent);
                        return;
                    }
                    this.showMessage(Messages.LayoutAssistantWindow_notObjectSelected);
                    return;
                }
                if (this.m_selectedComponents.isEmpty()) {
                    this.showMessage(Messages.LayoutAssistantWindow_emptySelection);
                    return;
                }
                ExecutionUtils.runLog(new RunnableEx(){

                    @Override
                    public void run() throws Exception {
                        ObjectInfo component = LayoutAssistantWindow.this.m_selectedComponents.get(0);
                        LayoutAssistantListener listener = component.getBroadcast(LayoutAssistantListener.class);
                        listener.createAssistantPages(LayoutAssistantWindow.this.m_selectedComponents, LayoutAssistantWindow.this.m_tabContainer, LayoutAssistantWindow.this.m_pages);
                    }
                });
                if (this.m_pages.isEmpty()) {
                    this.showMessage(Messages.LayoutAssistantWindow_noAssistanceForSelection);
                    break block18;
                }
                this.updatePages();
                if (selectedPageTitle == null) break block18;
                object = this.m_tabContainer.getItems();
                int n3 = ((TabItem[])object).length;
                int n4 = 0;
                while (n4 < n3) {
                    TabItem item = object[n4];
                    if (selectedPageTitle.equals(item.getText())) {
                        this.m_tabContainer.setSelection(item);
                        break;
                    }
                    ++n4;
                }
            }
            finally {
                this.getShell().setEnabled(true);
                this.getShell().setRedraw(true);
                this.getShell().layout();
                this.getShell().pack();
            }
        }
    }

    private void updatePages() {
        for (ILayoutAssistantPage page : this.m_pages) {
            page.updatePage();
        }
    }

    private void showMessage(String message) {
        Composite composite = new Composite((Composite)this.m_tabContainer, 0);
        GridLayoutFactory.create(composite).margins(15);
        Label label = new Label(composite, 0x1000000);
        GridDataFactory.create((Control)label).grab().alignHC().alignVM();
        label.setText(message);
        TabFactory.item(this.m_tabContainer).text(Messages.LayoutAssistantWindow_infoTab).control((Control)composite);
    }
}

