"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDefaultGetTsPluginClient = exports.getVueLanguageServicePlugins = void 0;
__exportStar(require("@volar/language-service"), exports);
__exportStar(require("@vue/language-core"), exports);
__exportStar(require("./lib/ideFeatures/nameCasing"), exports);
__exportStar(require("./lib/types"), exports);
const volar_service_emmet_1 = require("volar-service-emmet");
const volar_service_json_1 = require("volar-service-json");
const volar_service_pug_beautify_1 = require("volar-service-pug-beautify");
const volar_service_typescript_1 = require("volar-service-typescript");
const volar_service_typescript_twoslash_queries_1 = require("volar-service-typescript-twoslash-queries");
const docCommentTemplate_1 = require("volar-service-typescript/lib/plugins/docCommentTemplate");
const syntactic_1 = require("volar-service-typescript/lib/plugins/syntactic");
const css_1 = require("./lib/plugins/css");
const vue_autoinsert_dotvalue_1 = require("./lib/plugins/vue-autoinsert-dotvalue");
const vue_autoinsert_parentheses_1 = require("./lib/plugins/vue-autoinsert-parentheses");
const vue_autoinsert_space_1 = require("./lib/plugins/vue-autoinsert-space");
const vue_directive_comments_1 = require("./lib/plugins/vue-directive-comments");
const vue_document_drop_1 = require("./lib/plugins/vue-document-drop");
const vue_document_links_1 = require("./lib/plugins/vue-document-links");
const vue_extract_file_1 = require("./lib/plugins/vue-extract-file");
const vue_sfc_1 = require("./lib/plugins/vue-sfc");
const vue_template_1 = require("./lib/plugins/vue-template");
const vue_toggle_v_bind_codeaction_1 = require("./lib/plugins/vue-toggle-v-bind-codeaction");
const vue_twoslash_queries_1 = require("./lib/plugins/vue-twoslash-queries");
const vue_visualize_hidden_callback_param_1 = require("./lib/plugins/vue-visualize-hidden-callback-param");
const common_1 = require("@vue/typescript-plugin/lib/common");
const collectExtractProps_1 = require("@vue/typescript-plugin/lib/requests/collectExtractProps");
const componentInfos_1 = require("@vue/typescript-plugin/lib/requests/componentInfos");
const getImportPathForFile_1 = require("@vue/typescript-plugin/lib/requests/getImportPathForFile");
const getPropertiesAtLocation_1 = require("@vue/typescript-plugin/lib/requests/getPropertiesAtLocation");
const getQuickInfoAtPosition_1 = require("@vue/typescript-plugin/lib/requests/getQuickInfoAtPosition");
function getVueLanguageServicePlugins(ts, getVueOptions, getTsPluginClient = createDefaultGetTsPluginClient(ts, getVueOptions), hybridMode = false) {
    const plugins = [];
    if (!hybridMode) {
        plugins.push(...(0, volar_service_typescript_1.create)(ts));
        for (let i = 0; i < plugins.length; i++) {
            const plugin = plugins[i];
            if (plugin.name === 'typescript-semantic') {
                plugins[i] = {
                    ...plugin,
                    create(context) {
                        const created = plugin.create(context);
                        if (!context.language.typescript) {
                            return created;
                        }
                        const languageService = created.provide['typescript/languageService']();
                        const vueOptions = getVueOptions(context.env);
                        (0, common_1.decorateLanguageServiceForVue)(context.language, languageService, vueOptions, ts, false, fileName => context.env.typescript.fileNameToUri(fileName));
                        return created;
                    },
                };
                break;
            }
        }
    }
    else {
        plugins.push((0, syntactic_1.create)(ts), (0, docCommentTemplate_1.create)(ts));
    }
    plugins.push((0, volar_service_typescript_twoslash_queries_1.create)(ts), (0, css_1.create)(), (0, volar_service_pug_beautify_1.create)(), (0, volar_service_json_1.create)(), (0, vue_template_1.create)('html', ts, getVueOptions, getTsPluginClient), (0, vue_template_1.create)('pug', ts, getVueOptions, getTsPluginClient), (0, vue_sfc_1.create)(), (0, vue_twoslash_queries_1.create)(ts, getTsPluginClient), (0, vue_document_links_1.create)(), (0, vue_document_drop_1.create)(ts, getVueOptions, getTsPluginClient), (0, vue_autoinsert_dotvalue_1.create)(ts, getTsPluginClient), (0, vue_autoinsert_parentheses_1.create)(ts), (0, vue_autoinsert_space_1.create)(), (0, vue_visualize_hidden_callback_param_1.create)(), (0, vue_directive_comments_1.create)(), (0, vue_extract_file_1.create)(ts, getTsPluginClient), (0, vue_toggle_v_bind_codeaction_1.create)(ts), (0, volar_service_emmet_1.create)({
        mappedLanguages: {
            'vue': 'html',
            'postcss': 'scss',
        },
    }));
    return plugins;
}
exports.getVueLanguageServicePlugins = getVueLanguageServicePlugins;
function createDefaultGetTsPluginClient(ts, getVueOptions) {
    return context => {
        if (!context.language.typescript) {
            return;
        }
        const languageService = context.inject('typescript/languageService');
        if (!languageService) {
            return;
        }
        const requestContext = {
            typescript: ts,
            language: context.language,
            languageService,
            languageServiceHost: context.language.typescript.languageServiceHost,
            vueOptions: getVueOptions(context.env),
            isTsPlugin: false,
            getFileId: context.env.typescript.fileNameToUri,
        };
        return {
            async collectExtractProps(...args) {
                return await collectExtractProps_1.collectExtractProps.apply(requestContext, args);
            },
            async getPropertiesAtLocation(...args) {
                return await getPropertiesAtLocation_1.getPropertiesAtLocation.apply(requestContext, args);
            },
            async getImportPathForFile(...args) {
                return await getImportPathForFile_1.getImportPathForFile.apply(requestContext, args);
            },
            async getComponentEvents(...args) {
                return await componentInfos_1.getComponentEvents.apply(requestContext, args);
            },
            async getComponentNames(...args) {
                return await componentInfos_1.getComponentNames.apply(requestContext, args);
            },
            async getComponentProps(...args) {
                return await componentInfos_1.getComponentProps.apply(requestContext, args);
            },
            async getElementAttrs(...args) {
                return await componentInfos_1.getElementAttrs.apply(requestContext, args);
            },
            async getTemplateContextProps(...args) {
                return await componentInfos_1.getTemplateContextProps.apply(requestContext, args);
            },
            async getQuickInfoAtPosition(...args) {
                return await getQuickInfoAtPosition_1.getQuickInfoAtPosition.apply(requestContext, args);
            },
        };
    };
}
exports.createDefaultGetTsPluginClient = createDefaultGetTsPluginClient;
//# sourceMappingURL=index.js.map