/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.model;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.debugger.breakpoint.SPLineBreakpoint;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugElement;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugTarget;
import org.eclipse.datatools.sqltools.debugger.model.SPValue;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public abstract class SPThread
extends SPDebugElement
implements IThread,
IConnectionTracker {
    public static final IBreakpoint[] EMPTY_BREAKPOINTS = new IBreakpoint[0];
    private boolean _terminated = false;
    private boolean _running = true;
    private boolean _stepping = false;
    private List _stackFrames = null;
    private boolean _needRefreshStackFrames = true;
    private Map _globalVariables = null;
    private boolean _needRefreshGlobalVariables = true;
    private DatabaseIdentifier _databaseIdentifier;

    public SPThread(SPDebugTarget target, DatabaseIdentifier databaseIdentifier) {
        super(target);
        this._databaseIdentifier = databaseIdentifier;
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }

    protected abstract List updateStackFrames(List var1) throws DebugException;

    protected void calculateStackFrames() throws DebugException {
        if (this._stackFrames == null) {
            this._stackFrames = new ArrayList();
            this._needRefreshStackFrames = true;
        }
        if (this._needRefreshStackFrames) {
            this._stackFrames = this.updateStackFrames(this._stackFrames);
            this._needRefreshStackFrames = false;
        }
    }

    public List getStackFramesAsList() throws DebugException {
        if (!this.isSuspended()) {
            return new ArrayList();
        }
        this.calculateStackFrames();
        return this._stackFrames;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        List list = this.getStackFramesAsList();
        return list.toArray(new IStackFrame[list.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        return !this.getStackFramesAsList().isEmpty();
    }

    protected void refresh() {
        this._needRefreshStackFrames = true;
        this._needRefreshGlobalVariables = true;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (this.isTerminated() || !this.isSuspended()) {
            return null;
        }
        this.calculateStackFrames();
        if (this._stackFrames.isEmpty()) {
            return null;
        }
        return (IStackFrame)this._stackFrames.get(0);
    }

    public IStackFrame getBottomStackFrame() throws DebugException {
        if (this.isTerminated() || !this.isSuspended()) {
            return null;
        }
        this.calculateStackFrames();
        if (this._stackFrames.isEmpty()) {
            return null;
        }
        return (IStackFrame)this._stackFrames.get(this._stackFrames.size() - 1);
    }

    protected abstract Map updateGlobalVariables(Map var1) throws DebugException;

    protected void calculateGlobalVariables() throws DebugException {
        if (this._globalVariables == null) {
            this._globalVariables = new HashMap();
            this._needRefreshGlobalVariables = true;
        }
        if (this._needRefreshGlobalVariables) {
            this._globalVariables = this.updateGlobalVariables(this._globalVariables);
            this._needRefreshGlobalVariables = false;
        }
    }

    public IVariable[] getGlobalVariables() throws DebugException {
        if (!this.isSuspended()) {
            return new IVariable[0];
        }
        this.calculateGlobalVariables();
        return this._globalVariables.values().toArray(new IVariable[this._globalVariables.size()]);
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint instanceof SPLineBreakpoint) {
            SPLineBreakpoint b = (SPLineBreakpoint)breakpoint;
            try {
                ProcIdentifier pi = b.getProcIdentifier();
                String profileName = pi.getDatabaseIdentifier().getProfileName();
                return this.getDatabaseIdentifier().getProfileName().equals(profileName);
            }
            catch (CoreException ex) {
                DebuggerCorePlugin.getDefault().log(ex);
                return false;
            }
        }
        return false;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return !this._running && !this.isTerminated();
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        return this.canStep();
    }

    protected boolean canStep() {
        try {
            return this.isSuspended() && !this.isStepping() && this.getTopStackFrame() != null;
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean isStepping() {
        return this._stepping;
    }

    protected void setRunning(boolean b) {
        this._running = b;
    }

    protected void setStepping(boolean b) {
        this._stepping = b;
    }

    public boolean isTerminated() {
        return this._terminated;
    }

    protected void terminated() {
        this._terminated = true;
        this.getSPDebugTarget().terminated();
    }

    public boolean canDisconnect() {
        return false;
    }

    public final void breakpointHit() {
        this.suspended(16);
    }

    public final void interrupted() {
        this.suspended(32);
    }

    public final void singleStepped() {
        this.suspended(8);
    }

    protected void suspended(int detail) {
        this.getSPDebugTarget().internalIncreaseSuspendCount();
        this.refresh();
        this.setRunning(false);
        this.setStepping(false);
        this.fireSuspendEvent(detail);
    }

    public void connectionClosed() {
        if (!this.isTerminated()) {
            this.setRunning(false);
            this.setStepping(false);
            this.terminated();
            this.fireTerminateEvent();
        }
    }

    protected abstract void cleanup();

    public abstract void disconnect() throws DebugException;

    public boolean supportEvaluateExpression() {
        return false;
    }

    public SPValue evaluateExpression(String expression) throws DebugException {
        this.notSupported();
        return null;
    }

    public abstract Connection getDebuggerConnection();

    public void connectionAboutToBeClosed() {
    }
}

