/*
 * Copyright (c) 2012, 2013, 2015, 2016, 2019, 2023 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.security.provider;

import org.eclipse.emf.cdo.expressions.ContainedObject;
import org.eclipse.emf.cdo.expressions.ExpressionsPackage;
import org.eclipse.emf.cdo.expressions.util.ExpressionsSwitch;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.util.SecurityAdapterFactory;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SecurityItemProviderAdapterFactory extends SecurityAdapterFactory
    implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender
{
  /**
   * This keeps track of the root adapter factory that delegates to this adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ComposedAdapterFactory parentAdapterFactory;

  /**
   * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

  /**
   * This helps manage the child creation extenders.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(SecurityEditPlugin.INSTANCE, SecurityPackage.eNS_URI);

  /**
   * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected Collection<Object> supportedTypes = new ArrayList<>();

  /**
   * This constructs an instance.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SecurityItemProviderAdapterFactory()
  {
    supportedTypes.add(IEditingDomainItemProvider.class);
    supportedTypes.add(IStructuredItemContentProvider.class);
    supportedTypes.add(ITreeItemContentProvider.class);
    supportedTypes.add(IItemLabelProvider.class);
    supportedTypes.add(IItemPropertySource.class);
    supportedTypes.add(ITableItemLabelProvider.class);
    supportedTypes.add(ITableItemColorProvider.class);
    supportedTypes.add(ITableItemFontProvider.class);
    supportedTypes.add(IItemColorProvider.class);
    supportedTypes.add(IItemFontProvider.class);
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.Realm} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected RealmItemProvider realmItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.Realm}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createRealmAdapter()
  {
    if (realmItemProvider == null)
    {
      realmItemProvider = new RealmItemProvider(this);
    }

    return realmItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.Directory} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected DirectoryItemProvider directoryItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.Directory}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createDirectoryAdapter()
  {
    if (directoryItemProvider == null)
    {
      directoryItemProvider = new DirectoryItemProvider(this);
    }

    return directoryItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.Role} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected RoleItemProvider roleItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.Role}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createRoleAdapter()
  {
    if (roleItemProvider == null)
    {
      roleItemProvider = new RoleItemProvider(this);
    }

    return roleItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.Group} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected GroupItemProvider groupItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.Group}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createGroupAdapter()
  {
    if (groupItemProvider == null)
    {
      groupItemProvider = new GroupItemProvider(this);
    }

    return groupItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.User} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected UserItemProvider userItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.User}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createUserAdapter()
  {
    if (userItemProvider == null)
    {
      userItemProvider = new UserItemProvider(this);
    }

    return userItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.UserPassword} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected UserPasswordItemProvider userPasswordItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.UserPassword}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createUserPasswordAdapter()
  {
    if (userPasswordItemProvider == null)
    {
      userPasswordItemProvider = new UserPasswordItemProvider(this);
    }

    return userPasswordItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.ClassPermission} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Deprecated
  protected ClassPermissionItemProvider classPermissionItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.ClassPermission}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Deprecated
  @Override
  public Adapter createClassPermissionAdapter()
  {
    if (classPermissionItemProvider == null)
    {
      classPermissionItemProvider = new ClassPermissionItemProvider(this);
    }

    return classPermissionItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.PackagePermission} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Deprecated
  protected PackagePermissionItemProvider packagePermissionItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.PackagePermission}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Deprecated
  @Override
  public Adapter createPackagePermissionAdapter()
  {
    if (packagePermissionItemProvider == null)
    {
      packagePermissionItemProvider = new PackagePermissionItemProvider(this);
    }

    return packagePermissionItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.ResourcePermission} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Deprecated
  protected ResourcePermissionItemProvider resourcePermissionItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.ResourcePermission}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Deprecated
  @Override
  public Adapter createResourcePermissionAdapter()
  {
    if (resourcePermissionItemProvider == null)
    {
      resourcePermissionItemProvider = new ResourcePermissionItemProvider(this);
    }

    return resourcePermissionItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.FilterPermission} instances.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  protected FilterPermissionItemProvider filterPermissionItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.FilterPermission}.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createFilterPermissionAdapter()
  {
    if (filterPermissionItemProvider == null)
    {
      filterPermissionItemProvider = new FilterPermissionItemProvider(this);
    }

    return filterPermissionItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.LinkedFilter} instances.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  protected LinkedFilterItemProvider linkedFilterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.LinkedFilter}.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createLinkedFilterAdapter()
  {
    if (linkedFilterItemProvider == null)
    {
      linkedFilterItemProvider = new LinkedFilterItemProvider(this);
    }

    return linkedFilterItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.PackageFilter} instances.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  protected PackageFilterItemProvider packageFilterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.PackageFilter}.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createPackageFilterAdapter()
  {
    if (packageFilterItemProvider == null)
    {
      packageFilterItemProvider = new PackageFilterItemProvider(this);
    }

    return packageFilterItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.ClassFilter} instances.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  protected ClassFilterItemProvider classFilterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.ClassFilter}.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createClassFilterAdapter()
  {
    if (classFilterItemProvider == null)
    {
      classFilterItemProvider = new ClassFilterItemProvider(this);
    }

    return classFilterItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.ResourceFilter} instances.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  protected ResourceFilterItemProvider resourceFilterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.ResourceFilter}.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createResourceFilterAdapter()
  {
    if (resourceFilterItemProvider == null)
    {
      resourceFilterItemProvider = new ResourceFilterItemProvider(this);
    }

    return resourceFilterItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.ExpressionFilter} instances.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  protected ExpressionFilterItemProvider expressionFilterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.ExpressionFilter}.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createExpressionFilterAdapter()
  {
    if (expressionFilterItemProvider == null)
    {
      expressionFilterItemProvider = new ExpressionFilterItemProvider(this);
    }

    return expressionFilterItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.NotFilter} instances.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  protected NotFilterItemProvider notFilterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.NotFilter}.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createNotFilterAdapter()
  {
    if (notFilterItemProvider == null)
    {
      notFilterItemProvider = new NotFilterItemProvider(this);
    }

    return notFilterItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.AndFilter} instances.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  protected AndFilterItemProvider andFilterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.AndFilter}.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createAndFilterAdapter()
  {
    if (andFilterItemProvider == null)
    {
      andFilterItemProvider = new AndFilterItemProvider(this);
    }

    return andFilterItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.eclipse.emf.cdo.security.OrFilter} instances.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  protected OrFilterItemProvider orFilterItemProvider;

  /**
   * This creates an adapter for a {@link org.eclipse.emf.cdo.security.OrFilter}.
   * <!-- begin-user-doc -->
   * @since 4.3
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createOrFilterAdapter()
  {
    if (orFilterItemProvider == null)
    {
      orFilterItemProvider = new OrFilterItemProvider(this);
    }

    return orFilterItemProvider;
  }

  /**
   * This returns the root adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public ComposeableAdapterFactory getRootAdapterFactory()
  {
    return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
  }

  /**
   * This sets the composed adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
  {
    this.parentAdapterFactory = parentAdapterFactory;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object type)
  {
    return supportedTypes.contains(type) || super.isFactoryForType(type);
  }

  /**
   * This implementation substitutes the factory itself as the key for the adapter.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter adapt(Notifier notifier, Object type)
  {
    return super.adapt(notifier, this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object adapt(Object object, Object type)
  {
    if (isFactoryForType(type))
    {
      Object adapter = super.adapt(object, type);
      if (!(type instanceof Class<?>) || ((Class<?>)type).isInstance(adapter))
      {
        return adapter;
      }
    }

    return null;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public List<IChildCreationExtender> getChildCreationExtenders()
  {
    return childCreationExtenderManager.getChildCreationExtenders();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain)
  {
    return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public ResourceLocator getResourceLocator()
  {
    return childCreationExtenderManager;
  }

  /**
   * This adds a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void addListener(INotifyChangedListener notifyChangedListener)
  {
    changeNotifier.addListener(notifyChangedListener);
  }

  /**
   * This removes a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void removeListener(INotifyChangedListener notifyChangedListener)
  {
    changeNotifier.removeListener(notifyChangedListener);
  }

  /**
   * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void fireNotifyChanged(Notification notification)
  {
    changeNotifier.fireNotifyChanged(notification);

    if (parentAdapterFactory != null)
    {
      parentAdapterFactory.fireNotifyChanged(notification);
    }
  }

  /**
   * This disposes all of the item providers created by this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void dispose()
  {
    if (realmItemProvider != null)
    {
      realmItemProvider.dispose();
    }
    if (directoryItemProvider != null)
    {
      directoryItemProvider.dispose();
    }
    if (roleItemProvider != null)
    {
      roleItemProvider.dispose();
    }
    if (groupItemProvider != null)
    {
      groupItemProvider.dispose();
    }
    if (userItemProvider != null)
    {
      userItemProvider.dispose();
    }
    if (userPasswordItemProvider != null)
    {
      userPasswordItemProvider.dispose();
    }
    if (classPermissionItemProvider != null)
    {
      classPermissionItemProvider.dispose();
    }
    if (packagePermissionItemProvider != null)
    {
      packagePermissionItemProvider.dispose();
    }
    if (resourcePermissionItemProvider != null)
    {
      resourcePermissionItemProvider.dispose();
    }
    if (filterPermissionItemProvider != null)
    {
      filterPermissionItemProvider.dispose();
    }
    if (linkedFilterItemProvider != null)
    {
      linkedFilterItemProvider.dispose();
    }
    if (packageFilterItemProvider != null)
    {
      packageFilterItemProvider.dispose();
    }
    if (classFilterItemProvider != null)
    {
      classFilterItemProvider.dispose();
    }
    if (resourceFilterItemProvider != null)
    {
      resourceFilterItemProvider.dispose();
    }
    if (expressionFilterItemProvider != null)
    {
      expressionFilterItemProvider.dispose();
    }
    if (notFilterItemProvider != null)
    {
      notFilterItemProvider.dispose();
    }
    if (andFilterItemProvider != null)
    {
      andFilterItemProvider.dispose();
    }
    if (orFilterItemProvider != null)
    {
      orFilterItemProvider.dispose();
    }
  }

  /**
   * A child creation extender for the {@link ExpressionsPackage}.
   * <!-- begin-user-doc -->
  	 * @since 4.6
  	 * <!-- end-user-doc -->
   * @generated
   */
  public static class ExpressionsChildCreationExtender implements IChildCreationExtender
  {
    /**
     * The switch for creating child descriptors specific to each extended class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static class CreationSwitch extends ExpressionsSwitch<Object>
    {
      /**
       * The child descriptors being populated.
       * <!-- begin-user-doc -->
       * <!-- end-user-doc -->
       * @generated
       */
      protected List<Object> newChildDescriptors;

      /**
       * The domain in which to create the children.
       * <!-- begin-user-doc -->
       * <!-- end-user-doc -->
       * @generated
       */
      protected EditingDomain editingDomain;

      /**
       * Creates the a switch for populating child descriptors in the given domain.
       * <!-- begin-user-doc -->
       * <!-- end-user-doc -->
       * @generated
       */
      CreationSwitch(List<Object> newChildDescriptors, EditingDomain editingDomain)
      {
        this.newChildDescriptors = newChildDescriptors;
        this.editingDomain = editingDomain;
      }

      /**
       * <!-- begin-user-doc -->
       * <!-- end-user-doc -->
       * @generated
       */
      @SuppressWarnings("deprecation")
      public Object caseContainedObjectGen(ContainedObject object)
      {
        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createRealm()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createDirectory()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createRole()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createGroup()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createUser()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createUserPassword()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createClassPermission()));

        newChildDescriptors
            .add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createPackagePermission()));

        newChildDescriptors
            .add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createResourcePermission()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createFilterPermission()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createLinkedFilter()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createPackageFilter()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createClassFilter()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createResourceFilter()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createExpressionFilter()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createNotFilter()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createAndFilter()));

        newChildDescriptors.add(createChildParameter(ExpressionsPackage.Literals.CONTAINED_OBJECT__OBJECT, SecurityFactory.eINSTANCE.createOrFilter()));

        return null;
      }

      /**
       * @ADDED
       */
      @Override
      @SuppressWarnings("deprecation")
      public Object caseContainedObject(ContainedObject object)
      {
        for (Iterator<Object> it = newChildDescriptors.iterator(); it.hasNext();)
        {
          Object descriptor = it.next();
          if (descriptor instanceof CommandParameter)
          {
            CommandParameter commandParameter = (CommandParameter)descriptor;
            Object value = commandParameter.getValue();
            if (value instanceof org.eclipse.emf.cdo.security.PackagePermission //
                || value instanceof org.eclipse.emf.cdo.security.ClassPermission //
                || value instanceof org.eclipse.emf.cdo.security.ResourcePermission)
            {
              it.remove();
            }
          }
        }

        return null;
      }

      /**
       * <!-- begin-user-doc -->
       * <!-- end-user-doc -->
       * @generated
       */
      protected CommandParameter createChildParameter(Object feature, Object child)
      {
        return new CommandParameter(null, feature, child);
      }

    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Collection<Object> getNewChildDescriptors(Object object, EditingDomain editingDomain)
    {
      ArrayList<Object> result = new ArrayList<>();
      new CreationSwitch(result, editingDomain).doSwitch((EObject)object);
      return result;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public ResourceLocator getResourceLocator()
    {
      return SecurityEditPlugin.INSTANCE;
    }
  }

}
