/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionScope;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class FunctionCallParameterContext
extends StatementContext {
    private String callName;
    private int callNameOffset = -1;
    private boolean isConstructor = false;
    private boolean isMethod = false;
    private IMethod[] method;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        if (!(requestor instanceof IPHPCompletionRequestor)) {
            return false;
        }
        IPHPCompletionRequestor phpReq = (IPHPCompletionRequestor)requestor;
        try {
            PHPHeuristicScanner scanner;
            int open;
            if (offset >= phpReq.getDocument().getLength()) {
                offset = phpReq.getDocument().getLength() - 1;
            }
            if (phpReq.getDocument().getChar(offset) == ')') {
                --offset;
            }
            if ((open = (scanner = PHPHeuristicScanner.createHeuristicScanner(phpReq.getDocument(), offset, true)).findOpeningPeer(offset, -2, '(', ')')) == -1) {
                return false;
            }
            --open;
            if ((open = scanner.findNonWhitespaceBackward(open, -2)) == -1) {
                return false;
            }
            ITextRegion textRegion = scanner.getTextRegion(open);
            if (textRegion == null) {
                return false;
            }
            if (!textRegion.getType().equals("PHP_LABEL")) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            do {
                this.callNameOffset = this.getCompanion().getPHPScriptRegion().getStart() + textRegion.getStart();
                sb.insert(0, phpReq.getDocument().get(this.callNameOffset, textRegion.getLength()));
                open = scanner.findNonWhitespaceBackward(scanner.getPosition() - textRegion.getLength(), -2);
                if (open != -1) continue;
                return false;
            } while ((textRegion = scanner.getTextRegion(open)).getType() == "PHP_LABEL" || textRegion.getType() == "PHP_NS_SEPARATOR" || textRegion.getType() == "PHP_NAMESPACE");
            this.callName = sb.toString();
            if (open == -1) {
                return false;
            }
            if (textRegion.getType() == "PHP_FUNCTION") {
                return false;
            }
            if (textRegion.getType().equals("PHP_OBJECT_OPERATOR") || textRegion.getType().equals("PHP_PAAMAYIM_NEKUDOTAYIM")) {
                this.isMethod = true;
                return true;
            }
            if (textRegion.getType() == "PHP_ATTRIBUTE" || textRegion.getType() == "PHP_NEW") {
                this.isConstructor = true;
                return true;
            }
            if (this.getCompanion().getScope().getType() == ICompletionScope.Type.HEAD && this.getCompanion().getScope().getParent().getType() == ICompletionScope.Type.ATTRIBUTE) {
                this.isConstructor = true;
                return true;
            }
            if (this.callName.charAt(0) == '\\') return true;
            String alias = this.callName;
            int nsPos = this.callName.indexOf(92);
            if (nsPos != -1) {
                alias = this.callName.substring(0, nsPos);
            }
            if (alias.equals("namespace")) {
                this.callName = String.valueOf(this.getCompanion().getCurrentNamespace()) + this.callName.substring(nsPos);
                return true;
            }
            String ns = this.getCompanion().isGlobalNamespace() ? "" : this.getCompanion().getCurrentNamespace();
            alias = PHPModelUtils.getRealName(ns, alias, sourceModule, offset, alias);
            if (nsPos != -1) {
                this.callName = String.valueOf(alias) + this.callName.substring(nsPos);
                return true;
            }
            this.callName = alias;
            return true;
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
            return false;
        }
    }

    public IMethod[] getMethod() {
        if (this.method == null) {
            try {
                this.method = this.resolveMethod();
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
                this.method = new IMethod[0];
            }
        }
        return this.method;
    }

    private IMethod[] resolveMethod() throws ModelException {
        if (this.isMethod) {
            return this.resolveObjectCall();
        }
        if (this.isConstructor) {
            return this.resolveConstructor();
        }
        return this.resolveFunction();
    }

    private IMethod[] resolveObjectCall() throws ModelException {
        TextSequence statement = PHPTextSequenceUtilities.getStatement(this.callNameOffset, this.getCompanion().getStructuredDocumentRegion(), true);
        IType[] type = CodeAssistUtils.getTypesFor(this.getCompanion().getSourceModule(), statement, statement.length(), this.callNameOffset);
        return PHPModelUtils.getTypesMethod(type, this.callName, true);
    }

    private IMethod[] resolveConstructor() throws ModelException {
        IType[] types = PHPModelUtils.getTypes(this.callName, this.getCompanion().getSourceModule(), this.callNameOffset, null);
        IMethod[] list = PHPModelUtils.getTypesMethod(types, "__construct", true);
        if (list.length == 0) {
            list = PHPModelUtils.getTypesMethod(types, PHPModelUtils.extractElementName(this.callName), true);
        }
        return list;
    }

    private IMethod[] resolveFunction() throws ModelException {
        boolean isGlobal = this.callName.charAt(0) == '\\';
        String testName = isGlobal ? this.callName.substring(1) : this.callName;
        String namespaceName = PHPModelUtils.extractNameSpaceName(testName);
        String elementName = PHPModelUtils.extractElementName(testName);
        IMethod[] list = null;
        if (namespaceName != null) {
            list = PHPModelUtils.getNamespaceFunction(namespaceName, elementName, true, this.getCompanion().getSourceModule(), null);
            if (isGlobal || list.length > 0) {
                return list;
            }
        } else if (!isGlobal && this.getCompanion().getCurrentNamespace() != null && (list = PHPModelUtils.getNamespaceFunction(this.getCompanion().getCurrentNamespace(), elementName, true, this.getCompanion().getSourceModule(), null)).length > 0) {
            return list;
        }
        return PHPModelUtils.getFunctions(elementName, this.getCompanion().getSourceModule(), this.callNameOffset, null);
    }

    public boolean isFunction() {
        return !this.isConstructor && !this.isMethod;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isMethod() {
        return this.isMethod;
    }
}

