/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.SeriesModel;
import org.eclipse.tracecompass.tmf.core.model.TmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;

public final class TmfXyResponseFactory {
    private TmfXyResponseFactory() {
    }

    public static TmfModelResponse<ITmfXyModel> create(String title, long[] xValues, Collection<IYModel> yModels, boolean isComplete) {
        List series = Lists.transform(new ArrayList<IYModel>(yModels), model -> {
            SeriesModel.SeriesModelBuilder builder = new SeriesModel.SeriesModelBuilder(model.getId(), model.getName(), xValues, model.getData());
            TmfXYAxisDescription yAxis = model.getYAxisDescription();
            if (yAxis != null) {
                builder.yAxisDescription(yAxis);
            }
            return builder.build();
        });
        TmfXyModel model2 = new TmfXyModel(title, series);
        if (isComplete) {
            return new TmfModelResponse<ITmfXyModel>(model2, ITmfResponse.Status.COMPLETED, Objects.requireNonNull(CommonStatusMessage.COMPLETED));
        }
        return new TmfModelResponse<ITmfXyModel>(model2, ITmfResponse.Status.RUNNING, Objects.requireNonNull(CommonStatusMessage.RUNNING));
    }

    public static TmfModelResponse<ITmfXyModel> create(String title, List<ISeriesModel> yModels, boolean isComplete) {
        TmfXyModel model = new TmfXyModel(title, yModels);
        if (isComplete) {
            return new TmfModelResponse<ITmfXyModel>(model, ITmfResponse.Status.COMPLETED, Objects.requireNonNull(CommonStatusMessage.COMPLETED));
        }
        return new TmfModelResponse<ITmfXyModel>(model, ITmfResponse.Status.RUNNING, Objects.requireNonNull(CommonStatusMessage.RUNNING));
    }

    public static TmfModelResponse<ITmfXyModel> createFailedResponse(String message) {
        return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, message);
    }

    public static TmfModelResponse<ITmfXyModel> createCancelledResponse(String message) {
        return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, message);
    }

    public static TmfModelResponse<ITmfXyModel> createEmptyResponse(String message) {
        TmfXyModel model = new TmfXyModel("", Collections.emptyList());
        return new TmfModelResponse<ITmfXyModel>(model, ITmfResponse.Status.COMPLETED, message);
    }
}

