/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statistics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;

public class TmfStateStatistics
implements ITmfStatistics {
    private final ITmfStateSystem fTotalsStats;
    private final ITmfStateSystem fTypesStats;
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(TmfStateStatistics.class);

    public TmfStateStatistics(@NonNull ITmfStateSystem totals, @NonNull ITmfStateSystem eventTypes) {
        this.fTotalsStats = totals;
        this.fTypesStats = eventTypes;
    }

    public ITmfStateSystem getTotalsSS() {
        return this.fTotalsStats;
    }

    public ITmfStateSystem getEventTypesSS() {
        return this.fTypesStats;
    }

    @Override
    public void dispose() {
        this.fTotalsStats.dispose();
        this.fTypesStats.dispose();
    }

    @Override
    public List<@NonNull Long> histogramQuery(long[] timeRequested) {
        ArrayList<@NonNull Long> list = new ArrayList<Long>();
        if (this.fTotalsStats.isCancelled()) {
            return list;
        }
        int quark = this.fTotalsStats.optQuarkAbsolute(new String[]{"total"});
        if (quark == -2) {
            return Collections.emptyList();
        }
        ArrayList<@NonNull Long> times = new ArrayList<Long>();
        int i = 0;
        while (i < timeRequested.length) {
            if (timeRequested[i] < this.fTotalsStats.getStartTime()) {
                list.add(0L);
            } else {
                if (!list.isEmpty()) {
                    times.add(this.fTotalsStats.getStartTime());
                    list.remove(list.size() - 1);
                }
                times.add(timeRequested[i]);
            }
            if (timeRequested[i] > this.fTotalsStats.getCurrentEndTime()) {
                times.add(this.fTotalsStats.getCurrentEndTime());
                break;
            }
            ++i;
        }
        Throwable throwable = null;
        Object var6_8 = null;
        try (TraceCompassLogUtils.FlowScopeLog log = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "StateStatistics:histogramQuery", new Object[0]).build();){
            this.addHistogramValuesFromQuery2d(quark, times, list);
            int i2 = list.size();
            while (i2 < timeRequested.length) {
                list.add(0L);
                ++i2;
            }
            return list;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<@NonNull Long> addHistogramValuesFromQuery2d(int quark, List<@NonNull Long> times, List<@NonNull Long> results) {
        try {
            @NonNull Iterable intervals = this.fTotalsStats.query2D(Collections.singletonList(quark), times);
            @NonNull ArrayList sortedIntervals = Lists.newArrayList((Iterable)intervals);
            if (sortedIntervals.isEmpty()) {
                return results;
            }
            sortedIntervals.sort(Comparator.comparingLong(ITmfStateInterval::getStartTime));
            long previousTotal = this.fTotalsStats.getStartTime() != ((ITmfStateInterval)sortedIntervals.get(0)).getStartTime() ? ((ITmfStateInterval)sortedIntervals.get(0)).getValueLong() : 0L;
            int j = 0;
            int i = 0;
            block2: while (true) {
                if (i >= times.size()) {
                    return results;
                }
                while (true) {
                    if (j >= sortedIntervals.size() - 1 || ((ITmfStateInterval)sortedIntervals.get(j)).getEndTime() >= times.get(i)) {
                        long count = ((ITmfStateInterval)sortedIntervals.get(j)).getValueLong() - previousTotal;
                        results.add(count);
                        previousTotal = ((ITmfStateInterval)sortedIntervals.get(j)).getValueLong();
                        ++i;
                        continue block2;
                    }
                    ++j;
                }
                break;
            }
        }
        catch (StateSystemDisposedException e) {
            return results;
        }
    }

    @Override
    public long getEventsTotal() {
        long endTime = this.fTotalsStats.getCurrentEndTime();
        int quark = this.fTotalsStats.optQuarkAbsolute(new String[]{"total"});
        if (quark == -2) {
            return 0L;
        }
        try {
            return TmfStateStatistics.extractCount(this.fTotalsStats.querySingleState(endTime, quark).getValue());
        }
        catch (StateSystemDisposedException e) {
            return 0L;
        }
    }

    @Override
    public Map<@NonNull String, @NonNull Long> getEventTypesTotal() {
        int quark = this.fTypesStats.optQuarkAbsolute(new String[]{"event_types"});
        if (quark == -2) {
            return Collections.emptyMap();
        }
        List quarks = this.fTypesStats.getSubAttributes(quark, false);
        long endTime = this.fTypesStats.getCurrentEndTime();
        HashMap<@NonNull String, @NonNull Long> map = new HashMap<String, Long>();
        try {
            List endState = this.fTypesStats.queryFullState(endTime);
            Iterator iterator = quarks.iterator();
            while (iterator.hasNext()) {
                int typeQuark = (Integer)iterator.next();
                String curEventName = this.fTypesStats.getAttributeName(typeQuark);
                long eventCount = TmfStateStatistics.extractCount(((ITmfStateInterval)endState.get(typeQuark)).getValue());
                map.put(curEventName, eventCount);
            }
            return map;
        }
        catch (StateSystemDisposedException e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public long getEventsInRange(long start, long end) {
        long startCount = start == this.fTotalsStats.getStartTime() ? 0L : this.getEventCountAt(start - 1L);
        long endCount = this.getEventCountAt(end);
        return endCount - startCount;
    }

    @Override
    public Map<String, Long> getEventTypesInRange(long start, long end) {
        long startTime = Long.max(start, this.fTypesStats.getStartTime());
        long endTime = Long.min(end, this.fTypesStats.getCurrentEndTime());
        if (endTime < startTime) {
            return Collections.emptyMap();
        }
        int quark = this.fTypesStats.optQuarkAbsolute(new String[]{"event_types"});
        if (quark == -2) {
            return Collections.emptyMap();
        }
        List quarks = this.fTypesStats.getSubAttributes(quark, false);
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            List endState = this.fTypesStats.queryFullState(endTime);
            if (startTime == this.fTypesStats.getStartTime()) {
                Iterator iterator = quarks.iterator();
                while (iterator.hasNext()) {
                    int typeQuark = (Integer)iterator.next();
                    String curEventName = this.fTypesStats.getAttributeName(typeQuark);
                    Object eventCount = ((ITmfStateInterval)endState.get(typeQuark)).getValue();
                    map.put(curEventName, TmfStateStatistics.extractCount(eventCount));
                }
            } else {
                List startState = this.fTypesStats.queryFullState(startTime - 1L);
                Iterator iterator = quarks.iterator();
                while (iterator.hasNext()) {
                    int typeQuark = (Integer)iterator.next();
                    String curEventName = this.fTypesStats.getAttributeName(typeQuark);
                    Object countAtStart = ((ITmfStateInterval)startState.get(typeQuark)).getValue();
                    Object countAtEnd = ((ITmfStateInterval)endState.get(typeQuark)).getValue();
                    long eventCount = TmfStateStatistics.extractCount(countAtEnd) - TmfStateStatistics.extractCount(countAtStart);
                    map.put(curEventName, eventCount);
                }
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return map;
    }

    private long getEventCountAt(long timestamp) {
        long ts = Long.max(this.fTotalsStats.getStartTime(), timestamp);
        ts = Long.min(ts, this.fTotalsStats.getCurrentEndTime());
        int quark = this.fTotalsStats.optQuarkAbsolute(new String[]{"total"});
        if (quark == -2) {
            return 0L;
        }
        try {
            return TmfStateStatistics.extractCount(this.fTotalsStats.querySingleState(ts, quark).getValue());
        }
        catch (StateSystemDisposedException e) {
            return 0L;
        }
    }

    private static long extractCount(@Nullable Object state) {
        if (state instanceof Number) {
            return ((Number)state).longValue();
        }
        return 0L;
    }

    public static class Attributes {
        public static final String TOTAL = "total";
        public static final String EVENT_TYPES = "event_types";
        public static final String LOST_EVENTS = "lost_events";
    }
}

