/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Path Expression Constraint</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getEdgeTypes <em>Edge Types</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getSourceType <em>Source Type</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getSrc <em>Src</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getDst <em>Dst</em>}</li>
 * </ul>
 *
 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getPathExpressionConstraint()
 * @model
 * @generated
 */
public interface PathExpressionConstraint extends Constraint, CallableRelation
{
	/**
	 * Returns the value of the '<em><b>Edge Types</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.viatra.query.patternlanguage.emf.vql.ReferenceType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * @since 2.0
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Edge Types</em>' containment reference list.
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getPathExpressionConstraint_EdgeTypes()
	 * @model containment="true"
	 * @generated
	 */
	EList<ReferenceType> getEdgeTypes();

	/**
	 * Returns the value of the '<em><b>Source Type</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * @since 2.0
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Source Type</em>' containment reference.
	 * @see #setSourceType(ClassType)
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getPathExpressionConstraint_SourceType()
	 * @model containment="true"
	 * @generated
	 */
	ClassType getSourceType();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getSourceType <em>Source Type</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source Type</em>' containment reference.
	 * @see #getSourceType()
	 * @since 2.0
	 * @generated
	 */
	void setSourceType(ClassType value);

	/**
	 * Returns the value of the '<em><b>Src</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * @since 2.0
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Src</em>' containment reference.
	 * @see #setSrc(VariableReference)
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getPathExpressionConstraint_Src()
	 * @model containment="true"
	 * @generated
	 */
	VariableReference getSrc();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getSrc <em>Src</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Src</em>' containment reference.
	 * @see #getSrc()
	 * @since 2.0
	 * @generated
	 */
	void setSrc(VariableReference value);

	/**
	 * Returns the value of the '<em><b>Dst</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * @since 2.0
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Dst</em>' containment reference.
	 * @see #setDst(ValueReference)
	 * @see org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage#getPathExpressionConstraint_Dst()
	 * @model containment="true"
	 * @generated
	 */
	ValueReference getDst();

	/**
	 * Sets the value of the '{@link org.eclipse.viatra.query.patternlanguage.emf.vql.PathExpressionConstraint#getDst <em>Dst</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Dst</em>' containment reference.
	 * @see #getDst()
	 * @since 2.0
	 * @generated
	 */
	void setDst(ValueReference value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	String toString();

} // PathExpressionConstraint
