/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.multi;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.wb.core.editor.IEditorPage;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.multi.DefaultMultiMode;
import org.eclipse.wb.internal.core.editor.multi.DesignerEditor;

final class MultiPagesMode
extends DefaultMultiMode {
    public MultiPagesMode(DesignerEditor editor) {
        super(editor);
    }

    @Override
    void setFocus() {
        int selectionIndex = this.m_folder.getSelectionIndex();
        if (this.isSourcePageFirst() && selectionIndex == 0 || !this.isSourcePageFirst() && selectionIndex == 1) {
            this.m_sourcePage.setFocus();
        } else {
            this.m_designPage.setFocus();
        }
    }

    @Override
    public void showSource() {
        if (this.m_activePage != this.m_sourcePage) {
            this.showPage(this.m_sourcePage);
        }
    }

    @Override
    public void showDesign() {
        if (this.m_activePage != this.m_designPage) {
            this.showPage(this.m_designPage);
        }
    }

    @Override
    public void switchSourceDesign() {
        this.showPage(this.m_activePage == this.m_sourcePage ? this.m_designPage : this.m_sourcePage);
    }

    @Override
    public void onSetInput() {
        if (this.m_activePage == this.m_designPage) {
            this.m_designPage.handleActiveState(false);
            this.m_designPage.handleActiveState(true);
        }
    }

    @Override
    void create(Composite parent) {
        super.create(parent);
        this.createTabFolder(parent);
        if (this.isSourcePageFirst()) {
            this.createTab(this.m_sourcePage);
            this.createTab(this.m_designPage);
        } else {
            this.createTab(this.m_designPage);
            this.createTab(this.m_sourcePage);
        }
        for (IEditorPage page : this.m_additionalPages) {
            this.createTab(page);
        }
        this.showSource();
    }

    @Override
    void editorActivatedFirstTime() {
        if (!this.isSourcePageFirst()) {
            this.showDesign();
        }
    }

    @Override
    protected void handleShowPage() {
        super.handleShowPage();
        if (this.m_activePage == this.m_designPage) {
            this.maximizeOnActivation();
        }
    }

    private void maximizeOnActivation() {
        if (DesignerPlugin.getPreferences().getBoolean("editor.maximizeOnDesignPage")) {
            DesignerPlugin.getStandardDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = MultiPagesMode.this.m_editor.getSite().getPage();
                    if (!page.isPageZoomed()) {
                        page.toggleZoom(page.getActivePartReference());
                    }
                }
            });
        }
    }

    private boolean isSourcePageFirst() {
        int layout = DesignerPlugin.getPreferences().getInt("editor.layout");
        return layout == 0;
    }
}

