/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 
 *******************************************************************************/
package org.eclipse.dltk.ast.statements;

/**
 * Statement type constants.
 */
public interface StatementConstants {
	public final static int S_WHILE = 2000;

	public final static int S_FOR = 2001;

	public final static int S_TRY = 2002;

	public final static int S_THROW = 2003;

	public final static int S_PRINT = 2004;

	public final static int S_IF = 2005;

	public final static int S_CONTINUE = 2006;

	public final static int S_BREAK = 2007;

	public final static int S_BLOCK = 2008;

	public final static int S_DOWHILE = 2009;

	public final static int S_SWITCH = 2010;

	public final static int S_RETURN = 2011;

	public final static int S_CASE = 2012;

	public final static int S_EMPTY = 2013;

	public final static int S_FOREACH = 2014;

	public static final int S_TRY_CATCH = 2015;

	public static final int S_TRY_FINALLY = 2016;
	
	public static final int S_UNTIL = 2017;
}
