/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.annotations.core.utils;

import java.util.ArrayList;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static boolean isString(String returnType) {
        int signatureKind = Signature.getTypeSignatureKind((String)returnType);
        if (signatureKind == 1) {
            if (returnType.charAt(0) == 'L') {
                return Signature.toString((String)returnType).equals(String.class.getCanonicalName());
            }
            if (returnType.charAt(0) == 'Q') {
                return Signature.toString((String)returnType).equals(String.class.getSimpleName());
            }
        }
        return false;
    }

    public static boolean isClass(String returnType) {
        int signatureKind = Signature.getTypeSignatureKind((String)returnType);
        if (signatureKind == 1) {
            if (returnType.charAt(0) == 'L') {
                returnType = Signature.getTypeErasure((String)returnType);
                return Signature.toString((String)returnType).equals(Class.class.getCanonicalName());
            }
            if (returnType.charAt(0) == 'Q') {
                returnType = Signature.getTypeErasure((String)returnType);
                return Signature.toString((String)returnType).equals(Class.class.getSimpleName());
            }
        }
        return false;
    }

    public static boolean isBoolean(String returnType) {
        int signatureKind = Signature.getTypeSignatureKind((String)returnType);
        if (signatureKind == 1) {
            if (returnType.charAt(0) == 'L') {
                return Signature.toString((String)returnType).equals(Boolean.class.getCanonicalName());
            }
            if (returnType.charAt(0) == 'Q') {
                return Signature.toString((String)returnType).equals(Boolean.class.getSimpleName());
            }
        }
        if (signatureKind == 2) {
            return returnType.charAt(0) == 'Z';
        }
        return false;
    }

    public static boolean isArray(String returnType) {
        return Signature.getTypeSignatureKind((String)returnType) == 4;
    }

    public static boolean isPrimitive(String returnType) {
        return Signature.getTypeSignatureKind((String)returnType) == 2;
    }

    public static boolean isEnum(IMethod method) throws JavaModelException {
        return SignatureUtils.getEnumReturnType(method) != null;
    }

    public static IType getEnumReturnType(IMethod method) throws JavaModelException {
        IType type;
        String returnType = method.getReturnType();
        int signatureKind = Signature.getTypeSignatureKind((String)returnType);
        if (signatureKind == 1 && returnType.charAt(0) == 'L' && (type = method.getJavaProject().findType(Signature.toString((String)returnType))) != null && type.isEnum()) {
            return type;
        }
        return null;
    }

    public static String[] getEnumConstantsNames(IType enumType) throws JavaModelException {
        if (enumType.isEnum()) {
            IField[] fields;
            ArrayList<String> enumConstants = new ArrayList<String>();
            IField[] iFieldArray = fields = SignatureUtils.getEnumConstants(enumType);
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                enumConstants.add(field.getElementName());
                ++n2;
            }
            return enumConstants.toArray(new String[enumConstants.size()]);
        }
        return new String[0];
    }

    public static IField[] getEnumConstants(IType enumType) throws JavaModelException {
        if (enumType.isEnum()) {
            IField[] fields;
            ArrayList<IField> enumConstants = new ArrayList<IField>();
            IField[] iFieldArray = fields = enumType.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (field.isEnumConstant()) {
                    enumConstants.add(field);
                }
                ++n2;
            }
            return enumConstants.toArray(new IField[enumConstants.size()]);
        }
        return new IField[0];
    }
}

