/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.widgets;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.command.internal.env.core.CommandManager;
import org.eclipse.wst.command.internal.env.core.data.DataFlowManager;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragmentEngine;
import org.eclipse.wst.command.internal.env.core.fragment.FragmentListener;
import org.eclipse.wst.command.internal.env.eclipse.BaseStatusHandler;
import org.eclipse.wst.command.internal.env.eclipse.EclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;

public class SimpleCommandEngineManager {
    protected CommandFragmentEngine engine_;
    protected DataFlowManager dataManager_;
    protected EclipseEnvironment environment_;
    private boolean foundStop_;
    private boolean doNotRunInTransaction_;

    public SimpleCommandEngineManager(EclipseEnvironment environment, DataFlowManager dataManager) {
        this.environment_ = environment;
        this.dataManager_ = dataManager;
    }

    public void setRootFragment(CommandFragment root) {
        this.engine_ = new CommandFragmentEngine(root, this.dataManager_, (IEnvironment)this.environment_);
        this.environment_.setCommandManager((CommandManager)this.engine_);
        this.engine_.setPeekFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return SimpleCommandEngineManager.this.peekFragment(fragment);
            }
        });
        this.engine_.setNextFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return SimpleCommandEngineManager.this.nextFragment(fragment);
            }
        });
        this.engine_.setAfterExecuteFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return SimpleCommandEngineManager.this.afterExecuteNextFragment(fragment);
            }
        });
        this.engine_.setUndoFragmentListener(new FragmentListener(){

            public boolean notify(CommandFragment fragment) {
                return SimpleCommandEngineManager.this.undoFragment(fragment);
            }
        });
    }

    protected boolean afterExecuteNextFragment(CommandFragment fragment) {
        boolean continueExecute = true;
        BaseStatusHandler statusHandler = (BaseStatusHandler)this.environment_.getStatusHandler();
        IStatus commandStatus = this.engine_.getLastStatus();
        IStatus handlerStatus = statusHandler.getStatus();
        if (commandStatus.getSeverity() == 4 && handlerStatus.getSeverity() != 4) {
            String errorMessage = commandStatus.getMessage();
            if (errorMessage != null && errorMessage.length() > 0) {
                statusHandler.reportError(commandStatus);
            }
        } else if (commandStatus.getSeverity() != 4 && handlerStatus.getSeverity() == 4) {
            continueExecute = false;
        }
        return continueExecute;
    }

    protected boolean peekFragment(CommandFragment fragment) {
        return true;
    }

    protected boolean nextFragment(CommandFragment fragment) {
        if (fragment.doNotRunInTransaction() != this.doNotRunInTransaction_) {
            this.doNotRunInTransaction_ = fragment.doNotRunInTransaction();
            this.foundStop_ = false;
        }
        return this.foundStop_;
    }

    protected boolean undoFragment(CommandFragment fragment) {
        return true;
    }

    public boolean runUndoToNextStop(IRunnableContext context) {
        final boolean[] result = new boolean[]{true};
        IRunnableWithProgress undoOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                result[0] = SimpleCommandEngineManager.this.engine_.undoToLastStop(monitor);
            }
        };
        try {
            if (context == null) {
                undoOperation.run(null);
            } else {
                context.run(false, false, undoOperation);
            }
        }
        catch (Exception exception) {}
        return result[0];
    }

    public IStatus runForwardToNextStop(IRunnableContext context) {
        IRunnableWithProgress operation = null;
        this.doNotRunInTransaction_ = false;
        do {
            this.foundStop_ = true;
            operation = this.doNotRunInTransaction_ ? this.getNoTransactionOperation() : this.getTransactionOperation();
            try {
                if (context == null) {
                    operation.run(null);
                    continue;
                }
                context.run(false, false, operation);
            }
            catch (InterruptedException exc) {
                exc.printStackTrace();
            }
            catch (InvocationTargetException exc) {
                exc.printStackTrace();
            }
        } while (!this.foundStop_);
        return this.engine_.getLastStatus();
    }

    private IRunnableWithProgress getTransactionOperation() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                SimpleCommandEngineManager.this.environment_.getLog().log(1, "command", 5002, (Object)this, "getTransactionOperation", (Object)"Start of transaction");
                BaseStatusHandler statusHandler = (BaseStatusHandler)SimpleCommandEngineManager.this.environment_.getStatusHandler();
                statusHandler.resetStatus();
                SimpleCommandEngineManager.this.engine_.moveForwardToNextStop(monitor);
                SimpleCommandEngineManager.this.environment_.getLog().log(1, "command", 5003, (Object)this, "getTransactionOperation", (Object)"End of transaction");
            }
        };
        return operation;
    }

    private IRunnableWithProgress getNoTransactionOperation() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                SimpleCommandEngineManager.this.environment_.getLog().log(1, "command", 5085, (Object)this, "getNoTransactionOperation", (Object)"Start of NON transaction");
                BaseStatusHandler statusHandler = (BaseStatusHandler)SimpleCommandEngineManager.this.environment_.getStatusHandler();
                statusHandler.resetStatus();
                SimpleCommandEngineManager.this.engine_.moveForwardToNextStop(monitor);
                SimpleCommandEngineManager.this.environment_.getLog().log(1, "command", 5086, (Object)this, "getNoTransactionOperation", (Object)"End of NON transaction");
            }
        };
        return operation;
    }
}

