/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.jsdi.StackFrame;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.internal.crossfire.Tracing;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFMirror;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFStackFrame;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.Messages;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFRequestPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFResponsePacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;

public class CFThreadReference
extends CFMirror
implements ThreadReference {
    static final int RUNNING = 0;
    static final int SUSPENDED = 1;
    static final int TERMINATED = 2;
    static final int EVENT_RESUME = 3;
    private String id = null;
    private String url = null;
    private boolean current = false;
    private int state = 0;
    private ArrayList frames = null;
    private int stepkind = -1;

    public CFThreadReference(VirtualMachine vm, String id, String url) {
        super(vm);
        this.id = id;
        this.url = url;
    }

    public CFThreadReference(VirtualMachine vm, Map json) {
        super(vm);
        this.id = (String)json.get("contextId");
        this.url = (String)json.get("url");
        Boolean bool = (Boolean)json.get("current");
        if (bool != null) {
            this.current = bool;
        }
    }

    public int frameCount() {
        return this.frames == null ? 0 : this.frames.size();
    }

    public synchronized StackFrame frame(int index) {
        if (this.frames == null || index < 0 || index > this.frames.size()) {
            return null;
        }
        return (StackFrame)this.frames.get(index);
    }

    public synchronized List frames() {
        if (this.frames == null) {
            CFRequestPacket request = new CFRequestPacket("backtrace", this.id);
            request.setArgument("fromFrame", 0);
            request.setArgument("includeScopes", Boolean.TRUE);
            CFResponsePacket response = this.crossfire().sendRequest(request);
            if (response.isSuccess()) {
                this.frames = new ArrayList();
                List frms = (List)response.getBody().get("frames");
                if (frms != null) {
                    Map fmap = null;
                    int i = 0;
                    while (i < frms.size()) {
                        fmap = (Map)frms.get(i);
                        if (fmap.containsKey("url")) {
                            this.frames.add(new CFStackFrame(this.virtualMachine(), this, fmap));
                        } else if (TRACE) {
                            Tracing.writeString("STACKFRAME [got bogus stackframe infos]: " + fmap.values().toString());
                        }
                        ++i;
                    }
                }
            } else {
                if (TRACE) {
                    Tracing.writeString("STACKFRAME [backtrace request failed]: " + JSON.serialize(request));
                }
                if (this.frames != null) {
                    this.frames.clear();
                }
                return Collections.EMPTY_LIST;
            }
        }
        return this.frames;
    }

    public void interrupt() {
        try {
            this.resume();
        }
        finally {
            this.state = 2;
        }
    }

    public void eventResume() {
        this.state = 3;
    }

    public void resume() {
        if (this.isSuspended()) {
            try {
                if (this.state != 3) {
                    CFResponsePacket response;
                    CFRequestPacket request = new CFRequestPacket("continue", this.id);
                    String step = this.resolveStepKind();
                    if (step != null) {
                        request.setArgument("stepAction", step);
                    }
                    if ((response = this.crossfire().sendRequest(request)).isSuccess()) {
                        this.state = 0;
                    } else if (TRACE) {
                        Tracing.writeString("THREAD [failed continue request] " + JSON.serialize(request));
                    }
                }
            }
            finally {
                this.clearFrames();
                this.state = 0;
            }
        }
    }

    public void suspend() {
        if (this.isRunning()) {
            CFRequestPacket request = new CFRequestPacket("suspend", this.id);
            try {
                CFResponsePacket response = this.crossfire().sendRequest(request);
                if (response.isSuccess()) {
                    this.state = 1;
                } else if (TRACE) {
                    Tracing.writeString("THREAD [failed suspend request]: " + JSON.serialize(request));
                }
            }
            finally {
                this.clearFrames();
            }
        }
    }

    void clearFrames() {
        if (this.frames != null) {
            this.frames.clear();
            this.frames = null;
        }
    }

    public int status() {
        return 1;
    }

    public boolean isAtBreakpoint() {
        return false;
    }

    public boolean isSuspended() {
        return this.state == 1;
    }

    public boolean isRunning() {
        return this.state == 0;
    }

    public String name() {
        return NLS.bind((String)Messages.thread_name, (Object[])new Object[]{this.id, this.url});
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ThreadReference: [contextId - ").append(this.id).append("] [url - ").append(this.url).append("]");
        return buffer.toString();
    }

    public String id() {
        return this.id;
    }

    public String url() {
        return this.url;
    }

    public void markSuspended(boolean suspended) {
        this.clearFrames();
        this.state = suspended ? 1 : 0;
    }

    public void setStep(int step) {
        this.stepkind = step;
    }

    String resolveStepKind() {
        if (this.stepkind != -1) {
            switch (this.stepkind) {
                case 1: {
                    return "in";
                }
                case 3: {
                    return "out";
                }
                case 2: {
                    return "next";
                }
            }
        }
        return null;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean current) {
        this.current = current;
    }
}

