/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.breadcrumb;

import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.IBreadcrumbDropDownSite;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;

public abstract class TreeViewerDropDown {
    private static long MOUSE_MOVE_SCROLL_DELAY = 500L;
    private IBreadcrumbDropDownSite fDropDownSite;
    private TreeViewer fDropDownViewer;

    public Control createDropDown(Composite composite, IBreadcrumbDropDownSite site, TreePath path) {
        this.fDropDownSite = site;
        this.fDropDownViewer = this.createTreeViewer(composite, 772, path);
        this.fDropDownViewer.addOpenListener(event -> {
            if (DebugUIPlugin.DEBUG_TREE_VIEWER_DROPDOWN) {
                DebugUIPlugin.trace("BreadcrumbItemDropDown.showMenu()$treeViewer>open");
            }
            this.openElement(event.getSelection());
        });
        final Tree tree = this.fDropDownViewer.getTree();
        tree.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (DebugUIPlugin.DEBUG_TREE_VIEWER_DROPDOWN) {
                    DebugUIPlugin.trace("BreadcrumbItemDropDown.showMenu()$treeViewer>mouseUp");
                }
                if (e.button != 1) {
                    return;
                }
                if ((OpenStrategy.getOpenMethod() & 1) != 0) {
                    return;
                }
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item == null) {
                    return;
                }
                LinkedList<Object> pathElements = new LinkedList<Object>();
                while (item != null) {
                    Object data = item.getData();
                    if (data == null) {
                        return;
                    }
                    pathElements.add(0, data);
                    item = item.getParentItem();
                }
                TreeViewerDropDown.this.openElement((ISelection)new TreeSelection(new TreePath(pathElements.toArray())));
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;
            long fLastScrollTime = 0L;

            public void mouseMove(MouseEvent e) {
                if (tree.equals(e.getSource())) {
                    TreeItem currentItem;
                    if (this.fLastItem == null ^ (currentItem = tree.getItem(new Point(e.x, e.y))) == null) {
                        tree.setCursor(currentItem == null ? null : tree.getDisplay().getSystemCursor(21));
                    }
                    if (currentItem != null) {
                        if (!currentItem.equals(this.fLastItem)) {
                            this.fLastItem = currentItem;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        } else if (System.currentTimeMillis() > this.fLastScrollTime + MOUSE_MOVE_SCROLL_DELAY) {
                            if (e.y < tree.getItemHeight() / 4) {
                                if (currentItem.getParentItem() == null) {
                                    int index = tree.indexOf(currentItem);
                                    if (index < 1) {
                                        return;
                                    }
                                    this.fLastItem = tree.getItem(index - 1);
                                    tree.setSelection(new TreeItem[]{this.fLastItem});
                                } else {
                                    Point p = tree.toDisplay(e.x, e.y);
                                    Item item = TreeViewerDropDown.this.fDropDownViewer.scrollUp(p.x, p.y);
                                    this.fLastScrollTime = System.currentTimeMillis();
                                    if (item instanceof TreeItem) {
                                        this.fLastItem = (TreeItem)item;
                                        tree.setSelection(new TreeItem[]{this.fLastItem});
                                    }
                                }
                            } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                                if (currentItem.getParentItem() == null) {
                                    int index = tree.indexOf(currentItem);
                                    if (index >= tree.getItemCount() - 1) {
                                        return;
                                    }
                                    this.fLastItem = tree.getItem(index + 1);
                                    tree.setSelection(new TreeItem[]{this.fLastItem});
                                } else {
                                    Point p = tree.toDisplay(e.x, e.y);
                                    Item item = TreeViewerDropDown.this.fDropDownViewer.scrollDown(p.x, p.y);
                                    this.fLastScrollTime = System.currentTimeMillis();
                                    if (item instanceof TreeItem) {
                                        this.fLastItem = (TreeItem)item;
                                        tree.setSelection(new TreeItem[]{this.fLastItem});
                                    }
                                }
                            }
                        }
                    } else {
                        this.fLastItem = null;
                    }
                }
            }
        });
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    if (tree.getItemCount() == 0) {
                        TreeViewerDropDown.this.fDropDownSite.close();
                        return;
                    }
                    TreeItem[] selection = tree.getSelection();
                    if (selection.length != 1) {
                        return;
                    }
                    int selectionIndex = tree.indexOf(selection[0]);
                    if (selectionIndex != 0) {
                        return;
                    }
                    TreeViewerDropDown.this.fDropDownSite.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fDropDownViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                tree.setRedraw(false);
                new UIJob(tree.getDisplay(), ""){
                    {
                        super($anonymous0, $anonymous1);
                        this.setSystem(true);
                    }

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!tree.isDisposed()) {
                            try {
                                (this).TreeViewerDropDown.this.fDropDownSite.updateSize();
                            }
                            finally {
                                tree.setRedraw(true);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        return tree;
    }

    protected abstract TreeViewer createTreeViewer(Composite var1, int var2, TreePath var3);

    protected void openElement(ISelection selection) {
        boolean treeHasFocus;
        if (selection == null || !(selection instanceof ITreeSelection) || selection.isEmpty()) {
            return;
        }
        this.fDropDownSite.notifySelection(selection);
        Tree tree = this.fDropDownViewer.getTree();
        boolean bl = treeHasFocus = !tree.isDisposed() && tree.isFocusControl();
        if (DebugUIPlugin.DEBUG_TREE_VIEWER_DROPDOWN) {
            DebugUIPlugin.trace("    isDisposed: " + tree.isDisposed());
            DebugUIPlugin.trace("    shell hasFocus: " + (!tree.isDisposed() && tree.isFocusControl()));
            DebugUIPlugin.trace("    tree hasFocus: " + treeHasFocus);
        }
        if (tree.isDisposed()) {
            return;
        }
        if (!treeHasFocus) {
            this.fDropDownSite.close();
            return;
        }
        this.toggleExpansionState(((ITreeSelection)selection).getPaths()[0]);
    }

    private void toggleExpansionState(TreePath path) {
        Tree tree = this.fDropDownViewer.getTree();
        if (this.fDropDownViewer.getExpandedState((Object)path)) {
            this.fDropDownViewer.collapseToLevel((Object)path, 1);
        } else {
            tree.setRedraw(false);
            try {
                this.fDropDownViewer.expandToLevel((Object)path, 1);
                this.fDropDownSite.updateSize();
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }
}

