/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.SearchRepository;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.GitHubException;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.Messages;
import org.eclipse.mylyn.internal.github.ui.RepositorySearchWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class RepositoryImportWizard
extends Wizard
implements IImportWizard {
    private final RepositorySearchWizardPage repositorySearchWizardPage = new RepositorySearchWizardPage();

    public RepositoryImportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_WIZBAN_IMPORT_WIZ"));
        this.setWindowTitle(Messages.RepositorySearchWizardPage_Title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.repositorySearchWizardPage);
    }

    private CloneOperation createCloneOperation(SearchRepository repo, RepositoryService service) throws IOException, URISyntaxException {
        Repository fullRepo = service.getRepository((IRepositoryIdProvider)repo);
        URIish uri = new URIish(fullRepo.getCloneUrl());
        String defaultRepoDir = RepositoryUtil.getDefaultRepositoryDir();
        File directory = new File(new File(defaultRepoDir, repo.getOwner()), repo.getName());
        int timeout = GitSettings.getRemoteConnectionTimeout();
        return new CloneOperation(uri, true, null, directory, "refs/heads/master", "origin", timeout);
    }

    public boolean performFinish() {
        final SearchRepository[] repositories = this.repositorySearchWizardPage.getRepositories();
        final String name = MessageFormat.format(Messages.RepositoryImportWizard_CloningRepositories, repositories.length);
        Job job = new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)name, (int)(repositories.length * 3));
                    GitHubClient client = GitHub.configureClient((GitHubClient)new GitHubClient());
                    RepositoryService service = new RepositoryService(client);
                    SearchRepository[] searchRepositoryArray = repositories;
                    int n = repositories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SearchRepository repo = searchRepositoryArray[n2];
                        try {
                            String id = repo.getId();
                            progress.subTask(MessageFormat.format(Messages.RepositoryImportWizard_CreatingOperation, id));
                            CloneOperation op = RepositoryImportWizard.this.createCloneOperation(repo, service);
                            progress.worked(1);
                            monitor.setTaskName(MessageFormat.format(Messages.RepositoryImportWizard_Cloning, id));
                            op.run((IProgressMonitor)progress.newChild(1));
                            monitor.setTaskName(MessageFormat.format(Messages.RepositoryImportWizard_Registering, id));
                            RepositoryUtil.INSTANCE.addConfiguredRepository(op.getGitDir());
                            progress.worked(1);
                        }
                        catch (IOException e) {
                            GitHubUi.logError(GitHubException.wrap((IOException)e));
                        }
                        catch (InterruptedException | InvocationTargetException | URISyntaxException e) {
                            GitHubUi.logError(e);
                        }
                        ++n2;
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        };
        IWorkbenchSiteProgressService progress = (IWorkbenchSiteProgressService)PlatformUI.getWorkbench().getService(IWorkbenchSiteProgressService.class);
        if (progress != null) {
            progress.schedule(job);
        } else {
            job.schedule();
        }
        return true;
    }
}

