/*
 * Copyright (c) 2007-2012, 2015, 2019, 2020 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.net4j.util.event;

/**
 * An entity that a number of {@link IListener listeners} can be registered with and that can fire {@link IEvent events}
 * to these registered listeners.
 * <p>
 * Implementors are encouraged to document the event types that they are able to fire and that their listeners may want
 * to receive and handle.
 * <p>
 * Implementors may want to extend {@link Notifier} instead of implementing this interface directly.
 *
 * @author Eike Stepper
 */
public interface INotifier
{
  /**
   * Adds a listener to this notifier.
   * <p>
   * Depending on the implementation duplicate listeners may lead to duplicate event delivery or not. Implementors are
   * encouraged to prevent events from being delivered more than once to the same listener,
   */
  public void addListener(IListener listener);

  /**
   * Removes a listener from this notifier.
   */
  public void removeListener(IListener listener);

  /**
   * Returns <code>true</code> if one or more listeners are registered with this notifier, <code>false</code> otherwise.
   *
   * @since 3.0
   */
  public boolean hasListeners();

  /**
   * Returns the listeners that are registered with this notifier.
   * <p>
   * Depending on the implementation duplicate listeners may be contained in the returned array.
   *
   * @since 3.0
   */
  public IListener[] getListeners();

  /**
   * @author Eike Stepper
   * @since 3.13
   */
  public interface INotifier2 extends INotifier
  {
    /**
     * Returns <code>true</code> if this notifier contains the listener, <code>false</code> otherwise.
     */
    public boolean hasListener(IListener listener);

    /**
     * Adds a listener to this notifier unless this notifier already {@link #hasListener(IListener) contains} the listener.
     */
    public boolean addUniqueListener(IListener listener);
  }
}
