/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractTopologyManager;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiTopologyManagerImpl
extends AbstractTopologyManager
implements EndpointListener,
EndpointEventListener {
    private static final boolean exportRegisteredSvcs = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.osgitopologymanager.exportRegisteredSvcs", "true"));
    private static final String exportRegisteredSvcsFilter = System.getProperty("org.eclipse.ecf.osgi.services.osgitopologymanager.exportRegisteredSvcsFilter", "(service.exported.interfaces=*)");
    private static final String exportRegisteredSvcsClassname = System.getProperty("org.eclipse.ecf.osgi.services.osgitopologymanager.exportRegisteredSvcsClassname");
    private String ecfLocalEndpointListenerScope;
    private String ecfNonLocalEndpointListenerScope;
    private String osgiLocalEndpointListenerScope;
    private String osgiNonLocalEndpointListenerScope;
    private static final String ONLY_ECF_SCOPE = "(ecf.endpoint.id.ns=*)";
    private static final String NO_ECF_SCOPE = "(!(ecf.endpoint.id.ns=*))";

    OSGiTopologyManagerImpl(BundleContext context) {
        super(context);
        String frameworkUUID = this.getFrameworkUUID();
        StringBuffer ecfLocalScope = new StringBuffer("");
        ecfLocalScope.append("(&(").append("endpoint.framework.uuid").append("=").append(frameworkUUID).append(")");
        ecfLocalScope.append(ONLY_ECF_SCOPE);
        ecfLocalScope.append(")");
        this.ecfLocalEndpointListenerScope = ecfLocalScope.toString();
        StringBuffer ecfNonLocalScope = new StringBuffer("");
        ecfNonLocalScope.append("(&(!(").append("endpoint.framework.uuid").append("=").append(frameworkUUID).append("))");
        ecfNonLocalScope.append(ONLY_ECF_SCOPE);
        ecfNonLocalScope.append(")");
        this.ecfNonLocalEndpointListenerScope = ecfNonLocalScope.toString();
        StringBuffer localScope = new StringBuffer("");
        localScope.append("(&(").append("endpoint.framework.uuid").append("=").append(frameworkUUID).append(")");
        localScope.append(NO_ECF_SCOPE);
        localScope.append(")");
        this.osgiLocalEndpointListenerScope = localScope.toString();
        StringBuffer nonlocalScope = new StringBuffer("");
        nonlocalScope.append("(&(!(").append("endpoint.framework.uuid").append("=").append(frameworkUUID).append("))");
        nonlocalScope.append(NO_ECF_SCOPE);
        nonlocalScope.append(")");
        this.osgiNonLocalEndpointListenerScope = nonlocalScope.toString();
    }

    String[] getScope() {
        return new String[]{this.ecfLocalEndpointListenerScope, this.ecfNonLocalEndpointListenerScope, this.osgiLocalEndpointListenerScope, this.osgiNonLocalEndpointListenerScope};
    }

    protected String getFrameworkUUID() {
        return super.getFrameworkUUID();
    }

    void exportRegisteredServices(String exportRegisteredSvcsClassname, String exportRegisteredSvcsFilter) {
        try {
            final ServiceReference[] existingServiceRefs = this.getContext().getAllServiceReferences(exportRegisteredSvcsClassname, exportRegisteredSvcsFilter);
            if (existingServiceRefs != null && existingServiceRefs.length > 0) {
                new Thread(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < existingServiceRefs.length) {
                            OSGiTopologyManagerImpl.this.handleServiceRegistering(existingServiceRefs[i]);
                            ++i;
                        }
                    }
                }, "BasicTopologyManagerPreRegSrvExporter").start();
            }
        }
        catch (InvalidSyntaxException e) {
            this.logError("exportRegisteredServices", "Could not retrieve existing service references for exportRegisteredSvcsClassname=" + exportRegisteredSvcsClassname + " and exportRegisteredSvcsFilter=" + exportRegisteredSvcsFilter, e);
        }
    }

    public void endpointAdded(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        this.handleEndpointAdded(endpoint, matchedFilter);
    }

    protected void handleEndpointAdded(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.osgiLocalEndpointListenerScope)) {
            this.advertiseEndpointDescription(endpoint);
        } else if (matchedFilter.equals(this.osgiNonLocalEndpointListenerScope)) {
            EndpointDescription ed = this.convertEndpointDescriptionFromOSGiToECF(endpoint);
            if (ed != null) {
                this.handleECFEndpointAdded(ed);
            }
        } else if (matchedFilter.equals(this.ecfNonLocalEndpointListenerScope)) {
            this.handleECFEndpointAdded((EndpointDescription)endpoint);
        } else if (matchedFilter.equals(this.ecfLocalEndpointListenerScope)) {
            this.advertiseEndpointDescription(endpoint);
        }
    }

    private EndpointDescription convertEndpointDescriptionFromOSGiToECF(org.osgi.service.remoteserviceadmin.EndpointDescription ed) {
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.putAll(ed.getProperties());
        String ecfNS = (String)newProps.remove("ecf.osgi.ns");
        if (ecfNS == null) {
            return null;
        }
        newProps.put("ecf.endpoint.id.ns", ecfNS);
        return new EndpointDescription(newProps);
    }

    public void endpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        this.handleEndpointRemoved(endpoint, matchedFilter);
    }

    protected void handleEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.osgiLocalEndpointListenerScope)) {
            this.unadvertiseEndpointDescription(endpoint);
        } else if (matchedFilter.equals(this.osgiNonLocalEndpointListenerScope)) {
            EndpointDescription ed = this.convertEndpointDescriptionFromOSGiToECF(endpoint);
            if (ed != null) {
                this.handleECFEndpointRemoved((org.osgi.service.remoteserviceadmin.EndpointDescription)ed);
            }
        } else if (matchedFilter.equals(this.ecfNonLocalEndpointListenerScope)) {
            this.handleECFEndpointRemoved((org.osgi.service.remoteserviceadmin.EndpointDescription)((EndpointDescription)endpoint));
        } else if (matchedFilter.equals(this.ecfLocalEndpointListenerScope)) {
            this.unadvertiseEndpointDescription(endpoint);
        }
    }

    public void endpointChanged(EndpointEvent event, String matchedFilter) {
        int eventType = event.getType();
        org.osgi.service.remoteserviceadmin.EndpointDescription ed = event.getEndpoint();
        switch (eventType) {
            case 1: {
                this.handleEndpointAdded(ed, matchedFilter);
                break;
            }
            case 2: {
                this.handleEndpointRemoved(ed, matchedFilter);
                break;
            }
            case 4: {
                this.handleEndpointModified(ed, matchedFilter);
                break;
            }
            case 8: {
                this.handleEndpointModifiedEndmatch(ed, matchedFilter);
            }
        }
    }

    protected void handleEndpointModifiedEndmatch(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
    }

    private static Long getOSGiEndpointModifiedValue(Map<String, Object> properties) {
        Object modifiedValue = properties.get("ecf.osgi.endpoint.modified");
        if (modifiedValue != null && modifiedValue instanceof String) {
            return Long.valueOf((String)modifiedValue);
        }
        return null;
    }

    protected void handleEndpointModified(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.osgiLocalEndpointListenerScope)) {
            Map edProperties = endpoint.getProperties();
            Long modified = OSGiTopologyManagerImpl.getOSGiEndpointModifiedValue(edProperties);
            HashMap<String, String> newEdProperties = new HashMap<String, String>();
            newEdProperties.putAll(endpoint.getProperties());
            if (modified != null) {
                newEdProperties.remove("ecf.osgi.endpoint.modified");
                this.handleNonECFEndpointModified(this, new org.osgi.service.remoteserviceadmin.EndpointDescription(newEdProperties));
            } else {
                newEdProperties.put("ecf.osgi.endpoint.modified", String.valueOf(System.currentTimeMillis()));
                this.advertiseModifyEndpointDescription(new org.osgi.service.remoteserviceadmin.EndpointDescription(newEdProperties));
            }
        } else if (matchedFilter.equals(this.osgiNonLocalEndpointListenerScope)) {
            this.handleNonECFEndpointModified(this, endpoint);
        }
    }

    public void activate() {
        if (exportRegisteredSvcs) {
            this.exportRegisteredServices(exportRegisteredSvcsClassname, exportRegisteredSvcsFilter);
        }
    }
}

