/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.mqtt.container;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.provider.comm.ConnectionCreateException;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.jms.container.AbstractJMSClient;
import org.eclipse.ecf.provider.jms.container.JMSContainerConfig;
import org.eclipse.ecf.provider.jms.identity.JMSID;
import org.eclipse.ecf.provider.jms.mqtt.container.AbstractMqttContainerInstantiator;
import org.eclipse.ecf.provider.jms.mqtt.container.MqttJMSClientChannel;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class MqttJMSClientContainer
extends AbstractJMSClient {
    public static final String MQTT_CLIENT_NAME = "ecf.jms.mqtt.client";
    private int qos;
    private MqttConnectOptions options;

    MqttJMSClientContainer(JMSContainerConfig config, MqttConnectOptions options, int qos) {
        super(config);
        this.options = options;
        this.qos = qos;
    }

    protected ISynchAsynchConnection createConnection(ID targetID, Object data) throws ConnectionCreateException {
        return new MqttJMSClientChannel(this.getReceiver(), this.getJMSContainerConfig().getKeepAlive(), this.qos, this.options);
    }

    public void disconnect() {
        super.disconnect();
    }

    public void dispose() {
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Instantiator
    extends AbstractMqttContainerInstantiator {
        private static List<String> exporters = Arrays.asList("ecf.jms.mqtt.manager", "ecf.jms.mqtt.client");
        private static Map<String, List<String>> exporterToImportersMap = new HashMap<String, List<String>>();

        static {
            exporterToImportersMap.put("ecf.jms.mqtt.manager", Arrays.asList(MqttJMSClientContainer.MQTT_CLIENT_NAME));
            exporterToImportersMap.put(MqttJMSClientContainer.MQTT_CLIENT_NAME, Arrays.asList("ecf.jms.mqtt.manager"));
        }

        public Instantiator() {
            super(exporters, exporterToImportersMap);
        }

        @Override
        protected IContainer createMqttContainer(JMSContainerConfig config, MqttConnectOptions options, int qos, Map<String, ?> parameters) throws Exception {
            return new MqttJMSClientContainer(config, options, qos);
        }

        @Override
        protected JMSID createContainerID(Map<String, ?> parameters) throws Exception {
            return this.getJMSIDFromParameter(parameters, UUID.randomUUID().toString());
        }
    }
}

