/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient4;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransfer;
import org.eclipse.ecf.filetransfer.IFileTransferPausable;
import org.eclipse.ecf.filetransfer.IFileTransferRunnable;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferOptions;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.InvalidFileRangeSpecificationException;
import org.eclipse.ecf.filetransfer.events.IFileTransferConnectStartEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.socket.ISocketEventSource;
import org.eclipse.ecf.filetransfer.events.socket.ISocketListener;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.ConnectingSocketMonitor;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.ECFHttpClientProtocolSocketFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.ECFHttpClientSecureProtocolSocketFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.HttpClientProxyCredentialProvider;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.ISSLSocketFactoryModifier;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient4.Messages;
import org.eclipse.ecf.provider.filetransfer.events.socket.SocketEventSource;
import org.eclipse.ecf.provider.filetransfer.httpclient4.HttpClientDefaultSSLSocketFactoryModifier;
import org.eclipse.ecf.provider.filetransfer.httpclient4.HttpClientOptions;
import org.eclipse.ecf.provider.filetransfer.httpclient4.NTLMProxyDetector;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferID;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.retrieve.HttpHelper;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.osgi.util.NLS;

public class HttpClientRetrieveFileTransfer
extends AbstractRetrieveFileTransfer {
    private static final String USERNAME_PREFIX = Messages.HttpClientRetrieveFileTransfer_Username_Prefix;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_CONNECTION_TIMEOUT;
    protected static final int DEFAULT_READ_TIMEOUT = HttpClientOptions.RETRIEVE_DEFAULT_READ_TIMEOUT;
    protected static final int HTTP_PORT = 80;
    protected static final int HTTPS_PORT = 443;
    protected static final int MAX_RETRY = 2;
    protected static final String HTTPS = Messages.FileTransferNamespace_Https_Protocol;
    protected static final String HTTP = Messages.FileTransferNamespace_Http_Protocol;
    protected static final String[] supportedProtocols = new String[]{HTTP, HTTPS};
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private HttpGet getMethod = null;
    private HttpResponse httpResponse = null;
    private HttpContext httpContext = null;
    private DefaultHttpClient httpClient = null;
    private String username;
    private String password;
    private int responseCode = -1;
    private volatile boolean doneFired = false;
    private String remoteFileName;
    protected int httpVersion = 1;
    protected IFileID fileid = null;
    protected JREProxyHelper proxyHelper = null;
    private SocketEventSource socketEventSource;
    private ConnectingSocketMonitor connectingSockets;
    private FileTransferJob connectJob;
    private IFileTransferRunnable fileConnectRunnable = new IFileTransferRunnable(){

        public IStatus performFileTransfer(IProgressMonitor monitor) {
            return HttpClientRetrieveFileTransfer.this.performConnect(monitor);
        }
    };

    public HttpClientRetrieveFileTransfer(DefaultHttpClient httpClient) {
        this.httpClient = httpClient;
        Assert.isNotNull((Object)this.httpClient);
        this.httpClient.setCredentialsProvider((CredentialsProvider)new ECFCredentialsProvider());
        this.proxyHelper = new JREProxyHelper();
        this.connectingSockets = new ConnectingSocketMonitor(1);
        this.socketEventSource = new SocketEventSource(){

            public Object getAdapter(Class adapter) {
                if (adapter == null) {
                    return null;
                }
                if (adapter.isInstance((Object)this)) {
                    return this;
                }
                return HttpClientRetrieveFileTransfer.this.getAdapter(adapter);
            }
        };
        this.registerSchemes((ISocketEventSource)this.socketEventSource, this.connectingSockets);
    }

    private void registerSchemes(ISocketEventSource source, ISocketListener socketListener) {
        SchemeRegistry schemeRegistry = this.httpClient.getConnectionManager().getSchemeRegistry();
        Scheme http = new Scheme(HTTP, 80, (SchemeSocketFactory)new ECFHttpClientProtocolSocketFactory(SocketFactory.getDefault(), source, socketListener));
        Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"registering http scheme");
        schemeRegistry.register(http);
        ISSLSocketFactoryModifier sslSocketFactoryModifier = Activator.getDefault().getSSLSocketFactoryModifier();
        if (sslSocketFactoryModifier == null) {
            sslSocketFactoryModifier = new HttpClientDefaultSSLSocketFactoryModifier();
        }
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslSocketFactory = sslSocketFactoryModifier.getSSLSocketFactory();
        }
        catch (IOException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/catching", ISSLSocketFactoryModifier.class, (String)"getSSLSocketFactory()", (Throwable)e);
            Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/throwing", HttpClientRetrieveFileTransfer.class, (String)"registerSchemes()", (Throwable)e);
            throw new ECFRuntimeException("Unable to instantiate schemes for HttpClient.", (Throwable)e);
        }
        Scheme https = new Scheme(HTTPS, 443, (SchemeSocketFactory)new ECFHttpClientSecureProtocolSocketFactory(sslSocketFactory, source, socketListener));
        Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("registering https scheme; modifier=" + sslSocketFactoryModifier));
        schemeRegistry.register(https);
        ArrayList<String> authpref = new ArrayList<String>(3);
        authpref.add("NTLM");
        authpref.add("Digest");
        authpref.add("Basic");
        this.httpClient.getParams().setParameter("http.auth.proxy-scheme-pref", authpref);
        this.httpClient.getParams().setParameter("http.auth.target-scheme-pref", authpref);
    }

    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancel() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"cancel");
        if (this.isCanceled()) {
            return;
        }
        this.setDoneCanceled(this.exception);
        boolean fireDoneEvent = true;
        if (this.connectJob != null) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"calling connectJob.cancel()");
            this.connectJob.cancel();
        }
        Object object = this.jobLock;
        synchronized (object) {
            if (this.job != null) {
                fireDoneEvent = false;
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"calling transfer job.cancel()");
                this.job.cancel();
            }
        }
        if (this.getMethod != null && !this.getMethod.isAborted()) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"calling getMethod.abort()");
            this.getMethod.abort();
        }
        if (this.connectingSockets != null) {
            this.connectingSockets.closeSockets();
        }
        this.hardClose();
        if (fireDoneEvent) {
            this.fireTransferReceiveDoneEvent();
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"cancel");
    }

    protected void hardClose() {
        if (this.getMethod != null) {
            if (!this.isDone() && this.isPaused()) {
                this.getMethod.abort();
            }
            this.getMethod = null;
        }
        try {
            if (this.localFileContents != null && this.closeOutputStream) {
                this.localFileContents.close();
            }
        }
        catch (IOException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer.httpclient4", 4, "hardClose", (Throwable)e));
        }
        this.remoteFileContents = null;
        this.localFileContents = null;
        this.responseCode = -1;
        if (this.proxyHelper != null && this.isDone()) {
            this.proxyHelper.dispose();
            this.proxyHelper = null;
        }
    }

    protected Credentials getFileRequestCredentials() throws UnsupportedCallbackException, IOException {
        if (this.connectContext == null) {
            return null;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return null;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        this.password = (String)passwordCallback.getObject();
        return new UsernamePasswordCredentials(this.username, this.password);
    }

    protected void setupProxies() {
        if (this.proxy == null) {
            try {
                this.proxy = ProxySetupHelper.getSocksProxy((URL)this.getRemoteFileURL());
                if (this.proxy == null) {
                    this.proxy = ProxySetupHelper.getProxy((String)this.getRemoteFileURL().toExternalForm());
                }
            }
            catch (NoClassDefFoundError e) {
                Activator.logNoProxyWarning(e);
            }
        }
        if (this.proxy != null) {
            this.setupProxy(this.proxy);
        }
    }

    protected synchronized void resetDoneAndException() {
        this.clearProxy();
        super.resetDoneAndException();
    }

    protected void setupAuthentication(String urlString) throws UnsupportedCallbackException, IOException {
        Credentials credentials = null;
        if (this.username == null) {
            credentials = this.getFileRequestCredentials();
        }
        if (credentials != null && this.username != null) {
            AuthScope authScope = new AuthScope(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString), AuthScope.ANY_REALM);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("retrieve credentials=" + credentials));
            this.httpClient.getCredentialsProvider().setCredentials(authScope, credentials);
        }
    }

    protected void setRequestHeaderValues() throws InvalidFileRangeSpecificationException {
        IFileRangeSpecification rangeSpec = this.getFileRangeSpecification();
        if (rangeSpec != null) {
            long startPosition = rangeSpec.getStartPosition();
            long endPosition = rangeSpec.getEndPosition();
            if (startPosition < 0L) {
                throw new InvalidFileRangeSpecificationException(Messages.HttpClientRetrieveFileTransfer_RESUME_START_POSITION_LESS_THAN_ZERO, rangeSpec);
            }
            if (endPosition != -1L && endPosition <= startPosition) {
                throw new InvalidFileRangeSpecificationException(Messages.HttpClientRetrieveFileTransfer_RESUME_ERROR_END_POSITION_LESS_THAN_START, rangeSpec);
            }
            String rangeHeader = "bytes=" + startPosition + "-" + (endPosition == -1L ? "" : "" + endPosition);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("retrieve range header=" + rangeHeader));
            this.setRangeHeader(rangeHeader);
        }
        this.getMethod.addHeader("Cache-Control", "max-age=0");
        this.setRequestHeaderValuesFromOptions();
    }

    private void setRequestHeaderValuesFromOptions() {
        Object o;
        Map localOptions = this.getOptions();
        if (localOptions != null && (o = localOptions.get(IRetrieveFileTransferOptions.REQUEST_HEADERS)) != null && o instanceof Map) {
            Map requestHeaders = (Map)o;
            for (Object n : requestHeaders.keySet()) {
                Object v = requestHeaders.get(n);
                if (n == null || !(n instanceof String) || v == null || !(v instanceof String)) continue;
                this.getMethod.addHeader((String)n, (String)v);
            }
        }
    }

    private void setRangeHeader(String value) {
        this.getMethod.addHeader("Range", value);
    }

    private boolean isHTTP11() {
        return this.httpVersion >= 1;
    }

    public int getResponseCode() {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        ProtocolVersion version = this.getMethod.getProtocolVersion();
        if (version == null) {
            this.responseCode = -1;
            this.httpVersion = 1;
            return this.responseCode;
        }
        this.httpVersion = version.getMinor();
        this.responseCode = this.httpResponse.getStatusLine().getStatusCode();
        return this.responseCode;
    }

    public ID getID() {
        return this.fileid;
    }

    private long getLastModifiedTimeFromHeader() throws IOException {
        Header lastModifiedHeader = this.httpResponse.getLastHeader(LAST_MODIFIED_HEADER);
        if (lastModifiedHeader == null) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_INVALID_LAST_MODIFIED_TIME);
        }
        String lastModifiedString = lastModifiedHeader.getValue();
        long lastModified = 0L;
        if (lastModifiedString != null) {
            try {
                lastModified = DateUtils.parseDate((String)lastModifiedString).getTime();
            }
            catch (Exception e) {
                throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPITION_INVALID_LAST_MODIFIED_FROM_SERVER);
            }
        }
        return lastModified;
    }

    protected void getResponseHeaderValues() throws IOException {
        if (this.getResponseCode() == -1) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_INVALID_SERVER_RESPONSE_TO_PARTIAL_RANGE_REQUEST);
        }
        Header lastModifiedHeader = this.httpResponse.getLastHeader(LAST_MODIFIED_HEADER);
        if (lastModifiedHeader != null) {
            this.setLastModifiedTime(this.getLastModifiedTimeFromHeader());
        }
        this.setFileLength(this.httpResponse.getEntity().getContentLength());
        this.fileid = new FileTransferID(this.getRetrieveNamespace(), this.getRemoteFileURL());
        Header contentDispositionHeader = this.httpResponse.getLastHeader("Content-Disposition");
        if (contentDispositionHeader != null) {
            this.remoteFileName = HttpHelper.getRemoteFileNameFromContentDispositionHeader((String)contentDispositionHeader.getValue());
        }
        if (this.remoteFileName == null) {
            IPath path;
            String pathStr = this.getMethod.getRequestLine().getUri();
            if (pathStr != null && pathStr.length() > 0 && (path = Path.fromPortableString((String)pathStr)).segmentCount() > 0) {
                this.remoteFileName = path.lastSegment();
            }
            if (this.remoteFileName == null) {
                this.remoteFileName = super.getRemoteFileName();
            }
        }
    }

    Proxy getProxy() {
        return this.proxy;
    }

    protected void setInputStream(InputStream ins) {
        this.remoteFileContents = ins;
    }

    protected InputStream wrapTransferReadInputStream(InputStream inputStream, IProgressMonitor monitor) {
        return new NoCloseWrapperInputStream(inputStream);
    }

    protected boolean hasForceNTLMProxyOption() {
        Map localOptions = this.getOptions();
        if (localOptions != null && localOptions.get("org.eclipse.ecf.provider.filetransfer.httpclient4.options.ForceNTLMProxy") != null) {
            return true;
        }
        return System.getProperties().getProperty("org.eclipse.ecf.provider.filetransfer.httpclient4.options.ForceNTLMProxy") != null;
    }

    protected int getSocketReadTimeout() {
        int result = DEFAULT_READ_TIMEOUT;
        Map localOptions = this.getOptions();
        if (localOptions != null) {
            Object o = localOptions.get(IRetrieveFileTransferOptions.READ_TIMEOUT);
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
                return result;
            }
            o = localOptions.get("org.eclipse.ecf.provider.filetransfer.httpclient4.retrieve.readTimeout");
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
            }
        }
        return result;
    }

    protected int getConnectTimeout() {
        int result = DEFAULT_CONNECTION_TIMEOUT;
        Map localOptions = this.getOptions();
        if (localOptions != null) {
            Object o = localOptions.get(IRetrieveFileTransferOptions.CONNECT_TIMEOUT);
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
                return result;
            }
            o = localOptions.get("org.eclipse.ecf.provider.filetransfer.httpclient4.retrieve.connectTimeout");
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
            }
        }
        return result;
    }

    protected void openStreams() throws IncomingFileTransferException {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"openStreams");
        String urlString = this.getRemoteFileURL().toString();
        this.doneFired = false;
        int code = -1;
        try {
            this.httpClient.getParams().setIntParameter("http.socket.timeout", this.getSocketReadTimeout());
            int connectTimeout = this.getConnectTimeout();
            this.httpClient.getParams().setIntParameter("http.connection.timeout", connectTimeout);
            this.setupAuthentication(urlString);
            this.getMethod = new HttpGet(urlString);
            this.setRequestHeaderValues();
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("retrieve=" + urlString));
            if (this.getFileRangeSpecification() == null && !this.targetHasGzSuffix(super.getRemoteFileName())) {
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"Accept-Encoding: gzip,deflate added to request header");
                this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new RequestAcceptEncoding());
                this.httpClient.addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
            } else {
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"Accept-Encoding NOT added to header");
            }
            this.fireConnectStartEvent();
            if (this.checkAndHandleDone()) {
                return;
            }
            this.connectingSockets.clear();
            if (this.connectJob == null) {
                this.performConnect((IProgressMonitor)new NullProgressMonitor());
            } else {
                this.connectJob.schedule();
                this.connectJob.join();
                this.connectJob = null;
            }
            if (this.checkAndHandleDone()) {
                return;
            }
            code = this.responseCode;
            this.responseHeaders = this.getResponseHeaders();
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("retrieve resp=" + code));
            boolean ntlmProxyFound = NTLMProxyDetector.detectNTLMProxy(this.httpContext);
            if (ntlmProxyFound && !this.hasForceNTLMProxyOption()) {
                throw new IncomingFileTransferException("HttpClient Provider is not configured to support NTLM proxy authentication.", 477);
            }
            if (NTLMProxyDetector.detectSPNEGOProxy(this.httpContext)) {
                throw new BrowseFileTransferException("HttpClient Provider does not support the use of SPNEGO proxy authentication.");
            }
            if (code != 206 && code != 200) {
                if (code == 404) {
                    EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                    throw new IncomingFileTransferException(NLS.bind((String)"File not found: {0}", (Object)urlString), code);
                }
                if (code == 401) {
                    EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                    throw new IncomingFileTransferException(Messages.HttpClientRetrieveFileTransfer_Unauthorized, code);
                }
                if (code == 403) {
                    EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                    throw new IncomingFileTransferException("Forbidden", code);
                }
                if (code == 407) {
                    EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                    throw new IncomingFileTransferException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required, code);
                }
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)EntityUtils.toString((HttpEntity)this.httpResponse.getEntity()));
                throw new IncomingFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)new Integer(code)), code);
            }
            this.getResponseHeaderValues();
            this.setInputStream(this.httpResponse.getEntity().getContent());
            this.fireReceiveStartEvent();
        }
        catch (Exception e) {
            Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/throwing", ((Object)((Object)this)).getClass(), (String)"openStreams", (Throwable)e);
            if (code == -1) {
                if (!this.isDone()) {
                    this.setDoneException(e);
                }
                this.fireTransferReceiveDoneEvent();
            }
            IncomingFileTransferException ex = (IncomingFileTransferException)(e instanceof IncomingFileTransferException ? e : new IncomingFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)urlString), (Throwable)e, code));
            throw ex;
        }
        Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"openStreams");
    }

    private Map getResponseHeaders() {
        if (this.getMethod == null) {
            return null;
        }
        Header[] headers = this.httpResponse.getAllHeaders();
        HashMap<String, String> result = null;
        if (headers != null && headers.length > 0) {
            result = new HashMap<String, String>();
            int i = 0;
            while (i < headers.length) {
                String name = headers[i].getName();
                String val = headers[i].getValue();
                if (name != null && val != null) {
                    result.put(name, val);
                }
                ++i;
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private boolean checkAndHandleDone() {
        if (this.isDone()) {
            if (!this.doneFired) {
                this.fireTransferReceiveDoneEvent();
            }
            return true;
        }
        return false;
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        super.setConnectContextForAuthentication(connectContext);
        this.username = null;
        this.password = null;
    }

    protected static String getHostFromURL(String url) {
        String result = url;
        int colonSlashSlash = url.indexOf("://");
        if (colonSlashSlash < 0) {
            return "";
        }
        if (colonSlashSlash >= 0) {
            result = url.substring(colonSlashSlash + 3);
        }
        int colonPort = result.indexOf(58);
        int requestPath = result.indexOf(47);
        int substringEnd = colonPort > 0 && requestPath > 0 ? Math.min(colonPort, requestPath) : (colonPort > 0 ? colonPort : (requestPath > 0 ? requestPath : result.length()));
        return result.substring(0, substringEnd);
    }

    protected static int getPortFromURL(String url) {
        int colonSlashSlash = url.indexOf("://");
        if (colonSlashSlash < 0) {
            return HttpClientRetrieveFileTransfer.urlUsesHttps(url) ? 443 : 80;
        }
        int colonPort = url.indexOf(58, colonSlashSlash + 1);
        if (colonPort < 0) {
            return HttpClientRetrieveFileTransfer.urlUsesHttps(url) ? 443 : 80;
        }
        int nextSlash = url.indexOf(47, colonSlashSlash + 3);
        if (nextSlash != -1 && colonPort > nextSlash) {
            return HttpClientRetrieveFileTransfer.urlUsesHttps(url) ? 443 : 80;
        }
        int atServer = url.indexOf(64, colonSlashSlash + 1);
        if (atServer != -1 && colonPort < atServer && atServer < nextSlash) {
            colonPort = url.indexOf(58, atServer + 1);
        }
        if (colonPort < 0) {
            return HttpClientRetrieveFileTransfer.urlUsesHttps(url) ? 443 : 80;
        }
        int requestPath = url.indexOf(47, colonPort + 1);
        int end = requestPath < 0 ? url.length() : requestPath;
        return Integer.parseInt(url.substring(colonPort + 1, end));
    }

    protected static boolean urlUsesHttps(String url) {
        url = url.trim();
        return url.startsWith(HTTPS);
    }

    public static boolean supportsProtocol(String protocolString) {
        int i = 0;
        while (i < supportedProtocols.length) {
            if (supportedProtocols[i].equalsIgnoreCase(protocolString)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isConnected() {
        return this.getMethod != null;
    }

    protected boolean doPause() {
        if (this.isPaused() || !this.isConnected() || this.isDone()) {
            return false;
        }
        this.paused = true;
        return this.paused;
    }

    protected boolean doResume() {
        if (!this.isPaused() || this.isConnected()) {
            return false;
        }
        return this.openStreamsForResume();
    }

    protected void setResumeRequestHeaderValues() throws IOException {
        if (this.bytesReceived <= 0L || this.fileLength <= this.bytesReceived) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_RESUME_START_ERROR);
        }
        this.setRangeHeader("bytes=" + this.bytesReceived + "-");
        this.getMethod.addHeader("Cache-Control", "max-age=0");
        this.setRequestHeaderValuesFromOptions();
    }

    private boolean openStreamsForResume() {
        int code;
        String urlString;
        block15: {
            block14: {
                Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"openStreamsForResume");
                urlString = this.getRemoteFileURL().toString();
                this.doneFired = false;
                code = -1;
                try {
                    this.httpClient.getParams().setIntParameter("http.socket.timeout", this.getSocketReadTimeout());
                    int connectTimeout = this.getConnectTimeout();
                    this.httpClient.getParams().setIntParameter("http.connection.timeout", connectTimeout);
                    this.setupAuthentication(urlString);
                    this.getMethod = new HttpGet(urlString);
                    this.setResumeRequestHeaderValues();
                    Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("resume=" + urlString));
                    this.fireConnectStartEvent();
                    if (!this.checkAndHandleDone()) break block14;
                    return false;
                }
                catch (Exception e) {
                    Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)"openStreamsForResume", (Throwable)e);
                    if (code == -1) {
                        if (!this.isDone()) {
                            this.setDoneException(e);
                        }
                    } else {
                        this.setDoneException(e instanceof IncomingFileTransferException ? e : new IncomingFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)urlString), (Throwable)e, code, this.responseHeaders));
                    }
                    this.fireTransferReceiveDoneEvent();
                    Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"openStreamsForResume", (Object)Boolean.FALSE);
                    return false;
                }
            }
            this.connectingSockets.clear();
            if (this.connectJob == null) {
                this.performConnect((IProgressMonitor)new NullProgressMonitor());
            } else {
                this.connectJob.schedule();
                this.connectJob.join();
                this.connectJob = null;
            }
            if (!this.checkAndHandleDone()) break block15;
            return false;
        }
        code = this.responseCode;
        this.responseHeaders = this.getResponseHeaders();
        Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("retrieve resp=" + code));
        if (code != 206 && code != 200) {
            if (code == 404) {
                EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                throw new IncomingFileTransferException(NLS.bind((String)"File not found: {0}", (Object)urlString), code, this.responseHeaders);
            }
            if (code == 401) {
                EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                throw new IncomingFileTransferException(Messages.HttpClientRetrieveFileTransfer_Unauthorized, code, this.responseHeaders);
            }
            if (code == 403) {
                EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                throw new IncomingFileTransferException("Forbidden", code, this.responseHeaders);
            }
            if (code == 407) {
                EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
                throw new IncomingFileTransferException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required, code, this.responseHeaders);
            }
            EntityUtils.consume((HttpEntity)this.httpResponse.getEntity());
            throw new IncomingFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)new Integer(code)), code, this.responseHeaders);
        }
        this.getResumeResponseHeaderValues();
        this.setInputStream(this.httpResponse.getEntity().getContent());
        this.paused = false;
        this.fireReceiveResumedEvent();
        Trace.exiting((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"openStreamsForResume", (Object)Boolean.TRUE);
        return true;
    }

    protected void getResumeResponseHeaderValues() throws IOException {
        if (this.getResponseCode() != 206) {
            throw new IOException();
        }
        if (this.lastModifiedTime != this.getLastModifiedTimeFromHeader()) {
            throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPTION_FILE_MODIFIED_SINCE_LAST_ACCESS);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.equals(IFileTransferPausable.class) && this.isHTTP11()) {
            return this;
        }
        if (adapter.equals(ISocketEventSource.class)) {
            return this.socketEventSource;
        }
        return super.getAdapter(adapter);
    }

    protected void setupProxy(Proxy proxy) {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", HttpClientRetrieveFileTransfer.class, (String)("setupProxy " + proxy));
        if (proxy.getType().equals(Proxy.Type.HTTP)) {
            ProxyAddress address = proxy.getAddress();
            ConnRouteParams.setDefaultProxy((HttpParams)this.httpClient.getParams(), (HttpHost)new HttpHost(address.getHostName(), address.getPort()));
        } else if (proxy.getType().equals(Proxy.Type.SOCKS)) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("retrieve socksproxy=" + proxy.getAddress()));
            this.proxyHelper.setupProxy(proxy);
        }
    }

    protected void clearProxy() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", HttpClientRetrieveFileTransfer.class, (String)"clearProxy()");
        ConnRouteParams.setDefaultProxy((HttpParams)this.httpClient.getParams(), null);
    }

    public static NTCredentials createNTLMCredentials(Proxy p) {
        if (p == null) {
            return null;
        }
        String un = HttpClientRetrieveFileTransfer.getNTLMUserName(p);
        String domain = HttpClientRetrieveFileTransfer.getNTLMDomainName(p);
        if (un == null || domain == null) {
            return null;
        }
        String workstation = null;
        try {
            workstation = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/catching", HttpClientRetrieveFileTransfer.class, (String)"createNTLMCredentials", (Throwable)e);
        }
        return new NTCredentials(un, p.getPassword(), workstation, domain);
    }

    protected static String getNTLMDomainName(Proxy p) {
        String domainUsername = p.getUsername();
        if (domainUsername == null) {
            return null;
        }
        int slashloc = domainUsername.indexOf(92);
        if (slashloc == -1) {
            return null;
        }
        return domainUsername.substring(0, slashloc);
    }

    protected static String getNTLMUserName(Proxy p) {
        String domainUsername = p.getUsername();
        if (domainUsername == null) {
            return null;
        }
        int slashloc = domainUsername.indexOf(92);
        if (slashloc == -1) {
            return null;
        }
        return domainUsername.substring(slashloc + 1);
    }

    protected void fireConnectStartEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"fireConnectStartEvent");
        this.listener.handleTransferEvent((IFileTransferEvent)new IFileTransferConnectStartEvent(){

            public IFileID getFileID() {
                return HttpClientRetrieveFileTransfer.this.remoteFileID;
            }

            public void cancel() {
                HttpClientRetrieveFileTransfer.this.cancel();
            }

            public FileTransferJob prepareConnectJob(FileTransferJob j) {
                return HttpClientRetrieveFileTransfer.this.prepareConnectJob(j);
            }

            public void connectUsingJob(FileTransferJob j) {
                HttpClientRetrieveFileTransfer.this.connectUsingJob(j);
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("IFileTransferConnectStartEvent[");
                sb.append(this.getFileID());
                sb.append("]");
                return sb.toString();
            }

            public Object getAdapter(Class adapter) {
                return HttpClientRetrieveFileTransfer.this.getAdapter(adapter);
            }
        });
    }

    protected String createConnectJobName() {
        return String.valueOf(this.getRemoteFileURL().toString()) + this.createRangeName() + Messages.HttpClientRetrieveFileTransfer_CONNECTING_JOB_NAME;
    }

    protected FileTransferJob prepareConnectJob(FileTransferJob cjob) {
        if (cjob == null) {
            cjob = new FileTransferJob(this.createJobName());
        }
        cjob.setFileTransfer((IFileTransfer)this);
        cjob.setFileTransferRunnable(this.fileConnectRunnable);
        return cjob;
    }

    protected void connectUsingJob(FileTransferJob cjob) {
        Assert.isNotNull((Object)cjob);
        this.connectJob = cjob;
    }

    private IStatus performConnect(IProgressMonitor monitor) {
        int ticks = 1;
        monitor.beginTask(String.valueOf(this.getRemoteFileURL().toString()) + Messages.HttpClientRetrieveFileTransfer_CONNECTING_TASK_NAME, ticks);
        try {
            try {
                if (monitor.isCanceled()) {
                    throw this.newUserCancelledException();
                }
                this.httpContext = new BasicHttpContext();
                this.httpResponse = this.httpClient.execute((HttpUriRequest)this.getMethod, this.httpContext);
                this.responseCode = this.httpResponse.getStatusLine().getStatusCode();
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)("retrieve resp=" + this.responseCode));
            }
            catch (Exception e) {
                Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)"performConnect", (Throwable)e);
                if (!this.isDone()) {
                    this.setDoneException(e);
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.httpClient != null) {
                this.httpClient.getConnectionManager().shutdown();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void fireReceiveResumedEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)("fireReceiveResumedEvent len=" + this.fileLength + ";rcvd=" + this.bytesReceived));
        super.fireReceiveResumedEvent();
    }

    protected void fireTransferReceiveDataEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)("fireTransferReceiveDataEvent len=" + this.fileLength + ";rcvd=" + this.bytesReceived));
        super.fireTransferReceiveDataEvent();
    }

    protected void fireTransferReceiveDoneEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)("fireTransferReceiveDoneEvent len=" + this.fileLength + ";rcvd=" + this.bytesReceived));
        this.doneFired = true;
        super.fireTransferReceiveDoneEvent();
    }

    protected void fireTransferReceivePausedEvent() {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)("fireTransferReceivePausedEvent len=" + this.fileLength + ";rcvd=" + this.bytesReceived));
        super.fireTransferReceivePausedEvent();
    }

    final class ECFCredentialsProvider
    extends HttpClientProxyCredentialProvider {
        ECFCredentialsProvider() {
        }

        protected Proxy getECFProxy() {
            return HttpClientRetrieveFileTransfer.this.getProxy();
        }

        protected Credentials getNTLMCredentials(Proxy lp) {
            if (HttpClientRetrieveFileTransfer.this.hasForceNTLMProxyOption()) {
                return HttpClientRetrieveFileTransfer.createNTLMCredentials(lp);
            }
            return null;
        }
    }

    class NoCloseWrapperInputStream
    extends FilterInputStream {
        protected NoCloseWrapperInputStream(InputStream in) {
            super(in);
        }

        public void close() {
        }
    }
}

