/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.rest.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.remoteservice.rest.Activator;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.AbstractClientService;
import org.eclipse.ecf.remoteservice.client.IRemoteCallParameter;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.IRemoteCallableRequestType;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.rest.IRestCall;
import org.eclipse.ecf.remoteservice.rest.RestException;
import org.eclipse.ecf.remoteservice.rest.client.AbstractEntityRequestType;
import org.eclipse.ecf.remoteservice.rest.client.AbstractRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpDeleteRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpGetRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpPostRequestType;
import org.eclipse.ecf.remoteservice.rest.client.HttpPutRequestType;
import org.eclipse.ecf.remoteservice.rest.client.RestClientContainer;

public class RestClientService
extends AbstractClientService {
    protected static final int DEFAULT_RESPONSE_BUFFER_SIZE = 1024;
    protected static final String DEFAULT_HTTP_CONTENT_CHARSET = "UTF-8";
    private static final String CONNECTION_MANAGER_TIMEOUT = "http.connection-manager.timeout";
    protected HttpClient httpClient = new DefaultHttpClient();
    protected int responseBufferSize = 1024;

    public RestClientService(RestClientContainer container, RemoteServiceClientRegistration registration) {
        super((AbstractClientContainer)container, registration);
    }

    private boolean isResponseOk(HttpResponse response) {
        int isOkCode = response.getStatusLine().getStatusCode() - 200;
        return isOkCode >= 0 && isOkCode < 100;
    }

    protected Object invokeRemoteCall(IRemoteCall call, IRemoteCallable callable) throws ECFException {
        String uri = this.prepareEndpointAddress(call, callable);
        HttpRequestBase httpMethod = this.createAndPrepareHttpMethod(uri, call, callable);
        byte[] responseBody = null;
        int responseCode = 500;
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)httpMethod);
            responseCode = response.getStatusLine().getStatusCode();
            if (this.isResponseOk(response)) {
                responseBody = this.getResponseAsBytes(response);
            } else {
                if (this.retrieveErrorResponseBody(response)) {
                    responseBody = this.getResponseAsBytes(response);
                }
                this.handleException("Http response not OK.  URL=" + uri + " responseCode=" + new Integer(responseCode), null, responseCode, responseBody);
            }
        }
        catch (IOException e) {
            this.handleException("Transport IOException", e, responseCode);
        }
        Object result = null;
        try {
            result = this.processResponse(uri, call, callable, this.convertResponseHeaders(response.getAllHeaders()), responseBody);
        }
        catch (NotSerializableException e) {
            this.handleException("Exception deserializing response.  URL=" + uri + " responseCode=" + new Integer(responseCode), e, responseCode);
        }
        return result;
    }

    protected boolean retrieveErrorResponseBody(HttpResponse response) {
        return false;
    }

    protected byte[] getResponseAsBytes(HttpResponse response) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        response.getEntity().writeTo((OutputStream)os);
        return os.toByteArray();
    }

    protected void handleException(String message, Throwable e, int responseCode, byte[] responseBody) throws RestException {
        this.logException(message, e);
        throw new RestException(message, e, responseCode, responseBody);
    }

    protected void handleException(String message, Throwable e, int responseCode) throws RestException {
        this.handleException(message, e, responseCode, null);
    }

    protected void setupTimeouts(HttpClient httpClient, IRemoteCall call, IRemoteCallable callable) {
        long callTimeout = call.getTimeout();
        if (callTimeout == IRemoteCall.DEFAULT_TIMEOUT) {
            callTimeout = callable.getDefaultTimeout();
        }
        int timeout = (int)callTimeout;
        httpClient.getParams().setIntParameter("http.socket.timeout", timeout);
        httpClient.getParams().setIntParameter("http.connection.timeout", timeout);
        httpClient.getParams().setIntParameter(CONNECTION_MANAGER_TIMEOUT, timeout);
    }

    private Map convertResponseHeaders(Header[] headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (headers == null) {
            return result;
        }
        int i = 0;
        while (i < headers.length) {
            String name = headers[i].getName();
            String value = headers[i].getValue();
            result.put(name, value);
            ++i;
        }
        return result;
    }

    protected void addRequestHeaders(AbstractHttpMessage httpMethod, IRemoteCall call, IRemoteCallable callable) {
        Map callHeaders;
        Map requestHeaders;
        Map map = requestHeaders = callable.getRequestType() instanceof AbstractRequestType ? ((AbstractRequestType)callable.getRequestType()).getDefaultRequestHeaders() : new HashMap();
        if (requestHeaders == null) {
            requestHeaders = new HashMap();
        }
        if (call instanceof IRestCall && (callHeaders = ((IRestCall)call).getRequestHeaders()) != null) {
            requestHeaders.putAll(requestHeaders);
        }
        Set keySet = requestHeaders.keySet();
        Object[] headers = keySet.toArray();
        int i = 0;
        while (i < headers.length) {
            String key = (String)headers[i];
            String value = (String)requestHeaders.get(key);
            httpMethod.addHeader(key, value);
            ++i;
        }
    }

    protected HttpRequestBase createAndPrepareHttpMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws RestException {
        HttpRequestBase httpMethod;
        block8: {
            httpMethod = null;
            IRemoteCallableRequestType requestType = callable.getRequestType();
            if (requestType == null) {
                throw new RestException("Request type for call cannot be null");
            }
            try {
                if (requestType instanceof HttpGetRequestType) {
                    httpMethod = this.prepareGetMethod(uri, call, callable);
                    break block8;
                }
                if (requestType instanceof HttpPostRequestType) {
                    httpMethod = this.preparePostMethod(uri, call, callable);
                    break block8;
                }
                if (requestType instanceof HttpPutRequestType) {
                    httpMethod = this.preparePutMethod(uri, call, callable);
                    break block8;
                }
                if (requestType instanceof HttpDeleteRequestType) {
                    httpMethod = this.prepareDeleteMethod(uri, call, callable);
                    break block8;
                }
                throw new RestException("HTTP method " + requestType + " not supported");
            }
            catch (NotSerializableException e) {
                String message = "Could not serialize parameters for uri=" + uri + " call=" + call + " callable=" + callable;
                this.logException(message, e);
                throw new RestException(message);
            }
            catch (UnsupportedEncodingException e) {
                String message = "Could not serialize parameters for uri=" + uri + " call=" + call + " callable=" + callable;
                this.logException(message, e);
                throw new RestException(message);
            }
        }
        this.addRequestHeaders((AbstractHttpMessage)httpMethod, call, callable);
        this.setupAuthenticaton(this.httpClient, httpMethod);
        this.httpClient.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)new Boolean(true));
        this.httpClient.getParams().setParameter("http.protocol.content-charset", (Object)DEFAULT_HTTP_CONTENT_CHARSET);
        this.setupTimeouts(this.httpClient, call, callable);
        return httpMethod;
    }

    protected HttpRequestBase prepareDeleteMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws RestException {
        return new HttpDelete(uri);
    }

    protected HttpRequestBase preparePutMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException, UnsupportedEncodingException {
        HttpPut result = new HttpPut(uri);
        HttpPutRequestType putRequestType = (HttpPutRequestType)callable.getRequestType();
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (putRequestType.useRequestEntity()) {
            if (defaultParameters != null && defaultParameters.length > 0 && parameters != null && parameters.length > 0) {
                HttpEntity requestEntity = putRequestType.generateRequestEntity(uri, call, callable, defaultParameters[0], parameters[0]);
                result.setEntity(requestEntity);
            }
        } else {
            NameValuePair[] params = this.toNameValuePairs(uri, call, callable);
            if (params != null) {
                result.setEntity((HttpEntity)this.getUrlEncodedFormEntity(Arrays.asList(params), putRequestType));
            }
        }
        return result;
    }

    protected HttpRequestBase preparePostMethod(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException, UnsupportedEncodingException {
        HttpPost result = new HttpPost(uri);
        HttpPostRequestType postRequestType = (HttpPostRequestType)callable.getRequestType();
        IRemoteCallParameter[] defaultParameters = callable.getDefaultParameters();
        Object[] parameters = call.getParameters();
        if (postRequestType.useRequestEntity()) {
            if (defaultParameters != null && defaultParameters.length > 0 && parameters != null && parameters.length > 0) {
                HttpEntity requestEntity = postRequestType.generateRequestEntity(uri, call, callable, defaultParameters[0], parameters[0]);
                result.setEntity(requestEntity);
            }
        } else {
            NameValuePair[] params = this.toNameValuePairs(uri, call, callable);
            if (params != null) {
                result.setEntity((HttpEntity)this.getUrlEncodedFormEntity(Arrays.asList(params), postRequestType));
            }
        }
        return result;
    }

    protected HttpRequestBase prepareGetMethod(String uri, IRemoteCall call, IRemoteCallable callable) {
        HttpGet result = new HttpGet(uri);
        return result;
    }

    protected UrlEncodedFormEntity getUrlEncodedFormEntity(List list, AbstractEntityRequestType postRequestType) throws UnsupportedEncodingException {
        if (postRequestType.defaultCharset != null) {
            return new UrlEncodedFormEntity(list, postRequestType.defaultCharset);
        }
        return new UrlEncodedFormEntity(list);
    }

    protected NameValuePair[] toNameValuePairs(String uri, IRemoteCall call, IRemoteCallable callable) throws NotSerializableException {
        IRemoteCallParameter[] restParameters = this.prepareParameters(uri, call, callable);
        ArrayList<BasicNameValuePair> nameValueList = new ArrayList<BasicNameValuePair>();
        if (restParameters != null) {
            int i = 0;
            while (i < restParameters.length) {
                String parameterValue = null;
                Object o = restParameters[i].getValue();
                if (o instanceof String) {
                    parameterValue = (String)o;
                } else if (o != null) {
                    parameterValue = o.toString();
                }
                if (parameterValue != null) {
                    nameValueList.add(new BasicNameValuePair(restParameters[i].getName(), parameterValue));
                }
                ++i;
            }
        }
        return nameValueList.toArray(new NameValuePair[nameValueList.size()]);
    }

    protected void setupAuthenticaton(HttpClient httpClient, HttpRequestBase method) {
        IConnectContext connectContext = this.container.getConnectContextForAuthentication();
        if (connectContext != null) {
            NameCallback nameCallback = new NameCallback("");
            ObjectCallback passwordCallback = new ObjectCallback();
            Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
            CallbackHandler callbackHandler = connectContext.getCallbackHandler();
            if (callbackHandler == null) {
                return;
            }
            try {
                callbackHandler.handle(callbacks);
                String username = nameCallback.getName();
                String password = (String)passwordCallback.getObject();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                method.addHeader(new BasicScheme().authenticate((Credentials)credentials, (HttpRequest)method));
            }
            catch (IOException e) {
                this.logException("IOException setting credentials for rest httpclient", e);
            }
            catch (UnsupportedCallbackException e) {
                this.logException("UnsupportedCallbackException setting credentials for rest httpclient", e);
            }
            catch (AuthenticationException e) {
                this.logException("AuthenticationException setting credentials for rest httpclient", e);
            }
        }
    }

    protected void logException(String string, Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(4, "org.eclipse.ecf.remoteservice.rest", string, e));
        }
    }

    protected void logWarning(String string, Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(2, "org.eclipse.ecf.remoteservice.rest", string));
        }
    }
}

