/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.PropertiesUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractMetadataFactory;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IServiceInfoFactory;
import org.osgi.service.remoteserviceadmin.EndpointDescription;

public class ServiceInfoFactory
extends AbstractMetadataFactory
implements IServiceInfoFactory {
    public IServiceInfo createServiceInfo(IDiscoveryAdvertiser advertiser, EndpointDescription endpointDescription) {
        try {
            IServiceTypeID serviceTypeID = this.createServiceTypeID(endpointDescription, advertiser);
            String serviceName = this.createServiceName(endpointDescription, advertiser, serviceTypeID);
            URI uri = this.createURI(endpointDescription, advertiser, serviceTypeID, serviceName);
            IServiceProperties serviceProperties = this.createServiceProperties(endpointDescription, advertiser, serviceTypeID, serviceName, uri);
            IServiceInfo newServiceInfo = this.createServiceInfo(uri, serviceName, serviceTypeID, serviceProperties);
            return newServiceInfo;
        }
        catch (Exception e) {
            this.logError("createServiceInfo", "Exception creating service info for endpointDescription=" + endpointDescription + ",advertiser=" + advertiser, e);
            return null;
        }
    }

    protected IServiceInfo createServiceInfo(URI uri, String serviceName, IServiceTypeID serviceTypeID, IServiceProperties serviceProperties) {
        return new ServiceInfo(uri, serviceName, serviceTypeID, serviceProperties);
    }

    protected IServiceProperties createServiceProperties(EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser, IServiceTypeID serviceTypeID, String serviceName, URI uri) {
        ServiceProperties result = new ServiceProperties();
        this.encodeServiceProperties(endpointDescription, (IServiceProperties)result);
        return result;
    }

    protected URI createURI(EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser, IServiceTypeID serviceTypeID, String serviceName) throws URISyntaxException {
        String path = "/" + serviceName;
        String str = endpointDescription.getId();
        URI uri = null;
        try {
            while ((uri = new URI(str)).getHost() == null) {
                String rawSchemeSpecificPart = uri.getRawSchemeSpecificPart();
                if (str.equals(rawSchemeSpecificPart)) {
                    uri = null;
                    break;
                }
                str = rawSchemeSpecificPart;
            }
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        String scheme = "ecfosgirsvc";
        int port = 32565;
        if (uri != null && (port = uri.getPort()) == -1) {
            port = 32565;
        }
        String host = null;
        if (uri != null) {
            host = uri.getHost();
        } else {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                this.logWarning("createURI", "failed to get local host adress, falling back to 'localhost'.", e);
                host = "localhost";
            }
        }
        return new URI(scheme, null, host, port, path, null, null);
    }

    protected String createServiceName(EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser, IServiceTypeID serviceTypeID) {
        String defaultServiceName = this.createDefaultServiceName(endpointDescription, advertiser, serviceTypeID);
        String serviceName = PropertiesUtil.getStringWithDefault(endpointDescription.getProperties(), "ecf.endpoint.discovery.servicename", defaultServiceName);
        return serviceName;
    }

    protected String createDefaultServiceName(EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser, IServiceTypeID serviceTypeID) {
        return "osgirsvc_" + IDFactory.getDefault().createGUID().getName();
    }

    protected IServiceTypeID createServiceTypeID(EndpointDescription endpointDescription, IDiscoveryAdvertiser advertiser) {
        Namespace servicesNamespace = IDFactory.getDefault().getNamespaceByName("ecf.namespace.discovery");
        if (advertiser != null) {
            servicesNamespace = advertiser.getServicesNamespace();
        }
        Map props = endpointDescription.getProperties();
        String[] scopes = PropertiesUtil.getStringArrayWithDefault(props, "ecf.endpoint.discovery.scope", IServiceTypeID.DEFAULT_SCOPE);
        String[] protocols = PropertiesUtil.getStringArrayWithDefault(props, "ecf.endpoint.discovery.protocols", IServiceTypeID.DEFAULT_SCOPE);
        String namingAuthority = PropertiesUtil.getStringWithDefault(props, "ecf.endpoint.discovery.namingauthority", "iana");
        return ServiceIDFactory.getDefault().createServiceTypeID(servicesNamespace, new String[]{"ecfosgirsvc"}, scopes, protocols, namingAuthority);
    }
}

